/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.AggregatedListReservationsHttpRequest;
import com.google.cloud.compute.v1.DeleteReservationHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyReservationHttpRequest;
import com.google.cloud.compute.v1.GetReservationHttpRequest;
import com.google.cloud.compute.v1.InsertReservationHttpRequest;
import com.google.cloud.compute.v1.ListReservationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.ProjectZoneReservationName;
import com.google.cloud.compute.v1.ProjectZoneReservationResourceName;
import com.google.cloud.compute.v1.Reservation;
import com.google.cloud.compute.v1.ReservationAggregatedList;
import com.google.cloud.compute.v1.ReservationClient;
import com.google.cloud.compute.v1.ReservationList;
import com.google.cloud.compute.v1.ResizeReservationHttpRequest;
import com.google.cloud.compute.v1.SetIamPolicyReservationHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsReservationHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonReservationCallableFactory;
import com.google.cloud.compute.v1.stub.ReservationStub;
import com.google.cloud.compute.v1.stub.ReservationStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonReservationStub
extends ReservationStub {
    @InternalApi
    public static final ApiMethodDescriptor<AggregatedListReservationsHttpRequest, ReservationAggregatedList> aggregatedListReservationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.reservations.aggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/aggregated/reservations")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "includeAllScopes", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)ReservationAggregatedList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteReservationHttpRequest, Operation> deleteReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.reservations.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/reservations/{reservation}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneReservationName.newFactory()).setResourceNameField("reservation").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetReservationHttpRequest, Reservation> getReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.reservations.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/reservations/{reservation}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneReservationName.newFactory()).setResourceNameField("reservation").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Reservation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetIamPolicyReservationHttpRequest, Policy> getIamPolicyReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.reservations.getIamPolicy").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/reservations/{resource}/getIamPolicy")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"optionsRequestedPolicyVersion"})).setResourceNameFactory(ProjectZoneReservationResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertReservationHttpRequest, Operation> insertReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.reservations.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/reservations")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListReservationsHttpRequest, ReservationList> listReservationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.reservations.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/reservations")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)ReservationList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ResizeReservationHttpRequest, Operation> resizeReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.reservations.resize").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/reservations/{reservation}/resize")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneReservationName.newFactory()).setResourceNameField("reservation").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SetIamPolicyReservationHttpRequest, Policy> setIamPolicyReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.reservations.setIamPolicy").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/reservations/{resource}/setIamPolicy")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneReservationResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<TestIamPermissionsReservationHttpRequest, TestPermissionsResponse> testIamPermissionsReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.reservations.testIamPermissions").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/reservations/{resource}/testIamPermissions")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneReservationResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)TestPermissionsResponse.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AggregatedListReservationsHttpRequest, ReservationAggregatedList> aggregatedListReservationsCallable;
    private final UnaryCallable<AggregatedListReservationsHttpRequest, ReservationClient.AggregatedListReservationsPagedResponse> aggregatedListReservationsPagedCallable;
    private final UnaryCallable<DeleteReservationHttpRequest, Operation> deleteReservationCallable;
    private final UnaryCallable<GetReservationHttpRequest, Reservation> getReservationCallable;
    private final UnaryCallable<GetIamPolicyReservationHttpRequest, Policy> getIamPolicyReservationCallable;
    private final UnaryCallable<InsertReservationHttpRequest, Operation> insertReservationCallable;
    private final UnaryCallable<ListReservationsHttpRequest, ReservationList> listReservationsCallable;
    private final UnaryCallable<ListReservationsHttpRequest, ReservationClient.ListReservationsPagedResponse> listReservationsPagedCallable;
    private final UnaryCallable<ResizeReservationHttpRequest, Operation> resizeReservationCallable;
    private final UnaryCallable<SetIamPolicyReservationHttpRequest, Policy> setIamPolicyReservationCallable;
    private final UnaryCallable<TestIamPermissionsReservationHttpRequest, TestPermissionsResponse> testIamPermissionsReservationCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonReservationStub create(ReservationStubSettings settings) throws IOException {
        return new HttpJsonReservationStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonReservationStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonReservationStub(ReservationStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonReservationStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonReservationStub(ReservationStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonReservationStub(ReservationStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonReservationCallableFactory());
    }

    protected HttpJsonReservationStub(ReservationStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListReservationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListReservationsMethodDescriptor).build();
        HttpJsonCallSettings deleteReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteReservationMethodDescriptor).build();
        HttpJsonCallSettings getReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getReservationMethodDescriptor).build();
        HttpJsonCallSettings getIamPolicyReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyReservationMethodDescriptor).build();
        HttpJsonCallSettings insertReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertReservationMethodDescriptor).build();
        HttpJsonCallSettings listReservationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listReservationsMethodDescriptor).build();
        HttpJsonCallSettings resizeReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(resizeReservationMethodDescriptor).build();
        HttpJsonCallSettings setIamPolicyReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyReservationMethodDescriptor).build();
        HttpJsonCallSettings testIamPermissionsReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsReservationMethodDescriptor).build();
        this.aggregatedListReservationsCallable = callableFactory.createUnaryCallable(aggregatedListReservationsTransportSettings, settings.aggregatedListReservationsSettings(), clientContext);
        this.aggregatedListReservationsPagedCallable = callableFactory.createPagedCallable(aggregatedListReservationsTransportSettings, settings.aggregatedListReservationsSettings(), clientContext);
        this.deleteReservationCallable = callableFactory.createUnaryCallable(deleteReservationTransportSettings, settings.deleteReservationSettings(), clientContext);
        this.getReservationCallable = callableFactory.createUnaryCallable(getReservationTransportSettings, settings.getReservationSettings(), clientContext);
        this.getIamPolicyReservationCallable = callableFactory.createUnaryCallable(getIamPolicyReservationTransportSettings, settings.getIamPolicyReservationSettings(), clientContext);
        this.insertReservationCallable = callableFactory.createUnaryCallable(insertReservationTransportSettings, settings.insertReservationSettings(), clientContext);
        this.listReservationsCallable = callableFactory.createUnaryCallable(listReservationsTransportSettings, settings.listReservationsSettings(), clientContext);
        this.listReservationsPagedCallable = callableFactory.createPagedCallable(listReservationsTransportSettings, settings.listReservationsSettings(), clientContext);
        this.resizeReservationCallable = callableFactory.createUnaryCallable(resizeReservationTransportSettings, settings.resizeReservationSettings(), clientContext);
        this.setIamPolicyReservationCallable = callableFactory.createUnaryCallable(setIamPolicyReservationTransportSettings, settings.setIamPolicyReservationSettings(), clientContext);
        this.testIamPermissionsReservationCallable = callableFactory.createUnaryCallable(testIamPermissionsReservationTransportSettings, settings.testIamPermissionsReservationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListReservationsHttpRequest, ReservationClient.AggregatedListReservationsPagedResponse> aggregatedListReservationsPagedCallable() {
        return this.aggregatedListReservationsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListReservationsHttpRequest, ReservationAggregatedList> aggregatedListReservationsCallable() {
        return this.aggregatedListReservationsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteReservationHttpRequest, Operation> deleteReservationCallable() {
        return this.deleteReservationCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetReservationHttpRequest, Reservation> getReservationCallable() {
        return this.getReservationCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetIamPolicyReservationHttpRequest, Policy> getIamPolicyReservationCallable() {
        return this.getIamPolicyReservationCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertReservationHttpRequest, Operation> insertReservationCallable() {
        return this.insertReservationCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListReservationsHttpRequest, ReservationClient.ListReservationsPagedResponse> listReservationsPagedCallable() {
        return this.listReservationsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListReservationsHttpRequest, ReservationList> listReservationsCallable() {
        return this.listReservationsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ResizeReservationHttpRequest, Operation> resizeReservationCallable() {
        return this.resizeReservationCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<SetIamPolicyReservationHttpRequest, Policy> setIamPolicyReservationCallable() {
        return this.setIamPolicyReservationCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<TestIamPermissionsReservationHttpRequest, TestPermissionsResponse> testIamPermissionsReservationCallable() {
        return this.testIamPermissionsReservationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

