/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetInterconnectLocationHttpRequest;
import com.google.cloud.compute.v1.InterconnectLocation;
import com.google.cloud.compute.v1.InterconnectLocationList;
import com.google.cloud.compute.v1.InterconnectLocationSettings;
import com.google.cloud.compute.v1.ListInterconnectLocationsHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalInterconnectLocationName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.stub.InterconnectLocationStub;
import com.google.cloud.compute.v1.stub.InterconnectLocationStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class InterconnectLocationClient
implements BackgroundResource {
    private final InterconnectLocationSettings settings;
    private final InterconnectLocationStub stub;

    public static final InterconnectLocationClient create() throws IOException {
        return InterconnectLocationClient.create(InterconnectLocationSettings.newBuilder().build());
    }

    public static final InterconnectLocationClient create(InterconnectLocationSettings settings) throws IOException {
        return new InterconnectLocationClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InterconnectLocationClient create(InterconnectLocationStub stub) {
        return new InterconnectLocationClient(stub);
    }

    protected InterconnectLocationClient(InterconnectLocationSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InterconnectLocationStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InterconnectLocationClient(InterconnectLocationStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InterconnectLocationSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InterconnectLocationStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final InterconnectLocation getInterconnectLocation(ProjectGlobalInterconnectLocationName interconnectLocation) {
        GetInterconnectLocationHttpRequest request = GetInterconnectLocationHttpRequest.newBuilder().setInterconnectLocation(interconnectLocation == null ? null : interconnectLocation.toString()).build();
        return this.getInterconnectLocation(request);
    }

    @BetaApi
    public final InterconnectLocation getInterconnectLocation(String interconnectLocation) {
        GetInterconnectLocationHttpRequest request = GetInterconnectLocationHttpRequest.newBuilder().setInterconnectLocation(interconnectLocation).build();
        return this.getInterconnectLocation(request);
    }

    @BetaApi
    public final InterconnectLocation getInterconnectLocation(GetInterconnectLocationHttpRequest request) {
        return (InterconnectLocation)this.getInterconnectLocationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetInterconnectLocationHttpRequest, InterconnectLocation> getInterconnectLocationCallable() {
        return this.stub.getInterconnectLocationCallable();
    }

    @BetaApi
    public final ListInterconnectLocationsPagedResponse listInterconnectLocations(ProjectName project) {
        ListInterconnectLocationsHttpRequest request = ListInterconnectLocationsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listInterconnectLocations(request);
    }

    @BetaApi
    public final ListInterconnectLocationsPagedResponse listInterconnectLocations(String project) {
        ListInterconnectLocationsHttpRequest request = ListInterconnectLocationsHttpRequest.newBuilder().setProject(project).build();
        return this.listInterconnectLocations(request);
    }

    @BetaApi
    public final ListInterconnectLocationsPagedResponse listInterconnectLocations(ListInterconnectLocationsHttpRequest request) {
        return (ListInterconnectLocationsPagedResponse)((Object)this.listInterconnectLocationsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListInterconnectLocationsHttpRequest, ListInterconnectLocationsPagedResponse> listInterconnectLocationsPagedCallable() {
        return this.stub.listInterconnectLocationsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListInterconnectLocationsHttpRequest, InterconnectLocationList> listInterconnectLocationsCallable() {
        return this.stub.listInterconnectLocationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInterconnectLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocation, ListInterconnectLocationsPage, ListInterconnectLocationsFixedSizeCollection> {
        private ListInterconnectLocationsFixedSizeCollection(List<ListInterconnectLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInterconnectLocationsFixedSizeCollection createEmptyCollection() {
            return new ListInterconnectLocationsFixedSizeCollection(null, 0);
        }

        protected ListInterconnectLocationsFixedSizeCollection createCollection(List<ListInterconnectLocationsPage> pages, int collectionSize) {
            return new ListInterconnectLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInterconnectLocationsPage
    extends AbstractPage<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocation, ListInterconnectLocationsPage> {
        private ListInterconnectLocationsPage(PageContext<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocation> context, InterconnectLocationList response) {
            super(context, (Object)response);
        }

        private static ListInterconnectLocationsPage createEmptyPage() {
            return new ListInterconnectLocationsPage(null, null);
        }

        protected ListInterconnectLocationsPage createPage(PageContext<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocation> context, InterconnectLocationList response) {
            return new ListInterconnectLocationsPage(context, response);
        }

        public ApiFuture<ListInterconnectLocationsPage> createPageAsync(PageContext<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocation> context, ApiFuture<InterconnectLocationList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInterconnectLocationsPagedResponse
    extends AbstractPagedListResponse<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocation, ListInterconnectLocationsPage, ListInterconnectLocationsFixedSizeCollection> {
        public static ApiFuture<ListInterconnectLocationsPagedResponse> createAsync(PageContext<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocation> context, ApiFuture<InterconnectLocationList> futureResponse) {
            ApiFuture<ListInterconnectLocationsPage> futurePage = ListInterconnectLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInterconnectLocationsPage, ListInterconnectLocationsPagedResponse>(){

                public ListInterconnectLocationsPagedResponse apply(ListInterconnectLocationsPage input) {
                    return new ListInterconnectLocationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListInterconnectLocationsPagedResponse(ListInterconnectLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInterconnectLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

