/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.GetRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.InsertRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.ListRegionUrlMapsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionUrlMapName;
import com.google.cloud.compute.v1.RegionUrlMapSettings;
import com.google.cloud.compute.v1.RegionUrlMapsValidateRequest;
import com.google.cloud.compute.v1.UpdateRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.UrlMap;
import com.google.cloud.compute.v1.UrlMapList;
import com.google.cloud.compute.v1.UrlMapsValidateResponse;
import com.google.cloud.compute.v1.ValidateRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.stub.RegionUrlMapStub;
import com.google.cloud.compute.v1.stub.RegionUrlMapStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionUrlMapClient
implements BackgroundResource {
    private final RegionUrlMapSettings settings;
    private final RegionUrlMapStub stub;

    public static final RegionUrlMapClient create() throws IOException {
        return RegionUrlMapClient.create(RegionUrlMapSettings.newBuilder().build());
    }

    public static final RegionUrlMapClient create(RegionUrlMapSettings settings) throws IOException {
        return new RegionUrlMapClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionUrlMapClient create(RegionUrlMapStub stub) {
        return new RegionUrlMapClient(stub);
    }

    protected RegionUrlMapClient(RegionUrlMapSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionUrlMapStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionUrlMapClient(RegionUrlMapStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionUrlMapSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionUrlMapStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteRegionUrlMap(ProjectRegionUrlMapName urlMap, String requestId) {
        DeleteRegionUrlMapHttpRequest request = DeleteRegionUrlMapHttpRequest.newBuilder().setUrlMap(urlMap == null ? null : urlMap.toString()).setRequestId(requestId).build();
        return this.deleteRegionUrlMap(request);
    }

    @BetaApi
    public final Operation deleteRegionUrlMap(String urlMap, String requestId) {
        DeleteRegionUrlMapHttpRequest request = DeleteRegionUrlMapHttpRequest.newBuilder().setUrlMap(urlMap).setRequestId(requestId).build();
        return this.deleteRegionUrlMap(request);
    }

    @BetaApi
    public final Operation deleteRegionUrlMap(DeleteRegionUrlMapHttpRequest request) {
        return (Operation)this.deleteRegionUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionUrlMapHttpRequest, Operation> deleteRegionUrlMapCallable() {
        return this.stub.deleteRegionUrlMapCallable();
    }

    @BetaApi
    public final UrlMap getRegionUrlMap(ProjectRegionUrlMapName urlMap) {
        GetRegionUrlMapHttpRequest request = GetRegionUrlMapHttpRequest.newBuilder().setUrlMap(urlMap == null ? null : urlMap.toString()).build();
        return this.getRegionUrlMap(request);
    }

    @BetaApi
    public final UrlMap getRegionUrlMap(String urlMap) {
        GetRegionUrlMapHttpRequest request = GetRegionUrlMapHttpRequest.newBuilder().setUrlMap(urlMap).build();
        return this.getRegionUrlMap(request);
    }

    @BetaApi
    public final UrlMap getRegionUrlMap(GetRegionUrlMapHttpRequest request) {
        return (UrlMap)this.getRegionUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionUrlMapHttpRequest, UrlMap> getRegionUrlMapCallable() {
        return this.stub.getRegionUrlMapCallable();
    }

    @BetaApi
    public final Operation insertRegionUrlMap(String requestId, ProjectRegionName region, UrlMap urlMapResource) {
        InsertRegionUrlMapHttpRequest request = InsertRegionUrlMapHttpRequest.newBuilder().setRequestId(requestId).setRegion(region == null ? null : region.toString()).setUrlMapResource(urlMapResource).build();
        return this.insertRegionUrlMap(request);
    }

    @BetaApi
    public final Operation insertRegionUrlMap(String requestId, String region, UrlMap urlMapResource) {
        InsertRegionUrlMapHttpRequest request = InsertRegionUrlMapHttpRequest.newBuilder().setRequestId(requestId).setRegion(region).setUrlMapResource(urlMapResource).build();
        return this.insertRegionUrlMap(request);
    }

    @BetaApi
    public final Operation insertRegionUrlMap(InsertRegionUrlMapHttpRequest request) {
        return (Operation)this.insertRegionUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionUrlMapHttpRequest, Operation> insertRegionUrlMapCallable() {
        return this.stub.insertRegionUrlMapCallable();
    }

    @BetaApi
    public final ListRegionUrlMapsPagedResponse listRegionUrlMaps(ProjectRegionName region) {
        ListRegionUrlMapsHttpRequest request = ListRegionUrlMapsHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionUrlMaps(request);
    }

    @BetaApi
    public final ListRegionUrlMapsPagedResponse listRegionUrlMaps(String region) {
        ListRegionUrlMapsHttpRequest request = ListRegionUrlMapsHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionUrlMaps(request);
    }

    @BetaApi
    public final ListRegionUrlMapsPagedResponse listRegionUrlMaps(ListRegionUrlMapsHttpRequest request) {
        return (ListRegionUrlMapsPagedResponse)((Object)this.listRegionUrlMapsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionUrlMapsHttpRequest, ListRegionUrlMapsPagedResponse> listRegionUrlMapsPagedCallable() {
        return this.stub.listRegionUrlMapsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionUrlMapsHttpRequest, UrlMapList> listRegionUrlMapsCallable() {
        return this.stub.listRegionUrlMapsCallable();
    }

    @BetaApi
    public final Operation patchRegionUrlMap(ProjectRegionUrlMapName urlMap, String requestId, UrlMap urlMapResource, List<String> fieldMask) {
        PatchRegionUrlMapHttpRequest request = PatchRegionUrlMapHttpRequest.newBuilder().setUrlMap(urlMap == null ? null : urlMap.toString()).setRequestId(requestId).setUrlMapResource(urlMapResource).addAllFieldMask(fieldMask).build();
        return this.patchRegionUrlMap(request);
    }

    @BetaApi
    public final Operation patchRegionUrlMap(String urlMap, String requestId, UrlMap urlMapResource, List<String> fieldMask) {
        PatchRegionUrlMapHttpRequest request = PatchRegionUrlMapHttpRequest.newBuilder().setUrlMap(urlMap).setRequestId(requestId).setUrlMapResource(urlMapResource).addAllFieldMask(fieldMask).build();
        return this.patchRegionUrlMap(request);
    }

    @BetaApi
    public final Operation patchRegionUrlMap(PatchRegionUrlMapHttpRequest request) {
        return (Operation)this.patchRegionUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchRegionUrlMapHttpRequest, Operation> patchRegionUrlMapCallable() {
        return this.stub.patchRegionUrlMapCallable();
    }

    @BetaApi
    public final Operation updateRegionUrlMap(ProjectRegionUrlMapName urlMap, String requestId, UrlMap urlMapResource, List<String> fieldMask) {
        UpdateRegionUrlMapHttpRequest request = UpdateRegionUrlMapHttpRequest.newBuilder().setUrlMap(urlMap == null ? null : urlMap.toString()).setRequestId(requestId).setUrlMapResource(urlMapResource).addAllFieldMask(fieldMask).build();
        return this.updateRegionUrlMap(request);
    }

    @BetaApi
    public final Operation updateRegionUrlMap(String urlMap, String requestId, UrlMap urlMapResource, List<String> fieldMask) {
        UpdateRegionUrlMapHttpRequest request = UpdateRegionUrlMapHttpRequest.newBuilder().setUrlMap(urlMap).setRequestId(requestId).setUrlMapResource(urlMapResource).addAllFieldMask(fieldMask).build();
        return this.updateRegionUrlMap(request);
    }

    @BetaApi
    public final Operation updateRegionUrlMap(UpdateRegionUrlMapHttpRequest request) {
        return (Operation)this.updateRegionUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateRegionUrlMapHttpRequest, Operation> updateRegionUrlMapCallable() {
        return this.stub.updateRegionUrlMapCallable();
    }

    @BetaApi
    public final UrlMapsValidateResponse validateRegionUrlMap(ProjectRegionUrlMapName urlMap, RegionUrlMapsValidateRequest regionUrlMapsValidateRequestResource) {
        ValidateRegionUrlMapHttpRequest request = ValidateRegionUrlMapHttpRequest.newBuilder().setUrlMap(urlMap == null ? null : urlMap.toString()).setRegionUrlMapsValidateRequestResource(regionUrlMapsValidateRequestResource).build();
        return this.validateRegionUrlMap(request);
    }

    @BetaApi
    public final UrlMapsValidateResponse validateRegionUrlMap(String urlMap, RegionUrlMapsValidateRequest regionUrlMapsValidateRequestResource) {
        ValidateRegionUrlMapHttpRequest request = ValidateRegionUrlMapHttpRequest.newBuilder().setUrlMap(urlMap).setRegionUrlMapsValidateRequestResource(regionUrlMapsValidateRequestResource).build();
        return this.validateRegionUrlMap(request);
    }

    @BetaApi
    public final UrlMapsValidateResponse validateRegionUrlMap(ValidateRegionUrlMapHttpRequest request) {
        return (UrlMapsValidateResponse)this.validateRegionUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ValidateRegionUrlMapHttpRequest, UrlMapsValidateResponse> validateRegionUrlMapCallable() {
        return this.stub.validateRegionUrlMapCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionUrlMapsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionUrlMapsHttpRequest, UrlMapList, UrlMap, ListRegionUrlMapsPage, ListRegionUrlMapsFixedSizeCollection> {
        private ListRegionUrlMapsFixedSizeCollection(List<ListRegionUrlMapsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionUrlMapsFixedSizeCollection createEmptyCollection() {
            return new ListRegionUrlMapsFixedSizeCollection(null, 0);
        }

        protected ListRegionUrlMapsFixedSizeCollection createCollection(List<ListRegionUrlMapsPage> pages, int collectionSize) {
            return new ListRegionUrlMapsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionUrlMapsPage
    extends AbstractPage<ListRegionUrlMapsHttpRequest, UrlMapList, UrlMap, ListRegionUrlMapsPage> {
        private ListRegionUrlMapsPage(PageContext<ListRegionUrlMapsHttpRequest, UrlMapList, UrlMap> context, UrlMapList response) {
            super(context, (Object)response);
        }

        private static ListRegionUrlMapsPage createEmptyPage() {
            return new ListRegionUrlMapsPage(null, null);
        }

        protected ListRegionUrlMapsPage createPage(PageContext<ListRegionUrlMapsHttpRequest, UrlMapList, UrlMap> context, UrlMapList response) {
            return new ListRegionUrlMapsPage(context, response);
        }

        public ApiFuture<ListRegionUrlMapsPage> createPageAsync(PageContext<ListRegionUrlMapsHttpRequest, UrlMapList, UrlMap> context, ApiFuture<UrlMapList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionUrlMapsPagedResponse
    extends AbstractPagedListResponse<ListRegionUrlMapsHttpRequest, UrlMapList, UrlMap, ListRegionUrlMapsPage, ListRegionUrlMapsFixedSizeCollection> {
        public static ApiFuture<ListRegionUrlMapsPagedResponse> createAsync(PageContext<ListRegionUrlMapsHttpRequest, UrlMapList, UrlMap> context, ApiFuture<UrlMapList> futureResponse) {
            ApiFuture<ListRegionUrlMapsPage> futurePage = ListRegionUrlMapsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionUrlMapsPage, ListRegionUrlMapsPagedResponse>(){

                public ListRegionUrlMapsPagedResponse apply(ListRegionUrlMapsPage input) {
                    return new ListRegionUrlMapsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionUrlMapsPagedResponse(ListRegionUrlMapsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionUrlMapsFixedSizeCollection.createEmptyCollection());
        }
    }
}

