/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.PacketMirroring;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PacketMirroringsScopedList
implements ApiMessage {
    private final List<PacketMirroring> packetMirrorings;
    private final Warning warning;
    private static final PacketMirroringsScopedList DEFAULT_INSTANCE = new PacketMirroringsScopedList();

    private PacketMirroringsScopedList() {
        this.packetMirrorings = null;
        this.warning = null;
    }

    private PacketMirroringsScopedList(List<PacketMirroring> packetMirrorings, Warning warning) {
        this.packetMirrorings = packetMirrorings;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("packetMirrorings".equals(fieldName)) {
            return this.packetMirrorings;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<PacketMirroring> getPacketMirroringsList() {
        return this.packetMirrorings;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PacketMirroringsScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PacketMirroringsScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PacketMirroringsScopedList{packetMirrorings=" + this.packetMirrorings + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PacketMirroringsScopedList) {
            PacketMirroringsScopedList that = (PacketMirroringsScopedList)o;
            return Objects.equals(this.packetMirrorings, that.getPacketMirroringsList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.packetMirrorings, this.warning);
    }

    public static class Builder {
        private List<PacketMirroring> packetMirrorings;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(PacketMirroringsScopedList other) {
            if (other == PacketMirroringsScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getPacketMirroringsList() != null) {
                this.packetMirrorings = other.packetMirrorings;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(PacketMirroringsScopedList source) {
            this.packetMirrorings = source.packetMirrorings;
            this.warning = source.warning;
        }

        public List<PacketMirroring> getPacketMirroringsList() {
            return this.packetMirrorings;
        }

        public Builder addAllPacketMirrorings(List<PacketMirroring> packetMirrorings) {
            if (this.packetMirrorings == null) {
                this.packetMirrorings = new LinkedList<PacketMirroring>();
            }
            this.packetMirrorings.addAll(packetMirrorings);
            return this;
        }

        public Builder addPacketMirrorings(PacketMirroring packetMirrorings) {
            if (this.packetMirrorings == null) {
                this.packetMirrorings = new LinkedList<PacketMirroring>();
            }
            this.packetMirrorings.add(packetMirrorings);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public PacketMirroringsScopedList build() {
            return new PacketMirroringsScopedList(this.packetMirrorings, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllPacketMirrorings(this.packetMirrorings);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

