/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HealthStatus
implements ApiMessage {
    private final Map<String, String> annotations;
    private final String healthState;
    private final String instance;
    private final String ipAddress;
    private final Integer port;
    private static final HealthStatus DEFAULT_INSTANCE = new HealthStatus();

    private HealthStatus() {
        this.annotations = null;
        this.healthState = null;
        this.instance = null;
        this.ipAddress = null;
        this.port = null;
    }

    private HealthStatus(Map<String, String> annotations, String healthState, String instance, String ipAddress, Integer port) {
        this.annotations = annotations;
        this.healthState = healthState;
        this.instance = instance;
        this.ipAddress = ipAddress;
        this.port = port;
    }

    public Object getFieldValue(String fieldName) {
        if ("annotations".equals(fieldName)) {
            return this.annotations;
        }
        if ("healthState".equals(fieldName)) {
            return this.healthState;
        }
        if ("instance".equals(fieldName)) {
            return this.instance;
        }
        if ("ipAddress".equals(fieldName)) {
            return this.ipAddress;
        }
        if ("port".equals(fieldName)) {
            return this.port;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Map<String, String> getAnnotationsMap() {
        return this.annotations;
    }

    public String getHealthState() {
        return this.healthState;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HealthStatus prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HealthStatus getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HealthStatus{annotations=" + this.annotations + ", healthState=" + this.healthState + ", instance=" + this.instance + ", ipAddress=" + this.ipAddress + ", port=" + this.port + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HealthStatus) {
            HealthStatus that = (HealthStatus)o;
            return Objects.equals(this.annotations, that.getAnnotationsMap()) && Objects.equals(this.healthState, that.getHealthState()) && Objects.equals(this.instance, that.getInstance()) && Objects.equals(this.ipAddress, that.getIpAddress()) && Objects.equals(this.port, that.getPort());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.healthState, this.instance, this.ipAddress, this.port);
    }

    public static class Builder {
        private Map<String, String> annotations;
        private String healthState;
        private String instance;
        private String ipAddress;
        private Integer port;

        Builder() {
        }

        public Builder mergeFrom(HealthStatus other) {
            if (other == HealthStatus.getDefaultInstance()) {
                return this;
            }
            if (other.getAnnotationsMap() != null) {
                this.annotations = other.annotations;
            }
            if (other.getHealthState() != null) {
                this.healthState = other.healthState;
            }
            if (other.getInstance() != null) {
                this.instance = other.instance;
            }
            if (other.getIpAddress() != null) {
                this.ipAddress = other.ipAddress;
            }
            if (other.getPort() != null) {
                this.port = other.port;
            }
            return this;
        }

        Builder(HealthStatus source) {
            this.annotations = source.annotations;
            this.healthState = source.healthState;
            this.instance = source.instance;
            this.ipAddress = source.ipAddress;
            this.port = source.port;
        }

        public Map<String, String> getAnnotationsMap() {
            return this.annotations;
        }

        public Builder putAllAnnotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public String getHealthState() {
            return this.healthState;
        }

        public Builder setHealthState(String healthState) {
            this.healthState = healthState;
            return this;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public Builder setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Integer getPort() {
            return this.port;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public HealthStatus build() {
            return new HealthStatus(this.annotations, this.healthState, this.instance, this.ipAddress, this.port);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.putAllAnnotations(this.annotations);
            newBuilder.setHealthState(this.healthState);
            newBuilder.setInstance(this.instance);
            newBuilder.setIpAddress(this.ipAddress);
            newBuilder.setPort(this.port);
            return newBuilder;
        }
    }
}

