/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.GetInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.InsertInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.InstanceTemplate;
import com.google.cloud.compute.v1.InstanceTemplateClient;
import com.google.cloud.compute.v1.InstanceTemplateList;
import com.google.cloud.compute.v1.ListInstanceTemplatesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectGlobalInstanceTemplateName;
import com.google.cloud.compute.v1.ProjectGlobalInstanceTemplateResourceName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SetIamPolicyInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonInstanceTemplateCallableFactory;
import com.google.cloud.compute.v1.stub.InstanceTemplateStub;
import com.google.cloud.compute.v1.stub.InstanceTemplateStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonInstanceTemplateStub
extends InstanceTemplateStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteInstanceTemplateHttpRequest, Operation> deleteInstanceTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.instanceTemplates.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/instanceTemplates/{instanceTemplate}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalInstanceTemplateName.newFactory()).setResourceNameField("instanceTemplate").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetInstanceTemplateHttpRequest, InstanceTemplate> getInstanceTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.instanceTemplates.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/instanceTemplates/{instanceTemplate}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalInstanceTemplateName.newFactory()).setResourceNameField("instanceTemplate").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)InstanceTemplate.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetIamPolicyInstanceTemplateHttpRequest, Policy> getIamPolicyInstanceTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.instanceTemplates.getIamPolicy").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/instanceTemplates/{resource}/getIamPolicy")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"optionsRequestedPolicyVersion"})).setResourceNameFactory(ProjectGlobalInstanceTemplateResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertInstanceTemplateHttpRequest, Operation> insertInstanceTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.instanceTemplates.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/instanceTemplates")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListInstanceTemplatesHttpRequest, InstanceTemplateList> listInstanceTemplatesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.instanceTemplates.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/instanceTemplates")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)InstanceTemplateList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SetIamPolicyInstanceTemplateHttpRequest, Policy> setIamPolicyInstanceTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.instanceTemplates.setIamPolicy").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/instanceTemplates/{resource}/setIamPolicy")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalInstanceTemplateResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<TestIamPermissionsInstanceTemplateHttpRequest, TestPermissionsResponse> testIamPermissionsInstanceTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.instanceTemplates.testIamPermissions").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/instanceTemplates/{resource}/testIamPermissions")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalInstanceTemplateResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)TestPermissionsResponse.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteInstanceTemplateHttpRequest, Operation> deleteInstanceTemplateCallable;
    private final UnaryCallable<GetInstanceTemplateHttpRequest, InstanceTemplate> getInstanceTemplateCallable;
    private final UnaryCallable<GetIamPolicyInstanceTemplateHttpRequest, Policy> getIamPolicyInstanceTemplateCallable;
    private final UnaryCallable<InsertInstanceTemplateHttpRequest, Operation> insertInstanceTemplateCallable;
    private final UnaryCallable<ListInstanceTemplatesHttpRequest, InstanceTemplateList> listInstanceTemplatesCallable;
    private final UnaryCallable<ListInstanceTemplatesHttpRequest, InstanceTemplateClient.ListInstanceTemplatesPagedResponse> listInstanceTemplatesPagedCallable;
    private final UnaryCallable<SetIamPolicyInstanceTemplateHttpRequest, Policy> setIamPolicyInstanceTemplateCallable;
    private final UnaryCallable<TestIamPermissionsInstanceTemplateHttpRequest, TestPermissionsResponse> testIamPermissionsInstanceTemplateCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonInstanceTemplateStub create(InstanceTemplateStubSettings settings) throws IOException {
        return new HttpJsonInstanceTemplateStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonInstanceTemplateStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonInstanceTemplateStub(InstanceTemplateStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonInstanceTemplateStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonInstanceTemplateStub(InstanceTemplateStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonInstanceTemplateStub(InstanceTemplateStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonInstanceTemplateCallableFactory());
    }

    protected HttpJsonInstanceTemplateStub(InstanceTemplateStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteInstanceTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteInstanceTemplateMethodDescriptor).build();
        HttpJsonCallSettings getInstanceTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getInstanceTemplateMethodDescriptor).build();
        HttpJsonCallSettings getIamPolicyInstanceTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyInstanceTemplateMethodDescriptor).build();
        HttpJsonCallSettings insertInstanceTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertInstanceTemplateMethodDescriptor).build();
        HttpJsonCallSettings listInstanceTemplatesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listInstanceTemplatesMethodDescriptor).build();
        HttpJsonCallSettings setIamPolicyInstanceTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyInstanceTemplateMethodDescriptor).build();
        HttpJsonCallSettings testIamPermissionsInstanceTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsInstanceTemplateMethodDescriptor).build();
        this.deleteInstanceTemplateCallable = callableFactory.createUnaryCallable(deleteInstanceTemplateTransportSettings, settings.deleteInstanceTemplateSettings(), clientContext);
        this.getInstanceTemplateCallable = callableFactory.createUnaryCallable(getInstanceTemplateTransportSettings, settings.getInstanceTemplateSettings(), clientContext);
        this.getIamPolicyInstanceTemplateCallable = callableFactory.createUnaryCallable(getIamPolicyInstanceTemplateTransportSettings, settings.getIamPolicyInstanceTemplateSettings(), clientContext);
        this.insertInstanceTemplateCallable = callableFactory.createUnaryCallable(insertInstanceTemplateTransportSettings, settings.insertInstanceTemplateSettings(), clientContext);
        this.listInstanceTemplatesCallable = callableFactory.createUnaryCallable(listInstanceTemplatesTransportSettings, settings.listInstanceTemplatesSettings(), clientContext);
        this.listInstanceTemplatesPagedCallable = callableFactory.createPagedCallable(listInstanceTemplatesTransportSettings, settings.listInstanceTemplatesSettings(), clientContext);
        this.setIamPolicyInstanceTemplateCallable = callableFactory.createUnaryCallable(setIamPolicyInstanceTemplateTransportSettings, settings.setIamPolicyInstanceTemplateSettings(), clientContext);
        this.testIamPermissionsInstanceTemplateCallable = callableFactory.createUnaryCallable(testIamPermissionsInstanceTemplateTransportSettings, settings.testIamPermissionsInstanceTemplateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteInstanceTemplateHttpRequest, Operation> deleteInstanceTemplateCallable() {
        return this.deleteInstanceTemplateCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetInstanceTemplateHttpRequest, InstanceTemplate> getInstanceTemplateCallable() {
        return this.getInstanceTemplateCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetIamPolicyInstanceTemplateHttpRequest, Policy> getIamPolicyInstanceTemplateCallable() {
        return this.getIamPolicyInstanceTemplateCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertInstanceTemplateHttpRequest, Operation> insertInstanceTemplateCallable() {
        return this.insertInstanceTemplateCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListInstanceTemplatesHttpRequest, InstanceTemplateClient.ListInstanceTemplatesPagedResponse> listInstanceTemplatesPagedCallable() {
        return this.listInstanceTemplatesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListInstanceTemplatesHttpRequest, InstanceTemplateList> listInstanceTemplatesCallable() {
        return this.listInstanceTemplatesCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<SetIamPolicyInstanceTemplateHttpRequest, Policy> setIamPolicyInstanceTemplateCallable() {
        return this.setIamPolicyInstanceTemplateCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<TestIamPermissionsInstanceTemplateHttpRequest, TestPermissionsResponse> testIamPermissionsInstanceTemplateCallable() {
        return this.testIamPermissionsInstanceTemplateCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

