/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListSslCertificatesHttpRequest;
import com.google.cloud.compute.v1.DeleteSslCertificateHttpRequest;
import com.google.cloud.compute.v1.GetSslCertificateHttpRequest;
import com.google.cloud.compute.v1.InsertSslCertificateHttpRequest;
import com.google.cloud.compute.v1.ListSslCertificatesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalSslCertificateName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SslCertificate;
import com.google.cloud.compute.v1.SslCertificateAggregatedList;
import com.google.cloud.compute.v1.SslCertificateList;
import com.google.cloud.compute.v1.SslCertificateSettings;
import com.google.cloud.compute.v1.SslCertificatesScopedList;
import com.google.cloud.compute.v1.stub.SslCertificateStub;
import com.google.cloud.compute.v1.stub.SslCertificateStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SslCertificateClient
implements BackgroundResource {
    private final SslCertificateSettings settings;
    private final SslCertificateStub stub;

    public static final SslCertificateClient create() throws IOException {
        return SslCertificateClient.create(SslCertificateSettings.newBuilder().build());
    }

    public static final SslCertificateClient create(SslCertificateSettings settings) throws IOException {
        return new SslCertificateClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SslCertificateClient create(SslCertificateStub stub) {
        return new SslCertificateClient(stub);
    }

    protected SslCertificateClient(SslCertificateSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SslCertificateStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SslCertificateClient(SslCertificateStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SslCertificateSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SslCertificateStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListSslCertificatesPagedResponse aggregatedListSslCertificates(ProjectName project) {
        AggregatedListSslCertificatesHttpRequest request = AggregatedListSslCertificatesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListSslCertificates(request);
    }

    @BetaApi
    public final AggregatedListSslCertificatesPagedResponse aggregatedListSslCertificates(String project) {
        AggregatedListSslCertificatesHttpRequest request = AggregatedListSslCertificatesHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListSslCertificates(request);
    }

    @BetaApi
    public final AggregatedListSslCertificatesPagedResponse aggregatedListSslCertificates(AggregatedListSslCertificatesHttpRequest request) {
        return (AggregatedListSslCertificatesPagedResponse)((Object)this.aggregatedListSslCertificatesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListSslCertificatesHttpRequest, AggregatedListSslCertificatesPagedResponse> aggregatedListSslCertificatesPagedCallable() {
        return this.stub.aggregatedListSslCertificatesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListSslCertificatesHttpRequest, SslCertificateAggregatedList> aggregatedListSslCertificatesCallable() {
        return this.stub.aggregatedListSslCertificatesCallable();
    }

    @BetaApi
    public final Operation deleteSslCertificate(ProjectGlobalSslCertificateName sslCertificate) {
        DeleteSslCertificateHttpRequest request = DeleteSslCertificateHttpRequest.newBuilder().setSslCertificate(sslCertificate == null ? null : sslCertificate.toString()).build();
        return this.deleteSslCertificate(request);
    }

    @BetaApi
    public final Operation deleteSslCertificate(String sslCertificate) {
        DeleteSslCertificateHttpRequest request = DeleteSslCertificateHttpRequest.newBuilder().setSslCertificate(sslCertificate).build();
        return this.deleteSslCertificate(request);
    }

    @BetaApi
    public final Operation deleteSslCertificate(DeleteSslCertificateHttpRequest request) {
        return (Operation)this.deleteSslCertificateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteSslCertificateHttpRequest, Operation> deleteSslCertificateCallable() {
        return this.stub.deleteSslCertificateCallable();
    }

    @BetaApi
    public final SslCertificate getSslCertificate(ProjectGlobalSslCertificateName sslCertificate) {
        GetSslCertificateHttpRequest request = GetSslCertificateHttpRequest.newBuilder().setSslCertificate(sslCertificate == null ? null : sslCertificate.toString()).build();
        return this.getSslCertificate(request);
    }

    @BetaApi
    public final SslCertificate getSslCertificate(String sslCertificate) {
        GetSslCertificateHttpRequest request = GetSslCertificateHttpRequest.newBuilder().setSslCertificate(sslCertificate).build();
        return this.getSslCertificate(request);
    }

    @BetaApi
    public final SslCertificate getSslCertificate(GetSslCertificateHttpRequest request) {
        return (SslCertificate)this.getSslCertificateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetSslCertificateHttpRequest, SslCertificate> getSslCertificateCallable() {
        return this.stub.getSslCertificateCallable();
    }

    @BetaApi
    public final Operation insertSslCertificate(ProjectName project, SslCertificate sslCertificateResource) {
        InsertSslCertificateHttpRequest request = InsertSslCertificateHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setSslCertificateResource(sslCertificateResource).build();
        return this.insertSslCertificate(request);
    }

    @BetaApi
    public final Operation insertSslCertificate(String project, SslCertificate sslCertificateResource) {
        InsertSslCertificateHttpRequest request = InsertSslCertificateHttpRequest.newBuilder().setProject(project).setSslCertificateResource(sslCertificateResource).build();
        return this.insertSslCertificate(request);
    }

    @BetaApi
    public final Operation insertSslCertificate(InsertSslCertificateHttpRequest request) {
        return (Operation)this.insertSslCertificateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertSslCertificateHttpRequest, Operation> insertSslCertificateCallable() {
        return this.stub.insertSslCertificateCallable();
    }

    @BetaApi
    public final ListSslCertificatesPagedResponse listSslCertificates(ProjectName project) {
        ListSslCertificatesHttpRequest request = ListSslCertificatesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listSslCertificates(request);
    }

    @BetaApi
    public final ListSslCertificatesPagedResponse listSslCertificates(String project) {
        ListSslCertificatesHttpRequest request = ListSslCertificatesHttpRequest.newBuilder().setProject(project).build();
        return this.listSslCertificates(request);
    }

    @BetaApi
    public final ListSslCertificatesPagedResponse listSslCertificates(ListSslCertificatesHttpRequest request) {
        return (ListSslCertificatesPagedResponse)((Object)this.listSslCertificatesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListSslCertificatesHttpRequest, ListSslCertificatesPagedResponse> listSslCertificatesPagedCallable() {
        return this.stub.listSslCertificatesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListSslCertificatesHttpRequest, SslCertificateList> listSslCertificatesCallable() {
        return this.stub.listSslCertificatesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSslCertificatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSslCertificatesHttpRequest, SslCertificateList, SslCertificate, ListSslCertificatesPage, ListSslCertificatesFixedSizeCollection> {
        private ListSslCertificatesFixedSizeCollection(List<ListSslCertificatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSslCertificatesFixedSizeCollection createEmptyCollection() {
            return new ListSslCertificatesFixedSizeCollection(null, 0);
        }

        protected ListSslCertificatesFixedSizeCollection createCollection(List<ListSslCertificatesPage> pages, int collectionSize) {
            return new ListSslCertificatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSslCertificatesPage
    extends AbstractPage<ListSslCertificatesHttpRequest, SslCertificateList, SslCertificate, ListSslCertificatesPage> {
        private ListSslCertificatesPage(PageContext<ListSslCertificatesHttpRequest, SslCertificateList, SslCertificate> context, SslCertificateList response) {
            super(context, (Object)response);
        }

        private static ListSslCertificatesPage createEmptyPage() {
            return new ListSslCertificatesPage(null, null);
        }

        protected ListSslCertificatesPage createPage(PageContext<ListSslCertificatesHttpRequest, SslCertificateList, SslCertificate> context, SslCertificateList response) {
            return new ListSslCertificatesPage(context, response);
        }

        public ApiFuture<ListSslCertificatesPage> createPageAsync(PageContext<ListSslCertificatesHttpRequest, SslCertificateList, SslCertificate> context, ApiFuture<SslCertificateList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSslCertificatesPagedResponse
    extends AbstractPagedListResponse<ListSslCertificatesHttpRequest, SslCertificateList, SslCertificate, ListSslCertificatesPage, ListSslCertificatesFixedSizeCollection> {
        public static ApiFuture<ListSslCertificatesPagedResponse> createAsync(PageContext<ListSslCertificatesHttpRequest, SslCertificateList, SslCertificate> context, ApiFuture<SslCertificateList> futureResponse) {
            ApiFuture<ListSslCertificatesPage> futurePage = ListSslCertificatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSslCertificatesPage, ListSslCertificatesPagedResponse>(){

                public ListSslCertificatesPagedResponse apply(ListSslCertificatesPage input) {
                    return new ListSslCertificatesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListSslCertificatesPagedResponse(ListSslCertificatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSslCertificatesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListSslCertificatesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListSslCertificatesHttpRequest, SslCertificateAggregatedList, SslCertificatesScopedList, AggregatedListSslCertificatesPage, AggregatedListSslCertificatesFixedSizeCollection> {
        private AggregatedListSslCertificatesFixedSizeCollection(List<AggregatedListSslCertificatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListSslCertificatesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListSslCertificatesFixedSizeCollection(null, 0);
        }

        protected AggregatedListSslCertificatesFixedSizeCollection createCollection(List<AggregatedListSslCertificatesPage> pages, int collectionSize) {
            return new AggregatedListSslCertificatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListSslCertificatesPage
    extends AbstractPage<AggregatedListSslCertificatesHttpRequest, SslCertificateAggregatedList, SslCertificatesScopedList, AggregatedListSslCertificatesPage> {
        private AggregatedListSslCertificatesPage(PageContext<AggregatedListSslCertificatesHttpRequest, SslCertificateAggregatedList, SslCertificatesScopedList> context, SslCertificateAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListSslCertificatesPage createEmptyPage() {
            return new AggregatedListSslCertificatesPage(null, null);
        }

        protected AggregatedListSslCertificatesPage createPage(PageContext<AggregatedListSslCertificatesHttpRequest, SslCertificateAggregatedList, SslCertificatesScopedList> context, SslCertificateAggregatedList response) {
            return new AggregatedListSslCertificatesPage(context, response);
        }

        public ApiFuture<AggregatedListSslCertificatesPage> createPageAsync(PageContext<AggregatedListSslCertificatesHttpRequest, SslCertificateAggregatedList, SslCertificatesScopedList> context, ApiFuture<SslCertificateAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListSslCertificatesPagedResponse
    extends AbstractPagedListResponse<AggregatedListSslCertificatesHttpRequest, SslCertificateAggregatedList, SslCertificatesScopedList, AggregatedListSslCertificatesPage, AggregatedListSslCertificatesFixedSizeCollection> {
        public static ApiFuture<AggregatedListSslCertificatesPagedResponse> createAsync(PageContext<AggregatedListSslCertificatesHttpRequest, SslCertificateAggregatedList, SslCertificatesScopedList> context, ApiFuture<SslCertificateAggregatedList> futureResponse) {
            ApiFuture<AggregatedListSslCertificatesPage> futurePage = AggregatedListSslCertificatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListSslCertificatesPage, AggregatedListSslCertificatesPagedResponse>(){

                public AggregatedListSslCertificatesPagedResponse apply(AggregatedListSslCertificatesPage input) {
                    return new AggregatedListSslCertificatesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListSslCertificatesPagedResponse(AggregatedListSslCertificatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListSslCertificatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

