/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionSslCertificateHttpRequest;
import com.google.cloud.compute.v1.GetRegionSslCertificateHttpRequest;
import com.google.cloud.compute.v1.InsertRegionSslCertificateHttpRequest;
import com.google.cloud.compute.v1.ListRegionSslCertificatesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionSslCertificateName;
import com.google.cloud.compute.v1.RegionSslCertificateSettings;
import com.google.cloud.compute.v1.SslCertificate;
import com.google.cloud.compute.v1.SslCertificateList;
import com.google.cloud.compute.v1.stub.RegionSslCertificateStub;
import com.google.cloud.compute.v1.stub.RegionSslCertificateStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionSslCertificateClient
implements BackgroundResource {
    private final RegionSslCertificateSettings settings;
    private final RegionSslCertificateStub stub;

    public static final RegionSslCertificateClient create() throws IOException {
        return RegionSslCertificateClient.create(RegionSslCertificateSettings.newBuilder().build());
    }

    public static final RegionSslCertificateClient create(RegionSslCertificateSettings settings) throws IOException {
        return new RegionSslCertificateClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionSslCertificateClient create(RegionSslCertificateStub stub) {
        return new RegionSslCertificateClient(stub);
    }

    protected RegionSslCertificateClient(RegionSslCertificateSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionSslCertificateStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionSslCertificateClient(RegionSslCertificateStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionSslCertificateSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionSslCertificateStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteRegionSslCertificate(ProjectRegionSslCertificateName sslCertificate) {
        DeleteRegionSslCertificateHttpRequest request = DeleteRegionSslCertificateHttpRequest.newBuilder().setSslCertificate(sslCertificate == null ? null : sslCertificate.toString()).build();
        return this.deleteRegionSslCertificate(request);
    }

    @BetaApi
    public final Operation deleteRegionSslCertificate(String sslCertificate) {
        DeleteRegionSslCertificateHttpRequest request = DeleteRegionSslCertificateHttpRequest.newBuilder().setSslCertificate(sslCertificate).build();
        return this.deleteRegionSslCertificate(request);
    }

    @BetaApi
    public final Operation deleteRegionSslCertificate(DeleteRegionSslCertificateHttpRequest request) {
        return (Operation)this.deleteRegionSslCertificateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionSslCertificateHttpRequest, Operation> deleteRegionSslCertificateCallable() {
        return this.stub.deleteRegionSslCertificateCallable();
    }

    @BetaApi
    public final SslCertificate getRegionSslCertificate(ProjectRegionSslCertificateName sslCertificate) {
        GetRegionSslCertificateHttpRequest request = GetRegionSslCertificateHttpRequest.newBuilder().setSslCertificate(sslCertificate == null ? null : sslCertificate.toString()).build();
        return this.getRegionSslCertificate(request);
    }

    @BetaApi
    public final SslCertificate getRegionSslCertificate(String sslCertificate) {
        GetRegionSslCertificateHttpRequest request = GetRegionSslCertificateHttpRequest.newBuilder().setSslCertificate(sslCertificate).build();
        return this.getRegionSslCertificate(request);
    }

    @BetaApi
    public final SslCertificate getRegionSslCertificate(GetRegionSslCertificateHttpRequest request) {
        return (SslCertificate)this.getRegionSslCertificateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionSslCertificateHttpRequest, SslCertificate> getRegionSslCertificateCallable() {
        return this.stub.getRegionSslCertificateCallable();
    }

    @BetaApi
    public final Operation insertRegionSslCertificate(ProjectRegionName region, SslCertificate sslCertificateResource) {
        InsertRegionSslCertificateHttpRequest request = InsertRegionSslCertificateHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setSslCertificateResource(sslCertificateResource).build();
        return this.insertRegionSslCertificate(request);
    }

    @BetaApi
    public final Operation insertRegionSslCertificate(String region, SslCertificate sslCertificateResource) {
        InsertRegionSslCertificateHttpRequest request = InsertRegionSslCertificateHttpRequest.newBuilder().setRegion(region).setSslCertificateResource(sslCertificateResource).build();
        return this.insertRegionSslCertificate(request);
    }

    @BetaApi
    public final Operation insertRegionSslCertificate(InsertRegionSslCertificateHttpRequest request) {
        return (Operation)this.insertRegionSslCertificateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionSslCertificateHttpRequest, Operation> insertRegionSslCertificateCallable() {
        return this.stub.insertRegionSslCertificateCallable();
    }

    @BetaApi
    public final ListRegionSslCertificatesPagedResponse listRegionSslCertificates(ProjectRegionName region) {
        ListRegionSslCertificatesHttpRequest request = ListRegionSslCertificatesHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionSslCertificates(request);
    }

    @BetaApi
    public final ListRegionSslCertificatesPagedResponse listRegionSslCertificates(String region) {
        ListRegionSslCertificatesHttpRequest request = ListRegionSslCertificatesHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionSslCertificates(request);
    }

    @BetaApi
    public final ListRegionSslCertificatesPagedResponse listRegionSslCertificates(ListRegionSslCertificatesHttpRequest request) {
        return (ListRegionSslCertificatesPagedResponse)((Object)this.listRegionSslCertificatesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionSslCertificatesHttpRequest, ListRegionSslCertificatesPagedResponse> listRegionSslCertificatesPagedCallable() {
        return this.stub.listRegionSslCertificatesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionSslCertificatesHttpRequest, SslCertificateList> listRegionSslCertificatesCallable() {
        return this.stub.listRegionSslCertificatesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionSslCertificatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionSslCertificatesHttpRequest, SslCertificateList, SslCertificate, ListRegionSslCertificatesPage, ListRegionSslCertificatesFixedSizeCollection> {
        private ListRegionSslCertificatesFixedSizeCollection(List<ListRegionSslCertificatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionSslCertificatesFixedSizeCollection createEmptyCollection() {
            return new ListRegionSslCertificatesFixedSizeCollection(null, 0);
        }

        protected ListRegionSslCertificatesFixedSizeCollection createCollection(List<ListRegionSslCertificatesPage> pages, int collectionSize) {
            return new ListRegionSslCertificatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionSslCertificatesPage
    extends AbstractPage<ListRegionSslCertificatesHttpRequest, SslCertificateList, SslCertificate, ListRegionSslCertificatesPage> {
        private ListRegionSslCertificatesPage(PageContext<ListRegionSslCertificatesHttpRequest, SslCertificateList, SslCertificate> context, SslCertificateList response) {
            super(context, (Object)response);
        }

        private static ListRegionSslCertificatesPage createEmptyPage() {
            return new ListRegionSslCertificatesPage(null, null);
        }

        protected ListRegionSslCertificatesPage createPage(PageContext<ListRegionSslCertificatesHttpRequest, SslCertificateList, SslCertificate> context, SslCertificateList response) {
            return new ListRegionSslCertificatesPage(context, response);
        }

        public ApiFuture<ListRegionSslCertificatesPage> createPageAsync(PageContext<ListRegionSslCertificatesHttpRequest, SslCertificateList, SslCertificate> context, ApiFuture<SslCertificateList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionSslCertificatesPagedResponse
    extends AbstractPagedListResponse<ListRegionSslCertificatesHttpRequest, SslCertificateList, SslCertificate, ListRegionSslCertificatesPage, ListRegionSslCertificatesFixedSizeCollection> {
        public static ApiFuture<ListRegionSslCertificatesPagedResponse> createAsync(PageContext<ListRegionSslCertificatesHttpRequest, SslCertificateList, SslCertificate> context, ApiFuture<SslCertificateList> futureResponse) {
            ApiFuture<ListRegionSslCertificatesPage> futurePage = ListRegionSslCertificatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionSslCertificatesPage, ListRegionSslCertificatesPagedResponse>(){

                public ListRegionSslCertificatesPagedResponse apply(ListRegionSslCertificatesPage input) {
                    return new ListRegionSslCertificatesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionSslCertificatesPagedResponse(ListRegionSslCertificatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionSslCertificatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

