/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionForwardingRuleName
implements ResourceName {
    private final String forwardingRule;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/forwardingRules/{forwardingRule}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionForwardingRuleName(Builder builder) {
        this.forwardingRule = (String)Preconditions.checkNotNull((Object)builder.getForwardingRule());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionForwardingRuleName of(String forwardingRule, String project, String region) {
        return ProjectRegionForwardingRuleName.newBuilder().setForwardingRule(forwardingRule).setProject(project).setRegion(region).build();
    }

    public static String format(String forwardingRule, String project, String region) {
        return ProjectRegionForwardingRuleName.of(forwardingRule, project, region).toString();
    }

    public String getForwardingRule() {
        return this.forwardingRule;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionForwardingRuleName projectRegionForwardingRuleName = this;
            synchronized (projectRegionForwardingRuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"forwardingRule", (Object)this.forwardingRule);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionForwardingRuleName> newFactory() {
        return new ResourceNameFactory<ProjectRegionForwardingRuleName>(){

            public ProjectRegionForwardingRuleName parse(String formattedString) {
                return ProjectRegionForwardingRuleName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionForwardingRuleName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionForwardingRuleName.parse: formattedString not in valid format");
        return ProjectRegionForwardingRuleName.of((String)matchMap.get("forwardingRule"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"forwardingRule", this.forwardingRule, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionForwardingRuleName) {
            ProjectRegionForwardingRuleName that = (ProjectRegionForwardingRuleName)o;
            return Objects.equals(this.forwardingRule, that.getForwardingRule()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.forwardingRule, this.project, this.region);
    }

    public static class Builder {
        private String forwardingRule;
        private String project;
        private String region;

        public String getForwardingRule() {
            return this.forwardingRule;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setForwardingRule(String forwardingRule) {
            this.forwardingRule = forwardingRule;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionForwardingRuleName projectRegionForwardingRuleName) {
            this.forwardingRule = projectRegionForwardingRuleName.forwardingRule;
            this.project = projectRegionForwardingRuleName.project;
            this.region = projectRegionForwardingRuleName.region;
        }

        public ProjectRegionForwardingRuleName build() {
            return new ProjectRegionForwardingRuleName(this);
        }
    }
}

