/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.InstanceProperties;
import com.google.cloud.compute.v1.SourceInstanceParams;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceTemplate
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final String id;
    private final String kind;
    private final String name;
    private final InstanceProperties properties;
    private final String selfLink;
    private final String sourceInstance;
    private final SourceInstanceParams sourceInstanceParams;
    private static final InstanceTemplate DEFAULT_INSTANCE = new InstanceTemplate();

    private InstanceTemplate() {
        this.creationTimestamp = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.properties = null;
        this.selfLink = null;
        this.sourceInstance = null;
        this.sourceInstanceParams = null;
    }

    private InstanceTemplate(String creationTimestamp, String description, String id, String kind, String name, InstanceProperties properties, String selfLink, String sourceInstance, SourceInstanceParams sourceInstanceParams) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.properties = properties;
        this.selfLink = selfLink;
        this.sourceInstance = sourceInstance;
        this.sourceInstanceParams = sourceInstanceParams;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("properties".equals(fieldName)) {
            return this.properties;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("sourceInstance".equals(fieldName)) {
            return this.sourceInstance;
        }
        if ("sourceInstanceParams".equals(fieldName)) {
            return this.sourceInstanceParams;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public InstanceProperties getProperties() {
        return this.properties;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getSourceInstance() {
        return this.sourceInstance;
    }

    public SourceInstanceParams getSourceInstanceParams() {
        return this.sourceInstanceParams;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceTemplate prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceTemplate getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceTemplate{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", properties=" + this.properties + ", selfLink=" + this.selfLink + ", sourceInstance=" + this.sourceInstance + ", sourceInstanceParams=" + this.sourceInstanceParams + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceTemplate) {
            InstanceTemplate that = (InstanceTemplate)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.properties, that.getProperties()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.sourceInstance, that.getSourceInstance()) && Objects.equals(this.sourceInstanceParams, that.getSourceInstanceParams());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.id, this.kind, this.name, this.properties, this.selfLink, this.sourceInstance, this.sourceInstanceParams);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private String id;
        private String kind;
        private String name;
        private InstanceProperties properties;
        private String selfLink;
        private String sourceInstance;
        private SourceInstanceParams sourceInstanceParams;

        Builder() {
        }

        public Builder mergeFrom(InstanceTemplate other) {
            if (other == InstanceTemplate.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getProperties() != null) {
                this.properties = other.properties;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSourceInstance() != null) {
                this.sourceInstance = other.sourceInstance;
            }
            if (other.getSourceInstanceParams() != null) {
                this.sourceInstanceParams = other.sourceInstanceParams;
            }
            return this;
        }

        Builder(InstanceTemplate source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.properties = source.properties;
            this.selfLink = source.selfLink;
            this.sourceInstance = source.sourceInstance;
            this.sourceInstanceParams = source.sourceInstanceParams;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public InstanceProperties getProperties() {
            return this.properties;
        }

        public Builder setProperties(InstanceProperties properties) {
            this.properties = properties;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getSourceInstance() {
            return this.sourceInstance;
        }

        public Builder setSourceInstance(String sourceInstance) {
            this.sourceInstance = sourceInstance;
            return this;
        }

        public SourceInstanceParams getSourceInstanceParams() {
            return this.sourceInstanceParams;
        }

        public Builder setSourceInstanceParams(SourceInstanceParams sourceInstanceParams) {
            this.sourceInstanceParams = sourceInstanceParams;
            return this;
        }

        public InstanceTemplate build() {
            return new InstanceTemplate(this.creationTimestamp, this.description, this.id, this.kind, this.name, this.properties, this.selfLink, this.sourceInstance, this.sourceInstanceParams);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setProperties(this.properties);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setSourceInstance(this.sourceInstance);
            newBuilder.setSourceInstanceParams(this.sourceInstanceParams);
            return newBuilder;
        }
    }
}

