/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.LogConfigCloudAuditOptions;
import com.google.cloud.compute.v1.LogConfigCounterOptions;
import com.google.cloud.compute.v1.LogConfigDataAccessOptions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class LogConfig
implements ApiMessage {
    private final LogConfigCloudAuditOptions cloudAudit;
    private final LogConfigCounterOptions counter;
    private final LogConfigDataAccessOptions dataAccess;
    private static final LogConfig DEFAULT_INSTANCE = new LogConfig();

    private LogConfig() {
        this.cloudAudit = null;
        this.counter = null;
        this.dataAccess = null;
    }

    private LogConfig(LogConfigCloudAuditOptions cloudAudit, LogConfigCounterOptions counter, LogConfigDataAccessOptions dataAccess) {
        this.cloudAudit = cloudAudit;
        this.counter = counter;
        this.dataAccess = dataAccess;
    }

    public Object getFieldValue(String fieldName) {
        if ("cloudAudit".equals(fieldName)) {
            return this.cloudAudit;
        }
        if ("counter".equals(fieldName)) {
            return this.counter;
        }
        if ("dataAccess".equals(fieldName)) {
            return this.dataAccess;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public LogConfigCloudAuditOptions getCloudAudit() {
        return this.cloudAudit;
    }

    public LogConfigCounterOptions getCounter() {
        return this.counter;
    }

    public LogConfigDataAccessOptions getDataAccess() {
        return this.dataAccess;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(LogConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static LogConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "LogConfig{cloudAudit=" + this.cloudAudit + ", counter=" + this.counter + ", dataAccess=" + this.dataAccess + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LogConfig) {
            LogConfig that = (LogConfig)o;
            return Objects.equals(this.cloudAudit, that.getCloudAudit()) && Objects.equals(this.counter, that.getCounter()) && Objects.equals(this.dataAccess, that.getDataAccess());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.cloudAudit, this.counter, this.dataAccess);
    }

    public static class Builder {
        private LogConfigCloudAuditOptions cloudAudit;
        private LogConfigCounterOptions counter;
        private LogConfigDataAccessOptions dataAccess;

        Builder() {
        }

        public Builder mergeFrom(LogConfig other) {
            if (other == LogConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getCloudAudit() != null) {
                this.cloudAudit = other.cloudAudit;
            }
            if (other.getCounter() != null) {
                this.counter = other.counter;
            }
            if (other.getDataAccess() != null) {
                this.dataAccess = other.dataAccess;
            }
            return this;
        }

        Builder(LogConfig source) {
            this.cloudAudit = source.cloudAudit;
            this.counter = source.counter;
            this.dataAccess = source.dataAccess;
        }

        public LogConfigCloudAuditOptions getCloudAudit() {
            return this.cloudAudit;
        }

        public Builder setCloudAudit(LogConfigCloudAuditOptions cloudAudit) {
            this.cloudAudit = cloudAudit;
            return this;
        }

        public LogConfigCounterOptions getCounter() {
            return this.counter;
        }

        public Builder setCounter(LogConfigCounterOptions counter) {
            this.counter = counter;
            return this;
        }

        public LogConfigDataAccessOptions getDataAccess() {
            return this.dataAccess;
        }

        public Builder setDataAccess(LogConfigDataAccessOptions dataAccess) {
            this.dataAccess = dataAccess;
            return this;
        }

        public LogConfig build() {
            return new LogConfig(this.cloudAudit, this.counter, this.dataAccess);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCloudAudit(this.cloudAudit);
            newBuilder.setCounter(this.counter);
            newBuilder.setDataAccess(this.dataAccess);
            return newBuilder;
        }
    }
}

