/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.testing;

import com.google.api.gax.core.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.HttpTransportOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.compute.ComputeOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.Duration;

public class RemoteComputeHelper {
    private static final Logger log = Logger.getLogger(RemoteComputeHelper.class.getName());
    private final ComputeOptions options;

    private RemoteComputeHelper(ComputeOptions options) {
        this.options = options;
    }

    public ComputeOptions getOptions() {
        return this.options;
    }

    public static String baseResourceName() {
        return "test-" + UUID.randomUUID().toString().replace("-", "").substring(0, 24) + "-";
    }

    public static RemoteComputeHelper create(String projectId, InputStream keyStream) {
        try {
            HttpTransportOptions transportOptions = ComputeOptions.getDefaultHttpTransportOptions();
            transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
            ComputeOptions computeOptions = ((ComputeOptions.Builder)((ComputeOptions.Builder)((ComputeOptions.Builder)ComputeOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)keyStream))).setProjectId(projectId)).setRetrySettings(RemoteComputeHelper.retrySettings())).setTransportOptions((TransportOptions)transportOptions).build();
            return new RemoteComputeHelper(computeOptions);
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, ex.getMessage());
            }
            throw ComputeHelperException.translate(ex);
        }
    }

    public static RemoteComputeHelper create() {
        HttpTransportOptions transportOptions = ComputeOptions.getDefaultHttpTransportOptions();
        transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
        ComputeOptions computeOptions = ((ComputeOptions.Builder)ComputeOptions.newBuilder().setRetrySettings(RemoteComputeHelper.retrySettings())).setTransportOptions((TransportOptions)transportOptions).build();
        return new RemoteComputeHelper(computeOptions);
    }

    private static RetrySettings retrySettings() {
        return RetrySettings.newBuilder().setMaxAttempts(10).setMaxRetryDelay(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)120000L)).setInitialRetryDelay(Duration.millis((long)250L)).setRetryDelayMultiplier(1.0).setInitialRpcTimeout(Duration.millis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)120000L)).build();
    }

    public static class ComputeHelperException
    extends RuntimeException {
        private static final long serialVersionUID = -5747977015007639912L;

        public ComputeHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        public static ComputeHelperException translate(Exception ex) {
            return new ComputeHelperException(ex.getMessage(), ex);
        }
    }
}

