/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNodeTypesHttpRequest;
import com.google.cloud.compute.v1.GetNodeTypeHttpRequest;
import com.google.cloud.compute.v1.ListNodeTypesHttpRequest;
import com.google.cloud.compute.v1.NodeType;
import com.google.cloud.compute.v1.NodeTypeAggregatedList;
import com.google.cloud.compute.v1.NodeTypeClient;
import com.google.cloud.compute.v1.NodeTypeList;
import com.google.cloud.compute.v1.NodeTypesScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonNodeTypeStub;
import com.google.cloud.compute.v1.stub.NodeTypeStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class NodeTypeStubSettings
extends StubSettings<NodeTypeStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypeClient.AggregatedListNodeTypesPagedResponse> aggregatedListNodeTypesSettings;
    private final UnaryCallSettings<GetNodeTypeHttpRequest, NodeType> getNodeTypeSettings;
    private final PagedCallSettings<ListNodeTypesHttpRequest, NodeTypeList, NodeTypeClient.ListNodeTypesPagedResponse> listNodeTypesSettings;
    private static final PagedListDescriptor<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypesScopedList> AGGREGATED_LIST_NODE_TYPES_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypesScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListNodeTypesHttpRequest injectToken(AggregatedListNodeTypesHttpRequest payload, String token) {
            return AggregatedListNodeTypesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListNodeTypesHttpRequest injectPageSize(AggregatedListNodeTypesHttpRequest payload, int pageSize) {
            return AggregatedListNodeTypesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListNodeTypesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeTypeAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodeTypesScopedList> extractResources(NodeTypeAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListNodeTypesHttpRequest, NodeTypeList, NodeType> LIST_NODE_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListNodeTypesHttpRequest, NodeTypeList, NodeType>(){

        public String emptyToken() {
            return "";
        }

        public ListNodeTypesHttpRequest injectToken(ListNodeTypesHttpRequest payload, String token) {
            return ListNodeTypesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListNodeTypesHttpRequest injectPageSize(ListNodeTypesHttpRequest payload, int pageSize) {
            return ListNodeTypesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNodeTypesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeTypeList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodeType> extractResources(NodeTypeList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypeClient.AggregatedListNodeTypesPagedResponse> AGGREGATED_LIST_NODE_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypeClient.AggregatedListNodeTypesPagedResponse>(){

        public ApiFuture<NodeTypeClient.AggregatedListNodeTypesPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList> callable, AggregatedListNodeTypesHttpRequest request, ApiCallContext context, ApiFuture<NodeTypeAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_NODE_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeTypeClient.AggregatedListNodeTypesPagedResponse.createAsync((PageContext<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypesScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNodeTypesHttpRequest, NodeTypeList, NodeTypeClient.ListNodeTypesPagedResponse> LIST_NODE_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListNodeTypesHttpRequest, NodeTypeList, NodeTypeClient.ListNodeTypesPagedResponse>(){

        public ApiFuture<NodeTypeClient.ListNodeTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListNodeTypesHttpRequest, NodeTypeList> callable, ListNodeTypesHttpRequest request, ApiCallContext context, ApiFuture<NodeTypeList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NODE_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeTypeClient.ListNodeTypesPagedResponse.createAsync((PageContext<ListNodeTypesHttpRequest, NodeTypeList, NodeType>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypeClient.AggregatedListNodeTypesPagedResponse> aggregatedListNodeTypesSettings() {
        return this.aggregatedListNodeTypesSettings;
    }

    public UnaryCallSettings<GetNodeTypeHttpRequest, NodeType> getNodeTypeSettings() {
        return this.getNodeTypeSettings;
    }

    public PagedCallSettings<ListNodeTypesHttpRequest, NodeTypeList, NodeTypeClient.ListNodeTypesPagedResponse> listNodeTypesSettings() {
        return this.listNodeTypesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NodeTypeStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNodeTypeStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NodeTypeStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NodeTypeStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NodeTypeStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListNodeTypesSettings = settingsBuilder.aggregatedListNodeTypesSettings().build();
        this.getNodeTypeSettings = settingsBuilder.getNodeTypeSettings().build();
        this.listNodeTypesSettings = settingsBuilder.listNodeTypesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NodeTypeStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypeClient.AggregatedListNodeTypesPagedResponse> aggregatedListNodeTypesSettings;
        private final UnaryCallSettings.Builder<GetNodeTypeHttpRequest, NodeType> getNodeTypeSettings;
        private final PagedCallSettings.Builder<ListNodeTypesHttpRequest, NodeTypeList, NodeTypeClient.ListNodeTypesPagedResponse> listNodeTypesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListNodeTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_NODE_TYPES_PAGE_STR_FACT);
            this.getNodeTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNodeTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NODE_TYPES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListNodeTypesSettings, this.getNodeTypeSettings, this.listNodeTypesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NodeTypeStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NodeTypeStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NodeTypeStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(NodeTypeStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListNodeTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getNodeTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listNodeTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(NodeTypeStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListNodeTypesSettings = settings.aggregatedListNodeTypesSettings.toBuilder();
            this.getNodeTypeSettings = settings.getNodeTypeSettings.toBuilder();
            this.listNodeTypesSettings = settings.listNodeTypesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListNodeTypesSettings, this.getNodeTypeSettings, this.listNodeTypesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListNodeTypesHttpRequest, NodeTypeAggregatedList, NodeTypeClient.AggregatedListNodeTypesPagedResponse> aggregatedListNodeTypesSettings() {
            return this.aggregatedListNodeTypesSettings;
        }

        public UnaryCallSettings.Builder<GetNodeTypeHttpRequest, NodeType> getNodeTypeSettings() {
            return this.getNodeTypeSettings;
        }

        public PagedCallSettings.Builder<ListNodeTypesHttpRequest, NodeTypeList, NodeTypeClient.ListNodeTypesPagedResponse> listNodeTypesSettings() {
            return this.listNodeTypesSettings;
        }

        public NodeTypeStubSettings build() throws IOException {
            return new NodeTypeStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

