/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNodeTemplatesHttpRequest;
import com.google.cloud.compute.v1.DeleteNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.GetNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.InsertNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.ListNodeTemplatesHttpRequest;
import com.google.cloud.compute.v1.NodeTemplate;
import com.google.cloud.compute.v1.NodeTemplateAggregatedList;
import com.google.cloud.compute.v1.NodeTemplateClient;
import com.google.cloud.compute.v1.NodeTemplateList;
import com.google.cloud.compute.v1.NodeTemplatesScopedList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonNodeTemplateStub;
import com.google.cloud.compute.v1.stub.NodeTemplateStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class NodeTemplateStubSettings
extends StubSettings<NodeTemplateStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplateClient.AggregatedListNodeTemplatesPagedResponse> aggregatedListNodeTemplatesSettings;
    private final UnaryCallSettings<DeleteNodeTemplateHttpRequest, Operation> deleteNodeTemplateSettings;
    private final UnaryCallSettings<GetNodeTemplateHttpRequest, NodeTemplate> getNodeTemplateSettings;
    private final UnaryCallSettings<GetIamPolicyNodeTemplateHttpRequest, Policy> getIamPolicyNodeTemplateSettings;
    private final UnaryCallSettings<InsertNodeTemplateHttpRequest, Operation> insertNodeTemplateSettings;
    private final PagedCallSettings<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplateClient.ListNodeTemplatesPagedResponse> listNodeTemplatesSettings;
    private final UnaryCallSettings<SetIamPolicyNodeTemplateHttpRequest, Policy> setIamPolicyNodeTemplateSettings;
    private final UnaryCallSettings<TestIamPermissionsNodeTemplateHttpRequest, TestPermissionsResponse> testIamPermissionsNodeTemplateSettings;
    private static final PagedListDescriptor<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplatesScopedList> AGGREGATED_LIST_NODE_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplatesScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListNodeTemplatesHttpRequest injectToken(AggregatedListNodeTemplatesHttpRequest payload, String token) {
            return AggregatedListNodeTemplatesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListNodeTemplatesHttpRequest injectPageSize(AggregatedListNodeTemplatesHttpRequest payload, int pageSize) {
            return AggregatedListNodeTemplatesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListNodeTemplatesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeTemplateAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodeTemplatesScopedList> extractResources(NodeTemplateAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplate> LIST_NODE_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplate>(){

        public String emptyToken() {
            return "";
        }

        public ListNodeTemplatesHttpRequest injectToken(ListNodeTemplatesHttpRequest payload, String token) {
            return ListNodeTemplatesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListNodeTemplatesHttpRequest injectPageSize(ListNodeTemplatesHttpRequest payload, int pageSize) {
            return ListNodeTemplatesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNodeTemplatesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeTemplateList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodeTemplate> extractResources(NodeTemplateList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplateClient.AggregatedListNodeTemplatesPagedResponse> AGGREGATED_LIST_NODE_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplateClient.AggregatedListNodeTemplatesPagedResponse>(){

        public ApiFuture<NodeTemplateClient.AggregatedListNodeTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList> callable, AggregatedListNodeTemplatesHttpRequest request, ApiCallContext context, ApiFuture<NodeTemplateAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_NODE_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeTemplateClient.AggregatedListNodeTemplatesPagedResponse.createAsync((PageContext<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplatesScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplateClient.ListNodeTemplatesPagedResponse> LIST_NODE_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplateClient.ListNodeTemplatesPagedResponse>(){

        public ApiFuture<NodeTemplateClient.ListNodeTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListNodeTemplatesHttpRequest, NodeTemplateList> callable, ListNodeTemplatesHttpRequest request, ApiCallContext context, ApiFuture<NodeTemplateList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NODE_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeTemplateClient.ListNodeTemplatesPagedResponse.createAsync((PageContext<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplate>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplateClient.AggregatedListNodeTemplatesPagedResponse> aggregatedListNodeTemplatesSettings() {
        return this.aggregatedListNodeTemplatesSettings;
    }

    public UnaryCallSettings<DeleteNodeTemplateHttpRequest, Operation> deleteNodeTemplateSettings() {
        return this.deleteNodeTemplateSettings;
    }

    public UnaryCallSettings<GetNodeTemplateHttpRequest, NodeTemplate> getNodeTemplateSettings() {
        return this.getNodeTemplateSettings;
    }

    public UnaryCallSettings<GetIamPolicyNodeTemplateHttpRequest, Policy> getIamPolicyNodeTemplateSettings() {
        return this.getIamPolicyNodeTemplateSettings;
    }

    public UnaryCallSettings<InsertNodeTemplateHttpRequest, Operation> insertNodeTemplateSettings() {
        return this.insertNodeTemplateSettings;
    }

    public PagedCallSettings<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplateClient.ListNodeTemplatesPagedResponse> listNodeTemplatesSettings() {
        return this.listNodeTemplatesSettings;
    }

    public UnaryCallSettings<SetIamPolicyNodeTemplateHttpRequest, Policy> setIamPolicyNodeTemplateSettings() {
        return this.setIamPolicyNodeTemplateSettings;
    }

    public UnaryCallSettings<TestIamPermissionsNodeTemplateHttpRequest, TestPermissionsResponse> testIamPermissionsNodeTemplateSettings() {
        return this.testIamPermissionsNodeTemplateSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NodeTemplateStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNodeTemplateStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NodeTemplateStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NodeTemplateStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NodeTemplateStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListNodeTemplatesSettings = settingsBuilder.aggregatedListNodeTemplatesSettings().build();
        this.deleteNodeTemplateSettings = settingsBuilder.deleteNodeTemplateSettings().build();
        this.getNodeTemplateSettings = settingsBuilder.getNodeTemplateSettings().build();
        this.getIamPolicyNodeTemplateSettings = settingsBuilder.getIamPolicyNodeTemplateSettings().build();
        this.insertNodeTemplateSettings = settingsBuilder.insertNodeTemplateSettings().build();
        this.listNodeTemplatesSettings = settingsBuilder.listNodeTemplatesSettings().build();
        this.setIamPolicyNodeTemplateSettings = settingsBuilder.setIamPolicyNodeTemplateSettings().build();
        this.testIamPermissionsNodeTemplateSettings = settingsBuilder.testIamPermissionsNodeTemplateSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NodeTemplateStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplateClient.AggregatedListNodeTemplatesPagedResponse> aggregatedListNodeTemplatesSettings;
        private final UnaryCallSettings.Builder<DeleteNodeTemplateHttpRequest, Operation> deleteNodeTemplateSettings;
        private final UnaryCallSettings.Builder<GetNodeTemplateHttpRequest, NodeTemplate> getNodeTemplateSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyNodeTemplateHttpRequest, Policy> getIamPolicyNodeTemplateSettings;
        private final UnaryCallSettings.Builder<InsertNodeTemplateHttpRequest, Operation> insertNodeTemplateSettings;
        private final PagedCallSettings.Builder<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplateClient.ListNodeTemplatesPagedResponse> listNodeTemplatesSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyNodeTemplateHttpRequest, Policy> setIamPolicyNodeTemplateSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsNodeTemplateHttpRequest, TestPermissionsResponse> testIamPermissionsNodeTemplateSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListNodeTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_NODE_TEMPLATES_PAGE_STR_FACT);
            this.deleteNodeTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getNodeTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicyNodeTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertNodeTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNodeTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NODE_TEMPLATES_PAGE_STR_FACT);
            this.setIamPolicyNodeTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsNodeTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListNodeTemplatesSettings, this.deleteNodeTemplateSettings, this.getNodeTemplateSettings, this.getIamPolicyNodeTemplateSettings, this.insertNodeTemplateSettings, this.listNodeTemplatesSettings, this.setIamPolicyNodeTemplateSettings, this.testIamPermissionsNodeTemplateSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NodeTemplateStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NodeTemplateStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NodeTemplateStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(NodeTemplateStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListNodeTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteNodeTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getNodeTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicyNodeTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertNodeTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listNodeTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicyNodeTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsNodeTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(NodeTemplateStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListNodeTemplatesSettings = settings.aggregatedListNodeTemplatesSettings.toBuilder();
            this.deleteNodeTemplateSettings = settings.deleteNodeTemplateSettings.toBuilder();
            this.getNodeTemplateSettings = settings.getNodeTemplateSettings.toBuilder();
            this.getIamPolicyNodeTemplateSettings = settings.getIamPolicyNodeTemplateSettings.toBuilder();
            this.insertNodeTemplateSettings = settings.insertNodeTemplateSettings.toBuilder();
            this.listNodeTemplatesSettings = settings.listNodeTemplatesSettings.toBuilder();
            this.setIamPolicyNodeTemplateSettings = settings.setIamPolicyNodeTemplateSettings.toBuilder();
            this.testIamPermissionsNodeTemplateSettings = settings.testIamPermissionsNodeTemplateSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListNodeTemplatesSettings, this.deleteNodeTemplateSettings, this.getNodeTemplateSettings, this.getIamPolicyNodeTemplateSettings, this.insertNodeTemplateSettings, this.listNodeTemplatesSettings, this.setIamPolicyNodeTemplateSettings, this.testIamPermissionsNodeTemplateSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplateClient.AggregatedListNodeTemplatesPagedResponse> aggregatedListNodeTemplatesSettings() {
            return this.aggregatedListNodeTemplatesSettings;
        }

        public UnaryCallSettings.Builder<DeleteNodeTemplateHttpRequest, Operation> deleteNodeTemplateSettings() {
            return this.deleteNodeTemplateSettings;
        }

        public UnaryCallSettings.Builder<GetNodeTemplateHttpRequest, NodeTemplate> getNodeTemplateSettings() {
            return this.getNodeTemplateSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyNodeTemplateHttpRequest, Policy> getIamPolicyNodeTemplateSettings() {
            return this.getIamPolicyNodeTemplateSettings;
        }

        public UnaryCallSettings.Builder<InsertNodeTemplateHttpRequest, Operation> insertNodeTemplateSettings() {
            return this.insertNodeTemplateSettings;
        }

        public PagedCallSettings.Builder<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplateClient.ListNodeTemplatesPagedResponse> listNodeTemplatesSettings() {
            return this.listNodeTemplatesSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyNodeTemplateHttpRequest, Policy> setIamPolicyNodeTemplateSettings() {
            return this.setIamPolicyNodeTemplateSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsNodeTemplateHttpRequest, TestPermissionsResponse> testIamPermissionsNodeTemplateSettings() {
            return this.testIamPermissionsNodeTemplateSettings;
        }

        public NodeTemplateStubSettings build() throws IOException {
            return new NodeTemplateStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

