/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.ResourcePolicy;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ResourcePoliciesScopedList
implements ApiMessage {
    private final List<ResourcePolicy> resourcePolicies;
    private final Warning warning;
    private static final ResourcePoliciesScopedList DEFAULT_INSTANCE = new ResourcePoliciesScopedList();

    private ResourcePoliciesScopedList() {
        this.resourcePolicies = null;
        this.warning = null;
    }

    private ResourcePoliciesScopedList(List<ResourcePolicy> resourcePolicies, Warning warning) {
        this.resourcePolicies = resourcePolicies;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("resourcePolicies".equals(fieldName)) {
            return this.resourcePolicies;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<ResourcePolicy> getResourcePoliciesList() {
        return this.resourcePolicies;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ResourcePoliciesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ResourcePoliciesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ResourcePoliciesScopedList{resourcePolicies=" + this.resourcePolicies + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ResourcePoliciesScopedList) {
            ResourcePoliciesScopedList that = (ResourcePoliciesScopedList)o;
            return Objects.equals(this.resourcePolicies, that.getResourcePoliciesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.resourcePolicies, this.warning);
    }

    public static class Builder {
        private List<ResourcePolicy> resourcePolicies;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(ResourcePoliciesScopedList other) {
            if (other == ResourcePoliciesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getResourcePoliciesList() != null) {
                this.resourcePolicies = other.resourcePolicies;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(ResourcePoliciesScopedList source) {
            this.resourcePolicies = source.resourcePolicies;
            this.warning = source.warning;
        }

        public List<ResourcePolicy> getResourcePoliciesList() {
            return this.resourcePolicies;
        }

        public Builder addAllResourcePolicies(List<ResourcePolicy> resourcePolicies) {
            if (this.resourcePolicies == null) {
                this.resourcePolicies = new LinkedList<ResourcePolicy>();
            }
            this.resourcePolicies.addAll(resourcePolicies);
            return this;
        }

        public Builder addResourcePolicies(ResourcePolicy resourcePolicies) {
            if (this.resourcePolicies == null) {
                this.resourcePolicies = new LinkedList<ResourcePolicy>();
            }
            this.resourcePolicies.add(resourcePolicies);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public ResourcePoliciesScopedList build() {
            return new ResourcePoliciesScopedList(this.resourcePolicies, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllResourcePolicies(this.resourcePolicies);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

