/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalBackendBucketName
implements ResourceName {
    private final String backendBucket;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/backendBuckets/{backendBucket}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalBackendBucketName(Builder builder) {
        this.backendBucket = (String)Preconditions.checkNotNull((Object)builder.getBackendBucket());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalBackendBucketName of(String backendBucket, String project) {
        return ProjectGlobalBackendBucketName.newBuilder().setBackendBucket(backendBucket).setProject(project).build();
    }

    public static String format(String backendBucket, String project) {
        return ProjectGlobalBackendBucketName.of(backendBucket, project).toString();
    }

    public String getBackendBucket() {
        return this.backendBucket;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalBackendBucketName projectGlobalBackendBucketName = this;
            synchronized (projectGlobalBackendBucketName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"backendBucket", (Object)this.backendBucket);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalBackendBucketName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalBackendBucketName>(){

            public ProjectGlobalBackendBucketName parse(String formattedString) {
                return ProjectGlobalBackendBucketName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalBackendBucketName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalBackendBucketName.parse: formattedString not in valid format");
        return ProjectGlobalBackendBucketName.of((String)matchMap.get("backendBucket"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"backendBucket", this.backendBucket, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalBackendBucketName) {
            ProjectGlobalBackendBucketName that = (ProjectGlobalBackendBucketName)o;
            return Objects.equals(this.backendBucket, that.getBackendBucket()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.backendBucket, this.project);
    }

    public static class Builder {
        private String backendBucket;
        private String project;

        public String getBackendBucket() {
            return this.backendBucket;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setBackendBucket(String backendBucket) {
            this.backendBucket = backendBucket;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalBackendBucketName projectGlobalBackendBucketName) {
            this.backendBucket = projectGlobalBackendBucketName.backendBucket;
            this.project = projectGlobalBackendBucketName.project;
        }

        public ProjectGlobalBackendBucketName build() {
            return new ProjectGlobalBackendBucketName(this);
        }
    }
}

