/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.GetTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.InsertTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.ListTargetSslProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalTargetSslProxyName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SetBackendServiceTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.SetProxyHeaderTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.SetSslCertificatesTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.SetSslPolicyTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.SslPolicyReference;
import com.google.cloud.compute.v1.TargetSslProxiesSetBackendServiceRequest;
import com.google.cloud.compute.v1.TargetSslProxiesSetProxyHeaderRequest;
import com.google.cloud.compute.v1.TargetSslProxiesSetSslCertificatesRequest;
import com.google.cloud.compute.v1.TargetSslProxy;
import com.google.cloud.compute.v1.TargetSslProxyList;
import com.google.cloud.compute.v1.TargetSslProxySettings;
import com.google.cloud.compute.v1.stub.TargetSslProxyStub;
import com.google.cloud.compute.v1.stub.TargetSslProxyStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TargetSslProxyClient
implements BackgroundResource {
    private final TargetSslProxySettings settings;
    private final TargetSslProxyStub stub;

    public static final TargetSslProxyClient create() throws IOException {
        return TargetSslProxyClient.create(TargetSslProxySettings.newBuilder().build());
    }

    public static final TargetSslProxyClient create(TargetSslProxySettings settings) throws IOException {
        return new TargetSslProxyClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetSslProxyClient create(TargetSslProxyStub stub) {
        return new TargetSslProxyClient(stub);
    }

    protected TargetSslProxyClient(TargetSslProxySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetSslProxyStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetSslProxyClient(TargetSslProxyStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetSslProxySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetSslProxyStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteTargetSslProxy(ProjectGlobalTargetSslProxyName targetSslProxy) {
        DeleteTargetSslProxyHttpRequest request = DeleteTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy == null ? null : targetSslProxy.toString()).build();
        return this.deleteTargetSslProxy(request);
    }

    @BetaApi
    public final Operation deleteTargetSslProxy(String targetSslProxy) {
        DeleteTargetSslProxyHttpRequest request = DeleteTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy).build();
        return this.deleteTargetSslProxy(request);
    }

    @BetaApi
    public final Operation deleteTargetSslProxy(DeleteTargetSslProxyHttpRequest request) {
        return (Operation)this.deleteTargetSslProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteTargetSslProxyHttpRequest, Operation> deleteTargetSslProxyCallable() {
        return this.stub.deleteTargetSslProxyCallable();
    }

    @BetaApi
    public final TargetSslProxy getTargetSslProxy(ProjectGlobalTargetSslProxyName targetSslProxy) {
        GetTargetSslProxyHttpRequest request = GetTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy == null ? null : targetSslProxy.toString()).build();
        return this.getTargetSslProxy(request);
    }

    @BetaApi
    public final TargetSslProxy getTargetSslProxy(String targetSslProxy) {
        GetTargetSslProxyHttpRequest request = GetTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy).build();
        return this.getTargetSslProxy(request);
    }

    @BetaApi
    public final TargetSslProxy getTargetSslProxy(GetTargetSslProxyHttpRequest request) {
        return (TargetSslProxy)this.getTargetSslProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetTargetSslProxyHttpRequest, TargetSslProxy> getTargetSslProxyCallable() {
        return this.stub.getTargetSslProxyCallable();
    }

    @BetaApi
    public final Operation insertTargetSslProxy(ProjectName project, TargetSslProxy targetSslProxyResource) {
        InsertTargetSslProxyHttpRequest request = InsertTargetSslProxyHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setTargetSslProxyResource(targetSslProxyResource).build();
        return this.insertTargetSslProxy(request);
    }

    @BetaApi
    public final Operation insertTargetSslProxy(String project, TargetSslProxy targetSslProxyResource) {
        InsertTargetSslProxyHttpRequest request = InsertTargetSslProxyHttpRequest.newBuilder().setProject(project).setTargetSslProxyResource(targetSslProxyResource).build();
        return this.insertTargetSslProxy(request);
    }

    @BetaApi
    public final Operation insertTargetSslProxy(InsertTargetSslProxyHttpRequest request) {
        return (Operation)this.insertTargetSslProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertTargetSslProxyHttpRequest, Operation> insertTargetSslProxyCallable() {
        return this.stub.insertTargetSslProxyCallable();
    }

    @BetaApi
    public final ListTargetSslProxiesPagedResponse listTargetSslProxies(ProjectName project) {
        ListTargetSslProxiesHttpRequest request = ListTargetSslProxiesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listTargetSslProxies(request);
    }

    @BetaApi
    public final ListTargetSslProxiesPagedResponse listTargetSslProxies(String project) {
        ListTargetSslProxiesHttpRequest request = ListTargetSslProxiesHttpRequest.newBuilder().setProject(project).build();
        return this.listTargetSslProxies(request);
    }

    @BetaApi
    public final ListTargetSslProxiesPagedResponse listTargetSslProxies(ListTargetSslProxiesHttpRequest request) {
        return (ListTargetSslProxiesPagedResponse)((Object)this.listTargetSslProxiesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListTargetSslProxiesHttpRequest, ListTargetSslProxiesPagedResponse> listTargetSslProxiesPagedCallable() {
        return this.stub.listTargetSslProxiesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListTargetSslProxiesHttpRequest, TargetSslProxyList> listTargetSslProxiesCallable() {
        return this.stub.listTargetSslProxiesCallable();
    }

    @BetaApi
    public final Operation setBackendServiceTargetSslProxy(ProjectGlobalTargetSslProxyName targetSslProxy, TargetSslProxiesSetBackendServiceRequest targetSslProxiesSetBackendServiceRequestResource) {
        SetBackendServiceTargetSslProxyHttpRequest request = SetBackendServiceTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy == null ? null : targetSslProxy.toString()).setTargetSslProxiesSetBackendServiceRequestResource(targetSslProxiesSetBackendServiceRequestResource).build();
        return this.setBackendServiceTargetSslProxy(request);
    }

    @BetaApi
    public final Operation setBackendServiceTargetSslProxy(String targetSslProxy, TargetSslProxiesSetBackendServiceRequest targetSslProxiesSetBackendServiceRequestResource) {
        SetBackendServiceTargetSslProxyHttpRequest request = SetBackendServiceTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy).setTargetSslProxiesSetBackendServiceRequestResource(targetSslProxiesSetBackendServiceRequestResource).build();
        return this.setBackendServiceTargetSslProxy(request);
    }

    @BetaApi
    public final Operation setBackendServiceTargetSslProxy(SetBackendServiceTargetSslProxyHttpRequest request) {
        return (Operation)this.setBackendServiceTargetSslProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetBackendServiceTargetSslProxyHttpRequest, Operation> setBackendServiceTargetSslProxyCallable() {
        return this.stub.setBackendServiceTargetSslProxyCallable();
    }

    @BetaApi
    public final Operation setProxyHeaderTargetSslProxy(ProjectGlobalTargetSslProxyName targetSslProxy, TargetSslProxiesSetProxyHeaderRequest targetSslProxiesSetProxyHeaderRequestResource) {
        SetProxyHeaderTargetSslProxyHttpRequest request = SetProxyHeaderTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy == null ? null : targetSslProxy.toString()).setTargetSslProxiesSetProxyHeaderRequestResource(targetSslProxiesSetProxyHeaderRequestResource).build();
        return this.setProxyHeaderTargetSslProxy(request);
    }

    @BetaApi
    public final Operation setProxyHeaderTargetSslProxy(String targetSslProxy, TargetSslProxiesSetProxyHeaderRequest targetSslProxiesSetProxyHeaderRequestResource) {
        SetProxyHeaderTargetSslProxyHttpRequest request = SetProxyHeaderTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy).setTargetSslProxiesSetProxyHeaderRequestResource(targetSslProxiesSetProxyHeaderRequestResource).build();
        return this.setProxyHeaderTargetSslProxy(request);
    }

    @BetaApi
    public final Operation setProxyHeaderTargetSslProxy(SetProxyHeaderTargetSslProxyHttpRequest request) {
        return (Operation)this.setProxyHeaderTargetSslProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetProxyHeaderTargetSslProxyHttpRequest, Operation> setProxyHeaderTargetSslProxyCallable() {
        return this.stub.setProxyHeaderTargetSslProxyCallable();
    }

    @BetaApi
    public final Operation setSslCertificatesTargetSslProxy(ProjectGlobalTargetSslProxyName targetSslProxy, TargetSslProxiesSetSslCertificatesRequest targetSslProxiesSetSslCertificatesRequestResource) {
        SetSslCertificatesTargetSslProxyHttpRequest request = SetSslCertificatesTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy == null ? null : targetSslProxy.toString()).setTargetSslProxiesSetSslCertificatesRequestResource(targetSslProxiesSetSslCertificatesRequestResource).build();
        return this.setSslCertificatesTargetSslProxy(request);
    }

    @BetaApi
    public final Operation setSslCertificatesTargetSslProxy(String targetSslProxy, TargetSslProxiesSetSslCertificatesRequest targetSslProxiesSetSslCertificatesRequestResource) {
        SetSslCertificatesTargetSslProxyHttpRequest request = SetSslCertificatesTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy).setTargetSslProxiesSetSslCertificatesRequestResource(targetSslProxiesSetSslCertificatesRequestResource).build();
        return this.setSslCertificatesTargetSslProxy(request);
    }

    @BetaApi
    public final Operation setSslCertificatesTargetSslProxy(SetSslCertificatesTargetSslProxyHttpRequest request) {
        return (Operation)this.setSslCertificatesTargetSslProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetSslCertificatesTargetSslProxyHttpRequest, Operation> setSslCertificatesTargetSslProxyCallable() {
        return this.stub.setSslCertificatesTargetSslProxyCallable();
    }

    @BetaApi
    public final Operation setSslPolicyTargetSslProxy(ProjectGlobalTargetSslProxyName targetSslProxy, SslPolicyReference sslPolicyReferenceResource) {
        SetSslPolicyTargetSslProxyHttpRequest request = SetSslPolicyTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy == null ? null : targetSslProxy.toString()).setSslPolicyReferenceResource(sslPolicyReferenceResource).build();
        return this.setSslPolicyTargetSslProxy(request);
    }

    @BetaApi
    public final Operation setSslPolicyTargetSslProxy(String targetSslProxy, SslPolicyReference sslPolicyReferenceResource) {
        SetSslPolicyTargetSslProxyHttpRequest request = SetSslPolicyTargetSslProxyHttpRequest.newBuilder().setTargetSslProxy(targetSslProxy).setSslPolicyReferenceResource(sslPolicyReferenceResource).build();
        return this.setSslPolicyTargetSslProxy(request);
    }

    @BetaApi
    public final Operation setSslPolicyTargetSslProxy(SetSslPolicyTargetSslProxyHttpRequest request) {
        return (Operation)this.setSslPolicyTargetSslProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetSslPolicyTargetSslProxyHttpRequest, Operation> setSslPolicyTargetSslProxyCallable() {
        return this.stub.setSslPolicyTargetSslProxyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTargetSslProxiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxy, ListTargetSslProxiesPage, ListTargetSslProxiesFixedSizeCollection> {
        private ListTargetSslProxiesFixedSizeCollection(List<ListTargetSslProxiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTargetSslProxiesFixedSizeCollection createEmptyCollection() {
            return new ListTargetSslProxiesFixedSizeCollection(null, 0);
        }

        protected ListTargetSslProxiesFixedSizeCollection createCollection(List<ListTargetSslProxiesPage> pages, int collectionSize) {
            return new ListTargetSslProxiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTargetSslProxiesPage
    extends AbstractPage<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxy, ListTargetSslProxiesPage> {
        private ListTargetSslProxiesPage(PageContext<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxy> context, TargetSslProxyList response) {
            super(context, (Object)response);
        }

        private static ListTargetSslProxiesPage createEmptyPage() {
            return new ListTargetSslProxiesPage(null, null);
        }

        protected ListTargetSslProxiesPage createPage(PageContext<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxy> context, TargetSslProxyList response) {
            return new ListTargetSslProxiesPage(context, response);
        }

        public ApiFuture<ListTargetSslProxiesPage> createPageAsync(PageContext<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxy> context, ApiFuture<TargetSslProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTargetSslProxiesPagedResponse
    extends AbstractPagedListResponse<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxy, ListTargetSslProxiesPage, ListTargetSslProxiesFixedSizeCollection> {
        public static ApiFuture<ListTargetSslProxiesPagedResponse> createAsync(PageContext<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxy> context, ApiFuture<TargetSslProxyList> futureResponse) {
            ApiFuture<ListTargetSslProxiesPage> futurePage = ListTargetSslProxiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTargetSslProxiesPage, ListTargetSslProxiesPagedResponse>(){

                public ListTargetSslProxiesPagedResponse apply(ListTargetSslProxiesPage input) {
                    return new ListTargetSslProxiesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTargetSslProxiesPagedResponse(ListTargetSslProxiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTargetSslProxiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

