/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.NodeGroup;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NodeGroupsScopedList
implements ApiMessage {
    private final List<NodeGroup> nodeGroups;
    private final Warning warning;
    private static final NodeGroupsScopedList DEFAULT_INSTANCE = new NodeGroupsScopedList();

    private NodeGroupsScopedList() {
        this.nodeGroups = null;
        this.warning = null;
    }

    private NodeGroupsScopedList(List<NodeGroup> nodeGroups, Warning warning) {
        this.nodeGroups = nodeGroups;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("nodeGroups".equals(fieldName)) {
            return this.nodeGroups;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<NodeGroup> getNodeGroupsList() {
        return this.nodeGroups;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NodeGroupsScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NodeGroupsScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NodeGroupsScopedList{nodeGroups=" + this.nodeGroups + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NodeGroupsScopedList) {
            NodeGroupsScopedList that = (NodeGroupsScopedList)o;
            return Objects.equals(this.nodeGroups, that.getNodeGroupsList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.nodeGroups, this.warning);
    }

    public static class Builder {
        private List<NodeGroup> nodeGroups;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(NodeGroupsScopedList other) {
            if (other == NodeGroupsScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getNodeGroupsList() != null) {
                this.nodeGroups = other.nodeGroups;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(NodeGroupsScopedList source) {
            this.nodeGroups = source.nodeGroups;
            this.warning = source.warning;
        }

        public List<NodeGroup> getNodeGroupsList() {
            return this.nodeGroups;
        }

        public Builder addAllNodeGroups(List<NodeGroup> nodeGroups) {
            if (this.nodeGroups == null) {
                this.nodeGroups = new LinkedList<NodeGroup>();
            }
            this.nodeGroups.addAll(nodeGroups);
            return this;
        }

        public Builder addNodeGroups(NodeGroup nodeGroups) {
            if (this.nodeGroups == null) {
                this.nodeGroups = new LinkedList<NodeGroup>();
            }
            this.nodeGroups.add(nodeGroups);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public NodeGroupsScopedList build() {
            return new NodeGroupsScopedList(this.nodeGroups, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllNodeGroups(this.nodeGroups);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

