/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AcceleratorConfig;
import com.google.cloud.compute.v1.AttachedDisk;
import com.google.cloud.compute.v1.Metadata;
import com.google.cloud.compute.v1.NetworkInterface;
import com.google.cloud.compute.v1.ReservationAffinity;
import com.google.cloud.compute.v1.Scheduling;
import com.google.cloud.compute.v1.ServiceAccount;
import com.google.cloud.compute.v1.ShieldedInstanceConfig;
import com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy;
import com.google.cloud.compute.v1.Tags;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Instance
implements ApiMessage {
    private final Boolean canIpForward;
    private final String cpuPlatform;
    private final String creationTimestamp;
    private final Boolean deletionProtection;
    private final String description;
    private final List<AttachedDisk> disks;
    private final List<AcceleratorConfig> guestAccelerators;
    private final String hostname;
    private final String id;
    private final String kind;
    private final String labelFingerprint;
    private final Map<String, String> labels;
    private final String machineType;
    private final Metadata metadata;
    private final String minCpuPlatform;
    private final String name;
    private final List<NetworkInterface> networkInterfaces;
    private final ReservationAffinity reservationAffinity;
    private final Scheduling scheduling;
    private final String selfLink;
    private final List<ServiceAccount> serviceAccounts;
    private final ShieldedInstanceConfig shieldedInstanceConfig;
    private final ShieldedInstanceIntegrityPolicy shieldedInstanceIntegrityPolicy;
    private final Boolean startRestricted;
    private final String status;
    private final String statusMessage;
    private final Tags tags;
    private final String zone;
    private static final Instance DEFAULT_INSTANCE = new Instance();

    private Instance() {
        this.canIpForward = null;
        this.cpuPlatform = null;
        this.creationTimestamp = null;
        this.deletionProtection = null;
        this.description = null;
        this.disks = null;
        this.guestAccelerators = null;
        this.hostname = null;
        this.id = null;
        this.kind = null;
        this.labelFingerprint = null;
        this.labels = null;
        this.machineType = null;
        this.metadata = null;
        this.minCpuPlatform = null;
        this.name = null;
        this.networkInterfaces = null;
        this.reservationAffinity = null;
        this.scheduling = null;
        this.selfLink = null;
        this.serviceAccounts = null;
        this.shieldedInstanceConfig = null;
        this.shieldedInstanceIntegrityPolicy = null;
        this.startRestricted = null;
        this.status = null;
        this.statusMessage = null;
        this.tags = null;
        this.zone = null;
    }

    private Instance(Boolean canIpForward, String cpuPlatform, String creationTimestamp, Boolean deletionProtection, String description, List<AttachedDisk> disks, List<AcceleratorConfig> guestAccelerators, String hostname, String id, String kind, String labelFingerprint, Map<String, String> labels, String machineType, Metadata metadata, String minCpuPlatform, String name, List<NetworkInterface> networkInterfaces, ReservationAffinity reservationAffinity, Scheduling scheduling, String selfLink, List<ServiceAccount> serviceAccounts, ShieldedInstanceConfig shieldedInstanceConfig, ShieldedInstanceIntegrityPolicy shieldedInstanceIntegrityPolicy, Boolean startRestricted, String status, String statusMessage, Tags tags, String zone) {
        this.canIpForward = canIpForward;
        this.cpuPlatform = cpuPlatform;
        this.creationTimestamp = creationTimestamp;
        this.deletionProtection = deletionProtection;
        this.description = description;
        this.disks = disks;
        this.guestAccelerators = guestAccelerators;
        this.hostname = hostname;
        this.id = id;
        this.kind = kind;
        this.labelFingerprint = labelFingerprint;
        this.labels = labels;
        this.machineType = machineType;
        this.metadata = metadata;
        this.minCpuPlatform = minCpuPlatform;
        this.name = name;
        this.networkInterfaces = networkInterfaces;
        this.reservationAffinity = reservationAffinity;
        this.scheduling = scheduling;
        this.selfLink = selfLink;
        this.serviceAccounts = serviceAccounts;
        this.shieldedInstanceConfig = shieldedInstanceConfig;
        this.shieldedInstanceIntegrityPolicy = shieldedInstanceIntegrityPolicy;
        this.startRestricted = startRestricted;
        this.status = status;
        this.statusMessage = statusMessage;
        this.tags = tags;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if ("canIpForward".equals(fieldName)) {
            return this.canIpForward;
        }
        if ("cpuPlatform".equals(fieldName)) {
            return this.cpuPlatform;
        }
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("deletionProtection".equals(fieldName)) {
            return this.deletionProtection;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("disks".equals(fieldName)) {
            return this.disks;
        }
        if ("guestAccelerators".equals(fieldName)) {
            return this.guestAccelerators;
        }
        if ("hostname".equals(fieldName)) {
            return this.hostname;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("labelFingerprint".equals(fieldName)) {
            return this.labelFingerprint;
        }
        if ("labels".equals(fieldName)) {
            return this.labels;
        }
        if ("machineType".equals(fieldName)) {
            return this.machineType;
        }
        if ("metadata".equals(fieldName)) {
            return this.metadata;
        }
        if ("minCpuPlatform".equals(fieldName)) {
            return this.minCpuPlatform;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("networkInterfaces".equals(fieldName)) {
            return this.networkInterfaces;
        }
        if ("reservationAffinity".equals(fieldName)) {
            return this.reservationAffinity;
        }
        if ("scheduling".equals(fieldName)) {
            return this.scheduling;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("serviceAccounts".equals(fieldName)) {
            return this.serviceAccounts;
        }
        if ("shieldedInstanceConfig".equals(fieldName)) {
            return this.shieldedInstanceConfig;
        }
        if ("shieldedInstanceIntegrityPolicy".equals(fieldName)) {
            return this.shieldedInstanceIntegrityPolicy;
        }
        if ("startRestricted".equals(fieldName)) {
            return this.startRestricted;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        if ("statusMessage".equals(fieldName)) {
            return this.statusMessage;
        }
        if ("tags".equals(fieldName)) {
            return this.tags;
        }
        if ("zone".equals(fieldName)) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getCanIpForward() {
        return this.canIpForward;
    }

    public String getCpuPlatform() {
        return this.cpuPlatform;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public Boolean getDeletionProtection() {
        return this.deletionProtection;
    }

    public String getDescription() {
        return this.description;
    }

    public List<AttachedDisk> getDisksList() {
        return this.disks;
    }

    public List<AcceleratorConfig> getGuestAcceleratorsList() {
        return this.guestAccelerators;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getLabelFingerprint() {
        return this.labelFingerprint;
    }

    public Map<String, String> getLabelsMap() {
        return this.labels;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public String getMinCpuPlatform() {
        return this.minCpuPlatform;
    }

    public String getName() {
        return this.name;
    }

    public List<NetworkInterface> getNetworkInterfacesList() {
        return this.networkInterfaces;
    }

    public ReservationAffinity getReservationAffinity() {
        return this.reservationAffinity;
    }

    public Scheduling getScheduling() {
        return this.scheduling;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public List<ServiceAccount> getServiceAccountsList() {
        return this.serviceAccounts;
    }

    public ShieldedInstanceConfig getShieldedInstanceConfig() {
        return this.shieldedInstanceConfig;
    }

    public ShieldedInstanceIntegrityPolicy getShieldedInstanceIntegrityPolicy() {
        return this.shieldedInstanceIntegrityPolicy;
    }

    public Boolean getStartRestricted() {
        return this.startRestricted;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Tags getTags() {
        return this.tags;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Instance prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Instance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Instance{canIpForward=" + this.canIpForward + ", cpuPlatform=" + this.cpuPlatform + ", creationTimestamp=" + this.creationTimestamp + ", deletionProtection=" + this.deletionProtection + ", description=" + this.description + ", disks=" + this.disks + ", guestAccelerators=" + this.guestAccelerators + ", hostname=" + this.hostname + ", id=" + this.id + ", kind=" + this.kind + ", labelFingerprint=" + this.labelFingerprint + ", labels=" + this.labels + ", machineType=" + this.machineType + ", metadata=" + this.metadata + ", minCpuPlatform=" + this.minCpuPlatform + ", name=" + this.name + ", networkInterfaces=" + this.networkInterfaces + ", reservationAffinity=" + this.reservationAffinity + ", scheduling=" + this.scheduling + ", selfLink=" + this.selfLink + ", serviceAccounts=" + this.serviceAccounts + ", shieldedInstanceConfig=" + this.shieldedInstanceConfig + ", shieldedInstanceIntegrityPolicy=" + this.shieldedInstanceIntegrityPolicy + ", startRestricted=" + this.startRestricted + ", status=" + this.status + ", statusMessage=" + this.statusMessage + ", tags=" + this.tags + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Instance) {
            Instance that = (Instance)o;
            return Objects.equals(this.canIpForward, that.getCanIpForward()) && Objects.equals(this.cpuPlatform, that.getCpuPlatform()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.deletionProtection, that.getDeletionProtection()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.disks, that.getDisksList()) && Objects.equals(this.guestAccelerators, that.getGuestAcceleratorsList()) && Objects.equals(this.hostname, that.getHostname()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.labelFingerprint, that.getLabelFingerprint()) && Objects.equals(this.labels, that.getLabelsMap()) && Objects.equals(this.machineType, that.getMachineType()) && Objects.equals(this.metadata, that.getMetadata()) && Objects.equals(this.minCpuPlatform, that.getMinCpuPlatform()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.networkInterfaces, that.getNetworkInterfacesList()) && Objects.equals(this.reservationAffinity, that.getReservationAffinity()) && Objects.equals(this.scheduling, that.getScheduling()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.serviceAccounts, that.getServiceAccountsList()) && Objects.equals(this.shieldedInstanceConfig, that.getShieldedInstanceConfig()) && Objects.equals(this.shieldedInstanceIntegrityPolicy, that.getShieldedInstanceIntegrityPolicy()) && Objects.equals(this.startRestricted, that.getStartRestricted()) && Objects.equals(this.status, that.getStatus()) && Objects.equals(this.statusMessage, that.getStatusMessage()) && Objects.equals(this.tags, that.getTags()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.canIpForward, this.cpuPlatform, this.creationTimestamp, this.deletionProtection, this.description, this.disks, this.guestAccelerators, this.hostname, this.id, this.kind, this.labelFingerprint, this.labels, this.machineType, this.metadata, this.minCpuPlatform, this.name, this.networkInterfaces, this.reservationAffinity, this.scheduling, this.selfLink, this.serviceAccounts, this.shieldedInstanceConfig, this.shieldedInstanceIntegrityPolicy, this.startRestricted, this.status, this.statusMessage, this.tags, this.zone);
    }

    public static class Builder {
        private Boolean canIpForward;
        private String cpuPlatform;
        private String creationTimestamp;
        private Boolean deletionProtection;
        private String description;
        private List<AttachedDisk> disks;
        private List<AcceleratorConfig> guestAccelerators;
        private String hostname;
        private String id;
        private String kind;
        private String labelFingerprint;
        private Map<String, String> labels;
        private String machineType;
        private Metadata metadata;
        private String minCpuPlatform;
        private String name;
        private List<NetworkInterface> networkInterfaces;
        private ReservationAffinity reservationAffinity;
        private Scheduling scheduling;
        private String selfLink;
        private List<ServiceAccount> serviceAccounts;
        private ShieldedInstanceConfig shieldedInstanceConfig;
        private ShieldedInstanceIntegrityPolicy shieldedInstanceIntegrityPolicy;
        private Boolean startRestricted;
        private String status;
        private String statusMessage;
        private Tags tags;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(Instance other) {
            if (other == Instance.getDefaultInstance()) {
                return this;
            }
            if (other.getCanIpForward() != null) {
                this.canIpForward = other.canIpForward;
            }
            if (other.getCpuPlatform() != null) {
                this.cpuPlatform = other.cpuPlatform;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDeletionProtection() != null) {
                this.deletionProtection = other.deletionProtection;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getDisksList() != null) {
                this.disks = other.disks;
            }
            if (other.getGuestAcceleratorsList() != null) {
                this.guestAccelerators = other.guestAccelerators;
            }
            if (other.getHostname() != null) {
                this.hostname = other.hostname;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getLabelFingerprint() != null) {
                this.labelFingerprint = other.labelFingerprint;
            }
            if (other.getLabelsMap() != null) {
                this.labels = other.labels;
            }
            if (other.getMachineType() != null) {
                this.machineType = other.machineType;
            }
            if (other.getMetadata() != null) {
                this.metadata = other.metadata;
            }
            if (other.getMinCpuPlatform() != null) {
                this.minCpuPlatform = other.minCpuPlatform;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetworkInterfacesList() != null) {
                this.networkInterfaces = other.networkInterfaces;
            }
            if (other.getReservationAffinity() != null) {
                this.reservationAffinity = other.reservationAffinity;
            }
            if (other.getScheduling() != null) {
                this.scheduling = other.scheduling;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getServiceAccountsList() != null) {
                this.serviceAccounts = other.serviceAccounts;
            }
            if (other.getShieldedInstanceConfig() != null) {
                this.shieldedInstanceConfig = other.shieldedInstanceConfig;
            }
            if (other.getShieldedInstanceIntegrityPolicy() != null) {
                this.shieldedInstanceIntegrityPolicy = other.shieldedInstanceIntegrityPolicy;
            }
            if (other.getStartRestricted() != null) {
                this.startRestricted = other.startRestricted;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            if (other.getStatusMessage() != null) {
                this.statusMessage = other.statusMessage;
            }
            if (other.getTags() != null) {
                this.tags = other.tags;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(Instance source) {
            this.canIpForward = source.canIpForward;
            this.cpuPlatform = source.cpuPlatform;
            this.creationTimestamp = source.creationTimestamp;
            this.deletionProtection = source.deletionProtection;
            this.description = source.description;
            this.disks = source.disks;
            this.guestAccelerators = source.guestAccelerators;
            this.hostname = source.hostname;
            this.id = source.id;
            this.kind = source.kind;
            this.labelFingerprint = source.labelFingerprint;
            this.labels = source.labels;
            this.machineType = source.machineType;
            this.metadata = source.metadata;
            this.minCpuPlatform = source.minCpuPlatform;
            this.name = source.name;
            this.networkInterfaces = source.networkInterfaces;
            this.reservationAffinity = source.reservationAffinity;
            this.scheduling = source.scheduling;
            this.selfLink = source.selfLink;
            this.serviceAccounts = source.serviceAccounts;
            this.shieldedInstanceConfig = source.shieldedInstanceConfig;
            this.shieldedInstanceIntegrityPolicy = source.shieldedInstanceIntegrityPolicy;
            this.startRestricted = source.startRestricted;
            this.status = source.status;
            this.statusMessage = source.statusMessage;
            this.tags = source.tags;
            this.zone = source.zone;
        }

        public Boolean getCanIpForward() {
            return this.canIpForward;
        }

        public Builder setCanIpForward(Boolean canIpForward) {
            this.canIpForward = canIpForward;
            return this;
        }

        public String getCpuPlatform() {
            return this.cpuPlatform;
        }

        public Builder setCpuPlatform(String cpuPlatform) {
            this.cpuPlatform = cpuPlatform;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public Builder setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public List<AttachedDisk> getDisksList() {
            return this.disks;
        }

        public Builder addAllDisks(List<AttachedDisk> disks) {
            if (this.disks == null) {
                this.disks = new LinkedList<AttachedDisk>();
            }
            this.disks.addAll(disks);
            return this;
        }

        public Builder addDisks(AttachedDisk disks) {
            if (this.disks == null) {
                this.disks = new LinkedList<AttachedDisk>();
            }
            this.disks.add(disks);
            return this;
        }

        public List<AcceleratorConfig> getGuestAcceleratorsList() {
            return this.guestAccelerators;
        }

        public Builder addAllGuestAccelerators(List<AcceleratorConfig> guestAccelerators) {
            if (this.guestAccelerators == null) {
                this.guestAccelerators = new LinkedList<AcceleratorConfig>();
            }
            this.guestAccelerators.addAll(guestAccelerators);
            return this;
        }

        public Builder addGuestAccelerators(AcceleratorConfig guestAccelerators) {
            if (this.guestAccelerators == null) {
                this.guestAccelerators = new LinkedList<AcceleratorConfig>();
            }
            this.guestAccelerators.add(guestAccelerators);
            return this;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getLabelFingerprint() {
            return this.labelFingerprint;
        }

        public Builder setLabelFingerprint(String labelFingerprint) {
            this.labelFingerprint = labelFingerprint;
            return this;
        }

        public Map<String, String> getLabelsMap() {
            return this.labels;
        }

        public Builder putAllLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public String getMachineType() {
            return this.machineType;
        }

        public Builder setMachineType(String machineType) {
            this.machineType = machineType;
            return this;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        public Builder setMetadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public String getMinCpuPlatform() {
            return this.minCpuPlatform;
        }

        public Builder setMinCpuPlatform(String minCpuPlatform) {
            this.minCpuPlatform = minCpuPlatform;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public List<NetworkInterface> getNetworkInterfacesList() {
            return this.networkInterfaces;
        }

        public Builder addAllNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
            if (this.networkInterfaces == null) {
                this.networkInterfaces = new LinkedList<NetworkInterface>();
            }
            this.networkInterfaces.addAll(networkInterfaces);
            return this;
        }

        public Builder addNetworkInterfaces(NetworkInterface networkInterfaces) {
            if (this.networkInterfaces == null) {
                this.networkInterfaces = new LinkedList<NetworkInterface>();
            }
            this.networkInterfaces.add(networkInterfaces);
            return this;
        }

        public ReservationAffinity getReservationAffinity() {
            return this.reservationAffinity;
        }

        public Builder setReservationAffinity(ReservationAffinity reservationAffinity) {
            this.reservationAffinity = reservationAffinity;
            return this;
        }

        public Scheduling getScheduling() {
            return this.scheduling;
        }

        public Builder setScheduling(Scheduling scheduling) {
            this.scheduling = scheduling;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public List<ServiceAccount> getServiceAccountsList() {
            return this.serviceAccounts;
        }

        public Builder addAllServiceAccounts(List<ServiceAccount> serviceAccounts) {
            if (this.serviceAccounts == null) {
                this.serviceAccounts = new LinkedList<ServiceAccount>();
            }
            this.serviceAccounts.addAll(serviceAccounts);
            return this;
        }

        public Builder addServiceAccounts(ServiceAccount serviceAccounts) {
            if (this.serviceAccounts == null) {
                this.serviceAccounts = new LinkedList<ServiceAccount>();
            }
            this.serviceAccounts.add(serviceAccounts);
            return this;
        }

        public ShieldedInstanceConfig getShieldedInstanceConfig() {
            return this.shieldedInstanceConfig;
        }

        public Builder setShieldedInstanceConfig(ShieldedInstanceConfig shieldedInstanceConfig) {
            this.shieldedInstanceConfig = shieldedInstanceConfig;
            return this;
        }

        public ShieldedInstanceIntegrityPolicy getShieldedInstanceIntegrityPolicy() {
            return this.shieldedInstanceIntegrityPolicy;
        }

        public Builder setShieldedInstanceIntegrityPolicy(ShieldedInstanceIntegrityPolicy shieldedInstanceIntegrityPolicy) {
            this.shieldedInstanceIntegrityPolicy = shieldedInstanceIntegrityPolicy;
            return this;
        }

        public Boolean getStartRestricted() {
            return this.startRestricted;
        }

        public Builder setStartRestricted(Boolean startRestricted) {
            this.startRestricted = startRestricted;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public Builder setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Tags getTags() {
            return this.tags;
        }

        public Builder setTags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Instance build() {
            return new Instance(this.canIpForward, this.cpuPlatform, this.creationTimestamp, this.deletionProtection, this.description, this.disks, this.guestAccelerators, this.hostname, this.id, this.kind, this.labelFingerprint, this.labels, this.machineType, this.metadata, this.minCpuPlatform, this.name, this.networkInterfaces, this.reservationAffinity, this.scheduling, this.selfLink, this.serviceAccounts, this.shieldedInstanceConfig, this.shieldedInstanceIntegrityPolicy, this.startRestricted, this.status, this.statusMessage, this.tags, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCanIpForward(this.canIpForward);
            newBuilder.setCpuPlatform(this.cpuPlatform);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDeletionProtection(this.deletionProtection);
            newBuilder.setDescription(this.description);
            newBuilder.addAllDisks(this.disks);
            newBuilder.addAllGuestAccelerators(this.guestAccelerators);
            newBuilder.setHostname(this.hostname);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setLabelFingerprint(this.labelFingerprint);
            newBuilder.putAllLabels(this.labels);
            newBuilder.setMachineType(this.machineType);
            newBuilder.setMetadata(this.metadata);
            newBuilder.setMinCpuPlatform(this.minCpuPlatform);
            newBuilder.setName(this.name);
            newBuilder.addAllNetworkInterfaces(this.networkInterfaces);
            newBuilder.setReservationAffinity(this.reservationAffinity);
            newBuilder.setScheduling(this.scheduling);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.addAllServiceAccounts(this.serviceAccounts);
            newBuilder.setShieldedInstanceConfig(this.shieldedInstanceConfig);
            newBuilder.setShieldedInstanceIntegrityPolicy(this.shieldedInstanceIntegrityPolicy);
            newBuilder.setStartRestricted(this.startRestricted);
            newBuilder.setStatus(this.status);
            newBuilder.setStatusMessage(this.statusMessage);
            newBuilder.setTags(this.tags);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

