/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class GlobalSetLabelsRequest
implements ApiMessage {
    private final String labelFingerprint;
    private final Map<String, String> labels;
    private static final GlobalSetLabelsRequest DEFAULT_INSTANCE = new GlobalSetLabelsRequest();

    private GlobalSetLabelsRequest() {
        this.labelFingerprint = null;
        this.labels = null;
    }

    private GlobalSetLabelsRequest(String labelFingerprint, Map<String, String> labels) {
        this.labelFingerprint = labelFingerprint;
        this.labels = labels;
    }

    public Object getFieldValue(String fieldName) {
        if ("labelFingerprint".equals(fieldName)) {
            return this.labelFingerprint;
        }
        if ("labels".equals(fieldName)) {
            return this.labels;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getLabelFingerprint() {
        return this.labelFingerprint;
    }

    public Map<String, String> getLabelsMap() {
        return this.labels;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GlobalSetLabelsRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static GlobalSetLabelsRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "GlobalSetLabelsRequest{labelFingerprint=" + this.labelFingerprint + ", labels=" + this.labels + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GlobalSetLabelsRequest) {
            GlobalSetLabelsRequest that = (GlobalSetLabelsRequest)o;
            return Objects.equals(this.labelFingerprint, that.getLabelFingerprint()) && Objects.equals(this.labels, that.getLabelsMap());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.labelFingerprint, this.labels);
    }

    public static class Builder {
        private String labelFingerprint;
        private Map<String, String> labels;

        Builder() {
        }

        public Builder mergeFrom(GlobalSetLabelsRequest other) {
            if (other == GlobalSetLabelsRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getLabelFingerprint() != null) {
                this.labelFingerprint = other.labelFingerprint;
            }
            if (other.getLabelsMap() != null) {
                this.labels = other.labels;
            }
            return this;
        }

        Builder(GlobalSetLabelsRequest source) {
            this.labelFingerprint = source.labelFingerprint;
            this.labels = source.labels;
        }

        public String getLabelFingerprint() {
            return this.labelFingerprint;
        }

        public Builder setLabelFingerprint(String labelFingerprint) {
            this.labelFingerprint = labelFingerprint;
            return this;
        }

        public Map<String, String> getLabelsMap() {
            return this.labels;
        }

        public Builder putAllLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public GlobalSetLabelsRequest build() {
            return new GlobalSetLabelsRequest(this.labelFingerprint, this.labels);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setLabelFingerprint(this.labelFingerprint);
            newBuilder.putAllLabels(this.labels);
            return newBuilder;
        }
    }
}

