/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2.Case;
import com.google.cloud.support.v2.CaseServiceClient;
import com.google.cloud.support.v2.CloseCaseRequest;
import com.google.cloud.support.v2.CreateCaseRequest;
import com.google.cloud.support.v2.EscalateCaseRequest;
import com.google.cloud.support.v2.GetCaseRequest;
import com.google.cloud.support.v2.ListCasesRequest;
import com.google.cloud.support.v2.ListCasesResponse;
import com.google.cloud.support.v2.SearchCaseClassificationsRequest;
import com.google.cloud.support.v2.SearchCaseClassificationsResponse;
import com.google.cloud.support.v2.SearchCasesRequest;
import com.google.cloud.support.v2.SearchCasesResponse;
import com.google.cloud.support.v2.UpdateCaseRequest;
import com.google.cloud.support.v2.stub.CaseServiceStub;
import com.google.cloud.support.v2.stub.CaseServiceStubSettings;
import com.google.cloud.support.v2.stub.HttpJsonCaseServiceCallableFactory;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCaseServiceStub
extends CaseServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetCaseRequest, Case> getCaseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.support.v2.CaseService/GetCase").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/cases/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=organizations/*/cases/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Case.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCasesRequest, ListCasesResponse> listCasesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.support.v2.CaseService/ListCases").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*}/cases", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=organizations/*}/cases"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCasesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchCasesRequest, SearchCasesResponse> searchCasesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.support.v2.CaseService/SearchCases").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*}/cases:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=organizations/*}/cases:search"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchCasesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateCaseRequest, Case> createCaseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.support.v2.CaseService/CreateCase").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*}/cases", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=organizations/*}/cases"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("case_", (Message)request.getCase(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Case.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCaseRequest, Case> updateCaseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.support.v2.CaseService/UpdateCase").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{case.name=projects/*/cases/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "case.name", (Object)request.getCase().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{case.name=organizations/*/cases/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("case_", (Message)request.getCase(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Case.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<EscalateCaseRequest, Case> escalateCaseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.support.v2.CaseService/EscalateCase").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/cases/*}:escalate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=organizations/*/cases/*}:escalate"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Case.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CloseCaseRequest, Case> closeCaseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.support.v2.CaseService/CloseCase").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/cases/*}:close", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=organizations/*/cases/*}:close"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Case.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse> searchCaseClassificationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.support.v2.CaseService/SearchCaseClassifications").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/caseClassifications:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchCaseClassificationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetCaseRequest, Case> getCaseCallable;
    private final UnaryCallable<ListCasesRequest, ListCasesResponse> listCasesCallable;
    private final UnaryCallable<ListCasesRequest, CaseServiceClient.ListCasesPagedResponse> listCasesPagedCallable;
    private final UnaryCallable<SearchCasesRequest, SearchCasesResponse> searchCasesCallable;
    private final UnaryCallable<SearchCasesRequest, CaseServiceClient.SearchCasesPagedResponse> searchCasesPagedCallable;
    private final UnaryCallable<CreateCaseRequest, Case> createCaseCallable;
    private final UnaryCallable<UpdateCaseRequest, Case> updateCaseCallable;
    private final UnaryCallable<EscalateCaseRequest, Case> escalateCaseCallable;
    private final UnaryCallable<CloseCaseRequest, Case> closeCaseCallable;
    private final UnaryCallable<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse> searchCaseClassificationsCallable;
    private final UnaryCallable<SearchCaseClassificationsRequest, CaseServiceClient.SearchCaseClassificationsPagedResponse> searchCaseClassificationsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCaseServiceStub create(CaseServiceStubSettings settings) throws IOException {
        return new HttpJsonCaseServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCaseServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCaseServiceStub(CaseServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCaseServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCaseServiceStub(CaseServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCaseServiceStub(CaseServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCaseServiceCallableFactory());
    }

    protected HttpJsonCaseServiceStub(CaseServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getCaseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCaseMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listCasesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCasesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings searchCasesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchCasesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createCaseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createCaseMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateCaseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCaseMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings escalateCaseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(escalateCaseMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings closeCaseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(closeCaseMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings searchCaseClassificationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchCaseClassificationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.getCaseCallable = callableFactory.createUnaryCallable(getCaseTransportSettings, settings.getCaseSettings(), clientContext);
        this.listCasesCallable = callableFactory.createUnaryCallable(listCasesTransportSettings, settings.listCasesSettings(), clientContext);
        this.listCasesPagedCallable = callableFactory.createPagedCallable(listCasesTransportSettings, settings.listCasesSettings(), clientContext);
        this.searchCasesCallable = callableFactory.createUnaryCallable(searchCasesTransportSettings, settings.searchCasesSettings(), clientContext);
        this.searchCasesPagedCallable = callableFactory.createPagedCallable(searchCasesTransportSettings, settings.searchCasesSettings(), clientContext);
        this.createCaseCallable = callableFactory.createUnaryCallable(createCaseTransportSettings, settings.createCaseSettings(), clientContext);
        this.updateCaseCallable = callableFactory.createUnaryCallable(updateCaseTransportSettings, settings.updateCaseSettings(), clientContext);
        this.escalateCaseCallable = callableFactory.createUnaryCallable(escalateCaseTransportSettings, settings.escalateCaseSettings(), clientContext);
        this.closeCaseCallable = callableFactory.createUnaryCallable(closeCaseTransportSettings, settings.closeCaseSettings(), clientContext);
        this.searchCaseClassificationsCallable = callableFactory.createUnaryCallable(searchCaseClassificationsTransportSettings, settings.searchCaseClassificationsSettings(), clientContext);
        this.searchCaseClassificationsPagedCallable = callableFactory.createPagedCallable(searchCaseClassificationsTransportSettings, settings.searchCaseClassificationsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getCaseMethodDescriptor);
        methodDescriptors.add(listCasesMethodDescriptor);
        methodDescriptors.add(searchCasesMethodDescriptor);
        methodDescriptors.add(createCaseMethodDescriptor);
        methodDescriptors.add(updateCaseMethodDescriptor);
        methodDescriptors.add(escalateCaseMethodDescriptor);
        methodDescriptors.add(closeCaseMethodDescriptor);
        methodDescriptors.add(searchCaseClassificationsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetCaseRequest, Case> getCaseCallable() {
        return this.getCaseCallable;
    }

    @Override
    public UnaryCallable<ListCasesRequest, ListCasesResponse> listCasesCallable() {
        return this.listCasesCallable;
    }

    @Override
    public UnaryCallable<ListCasesRequest, CaseServiceClient.ListCasesPagedResponse> listCasesPagedCallable() {
        return this.listCasesPagedCallable;
    }

    @Override
    public UnaryCallable<SearchCasesRequest, SearchCasesResponse> searchCasesCallable() {
        return this.searchCasesCallable;
    }

    @Override
    public UnaryCallable<SearchCasesRequest, CaseServiceClient.SearchCasesPagedResponse> searchCasesPagedCallable() {
        return this.searchCasesPagedCallable;
    }

    @Override
    public UnaryCallable<CreateCaseRequest, Case> createCaseCallable() {
        return this.createCaseCallable;
    }

    @Override
    public UnaryCallable<UpdateCaseRequest, Case> updateCaseCallable() {
        return this.updateCaseCallable;
    }

    @Override
    public UnaryCallable<EscalateCaseRequest, Case> escalateCaseCallable() {
        return this.escalateCaseCallable;
    }

    @Override
    public UnaryCallable<CloseCaseRequest, Case> closeCaseCallable() {
        return this.closeCaseCallable;
    }

    @Override
    public UnaryCallable<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse> searchCaseClassificationsCallable() {
        return this.searchCaseClassificationsCallable;
    }

    @Override
    public UnaryCallable<SearchCaseClassificationsRequest, CaseServiceClient.SearchCaseClassificationsPagedResponse> searchCaseClassificationsPagedCallable() {
        return this.searchCaseClassificationsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

