/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.CloudControl;
import com.google.cloud.cloudsecuritycompliance.v1.CloudControlName;
import com.google.cloud.cloudsecuritycompliance.v1.ConfigSettings;
import com.google.cloud.cloudsecuritycompliance.v1.CreateCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.CreateFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.Framework;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkName;
import com.google.cloud.cloudsecuritycompliance.v1.GetCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.GetFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworksRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworksResponse;
import com.google.cloud.cloudsecuritycompliance.v1.OrganizationLocationName;
import com.google.cloud.cloudsecuritycompliance.v1.UpdateCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.UpdateFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.stub.ConfigStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.ConfigStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ConfigClient
implements BackgroundResource {
    private final ConfigSettings settings;
    private final ConfigStub stub;

    public static final ConfigClient create() throws IOException {
        return ConfigClient.create(ConfigSettings.newBuilder().build());
    }

    public static final ConfigClient create(ConfigSettings settings) throws IOException {
        return new ConfigClient(settings);
    }

    public static final ConfigClient create(ConfigStub stub) {
        return new ConfigClient(stub);
    }

    protected ConfigClient(ConfigSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConfigStubSettings)settings.getStubSettings()).createStub();
    }

    protected ConfigClient(ConfigStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConfigSettings getSettings() {
        return this.settings;
    }

    public ConfigStub getStub() {
        return this.stub;
    }

    public final ListFrameworksPagedResponse listFrameworks(OrganizationLocationName parent) {
        ListFrameworksRequest request = ListFrameworksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFrameworks(request);
    }

    public final ListFrameworksPagedResponse listFrameworks(String parent) {
        ListFrameworksRequest request = ListFrameworksRequest.newBuilder().setParent(parent).build();
        return this.listFrameworks(request);
    }

    public final ListFrameworksPagedResponse listFrameworks(ListFrameworksRequest request) {
        return (ListFrameworksPagedResponse)((Object)this.listFrameworksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFrameworksRequest, ListFrameworksPagedResponse> listFrameworksPagedCallable() {
        return this.stub.listFrameworksPagedCallable();
    }

    public final UnaryCallable<ListFrameworksRequest, ListFrameworksResponse> listFrameworksCallable() {
        return this.stub.listFrameworksCallable();
    }

    public final Framework getFramework(FrameworkName name) {
        GetFrameworkRequest request = GetFrameworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFramework(request);
    }

    public final Framework getFramework(String name) {
        GetFrameworkRequest request = GetFrameworkRequest.newBuilder().setName(name).build();
        return this.getFramework(request);
    }

    public final Framework getFramework(GetFrameworkRequest request) {
        return (Framework)this.getFrameworkCallable().call((Object)request);
    }

    public final UnaryCallable<GetFrameworkRequest, Framework> getFrameworkCallable() {
        return this.stub.getFrameworkCallable();
    }

    public final Framework createFramework(OrganizationLocationName parent, Framework framework, String frameworkId) {
        CreateFrameworkRequest request = CreateFrameworkRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFramework(framework).setFrameworkId(frameworkId).build();
        return this.createFramework(request);
    }

    public final Framework createFramework(String parent, Framework framework, String frameworkId) {
        CreateFrameworkRequest request = CreateFrameworkRequest.newBuilder().setParent(parent).setFramework(framework).setFrameworkId(frameworkId).build();
        return this.createFramework(request);
    }

    public final Framework createFramework(CreateFrameworkRequest request) {
        return (Framework)this.createFrameworkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateFrameworkRequest, Framework> createFrameworkCallable() {
        return this.stub.createFrameworkCallable();
    }

    public final Framework updateFramework(Framework framework, FieldMask updateMask) {
        UpdateFrameworkRequest request = UpdateFrameworkRequest.newBuilder().setFramework(framework).setUpdateMask(updateMask).build();
        return this.updateFramework(request);
    }

    public final Framework updateFramework(UpdateFrameworkRequest request) {
        return (Framework)this.updateFrameworkCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFrameworkRequest, Framework> updateFrameworkCallable() {
        return this.stub.updateFrameworkCallable();
    }

    public final void deleteFramework(FrameworkName name) {
        DeleteFrameworkRequest request = DeleteFrameworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteFramework(request);
    }

    public final void deleteFramework(String name) {
        DeleteFrameworkRequest request = DeleteFrameworkRequest.newBuilder().setName(name).build();
        this.deleteFramework(request);
    }

    public final void deleteFramework(DeleteFrameworkRequest request) {
        this.deleteFrameworkCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteFrameworkRequest, Empty> deleteFrameworkCallable() {
        return this.stub.deleteFrameworkCallable();
    }

    public final ListCloudControlsPagedResponse listCloudControls(OrganizationLocationName parent) {
        ListCloudControlsRequest request = ListCloudControlsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCloudControls(request);
    }

    public final ListCloudControlsPagedResponse listCloudControls(String parent) {
        ListCloudControlsRequest request = ListCloudControlsRequest.newBuilder().setParent(parent).build();
        return this.listCloudControls(request);
    }

    public final ListCloudControlsPagedResponse listCloudControls(ListCloudControlsRequest request) {
        return (ListCloudControlsPagedResponse)((Object)this.listCloudControlsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCloudControlsRequest, ListCloudControlsPagedResponse> listCloudControlsPagedCallable() {
        return this.stub.listCloudControlsPagedCallable();
    }

    public final UnaryCallable<ListCloudControlsRequest, ListCloudControlsResponse> listCloudControlsCallable() {
        return this.stub.listCloudControlsCallable();
    }

    public final CloudControl getCloudControl(CloudControlName name) {
        GetCloudControlRequest request = GetCloudControlRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCloudControl(request);
    }

    public final CloudControl getCloudControl(String name) {
        GetCloudControlRequest request = GetCloudControlRequest.newBuilder().setName(name).build();
        return this.getCloudControl(request);
    }

    public final CloudControl getCloudControl(GetCloudControlRequest request) {
        return (CloudControl)this.getCloudControlCallable().call((Object)request);
    }

    public final UnaryCallable<GetCloudControlRequest, CloudControl> getCloudControlCallable() {
        return this.stub.getCloudControlCallable();
    }

    public final CloudControl createCloudControl(OrganizationLocationName parent, CloudControl cloudControl, String cloudControlId) {
        CreateCloudControlRequest request = CreateCloudControlRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCloudControl(cloudControl).setCloudControlId(cloudControlId).build();
        return this.createCloudControl(request);
    }

    public final CloudControl createCloudControl(String parent, CloudControl cloudControl, String cloudControlId) {
        CreateCloudControlRequest request = CreateCloudControlRequest.newBuilder().setParent(parent).setCloudControl(cloudControl).setCloudControlId(cloudControlId).build();
        return this.createCloudControl(request);
    }

    public final CloudControl createCloudControl(CreateCloudControlRequest request) {
        return (CloudControl)this.createCloudControlCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCloudControlRequest, CloudControl> createCloudControlCallable() {
        return this.stub.createCloudControlCallable();
    }

    public final CloudControl updateCloudControl(CloudControl cloudControl, FieldMask updateMask) {
        UpdateCloudControlRequest request = UpdateCloudControlRequest.newBuilder().setCloudControl(cloudControl).setUpdateMask(updateMask).build();
        return this.updateCloudControl(request);
    }

    public final CloudControl updateCloudControl(UpdateCloudControlRequest request) {
        return (CloudControl)this.updateCloudControlCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCloudControlRequest, CloudControl> updateCloudControlCallable() {
        return this.stub.updateCloudControlCallable();
    }

    public final void deleteCloudControl(CloudControlName name) {
        DeleteCloudControlRequest request = DeleteCloudControlRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteCloudControl(request);
    }

    public final void deleteCloudControl(String name) {
        DeleteCloudControlRequest request = DeleteCloudControlRequest.newBuilder().setName(name).build();
        this.deleteCloudControl(request);
    }

    public final void deleteCloudControl(DeleteCloudControlRequest request) {
        this.deleteCloudControlCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteCloudControlRequest, Empty> deleteCloudControlCallable() {
        return this.stub.deleteCloudControlCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCloudControlsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCloudControlsRequest, ListCloudControlsResponse, CloudControl, ListCloudControlsPage, ListCloudControlsFixedSizeCollection> {
        private ListCloudControlsFixedSizeCollection(List<ListCloudControlsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCloudControlsFixedSizeCollection createEmptyCollection() {
            return new ListCloudControlsFixedSizeCollection(null, 0);
        }

        protected ListCloudControlsFixedSizeCollection createCollection(List<ListCloudControlsPage> pages, int collectionSize) {
            return new ListCloudControlsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCloudControlsPage
    extends AbstractPage<ListCloudControlsRequest, ListCloudControlsResponse, CloudControl, ListCloudControlsPage> {
        private ListCloudControlsPage(PageContext<ListCloudControlsRequest, ListCloudControlsResponse, CloudControl> context, ListCloudControlsResponse response) {
            super(context, (Object)response);
        }

        private static ListCloudControlsPage createEmptyPage() {
            return new ListCloudControlsPage(null, null);
        }

        protected ListCloudControlsPage createPage(PageContext<ListCloudControlsRequest, ListCloudControlsResponse, CloudControl> context, ListCloudControlsResponse response) {
            return new ListCloudControlsPage(context, response);
        }

        public ApiFuture<ListCloudControlsPage> createPageAsync(PageContext<ListCloudControlsRequest, ListCloudControlsResponse, CloudControl> context, ApiFuture<ListCloudControlsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCloudControlsPagedResponse
    extends AbstractPagedListResponse<ListCloudControlsRequest, ListCloudControlsResponse, CloudControl, ListCloudControlsPage, ListCloudControlsFixedSizeCollection> {
        public static ApiFuture<ListCloudControlsPagedResponse> createAsync(PageContext<ListCloudControlsRequest, ListCloudControlsResponse, CloudControl> context, ApiFuture<ListCloudControlsResponse> futureResponse) {
            ApiFuture<ListCloudControlsPage> futurePage = ListCloudControlsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCloudControlsPagedResponse((ListCloudControlsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCloudControlsPagedResponse(ListCloudControlsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCloudControlsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFrameworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFrameworksRequest, ListFrameworksResponse, Framework, ListFrameworksPage, ListFrameworksFixedSizeCollection> {
        private ListFrameworksFixedSizeCollection(List<ListFrameworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFrameworksFixedSizeCollection createEmptyCollection() {
            return new ListFrameworksFixedSizeCollection(null, 0);
        }

        protected ListFrameworksFixedSizeCollection createCollection(List<ListFrameworksPage> pages, int collectionSize) {
            return new ListFrameworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFrameworksPage
    extends AbstractPage<ListFrameworksRequest, ListFrameworksResponse, Framework, ListFrameworksPage> {
        private ListFrameworksPage(PageContext<ListFrameworksRequest, ListFrameworksResponse, Framework> context, ListFrameworksResponse response) {
            super(context, (Object)response);
        }

        private static ListFrameworksPage createEmptyPage() {
            return new ListFrameworksPage(null, null);
        }

        protected ListFrameworksPage createPage(PageContext<ListFrameworksRequest, ListFrameworksResponse, Framework> context, ListFrameworksResponse response) {
            return new ListFrameworksPage(context, response);
        }

        public ApiFuture<ListFrameworksPage> createPageAsync(PageContext<ListFrameworksRequest, ListFrameworksResponse, Framework> context, ApiFuture<ListFrameworksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFrameworksPagedResponse
    extends AbstractPagedListResponse<ListFrameworksRequest, ListFrameworksResponse, Framework, ListFrameworksPage, ListFrameworksFixedSizeCollection> {
        public static ApiFuture<ListFrameworksPagedResponse> createAsync(PageContext<ListFrameworksRequest, ListFrameworksResponse, Framework> context, ApiFuture<ListFrameworksResponse> futureResponse) {
            ApiFuture<ListFrameworksPage> futurePage = ListFrameworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFrameworksPagedResponse((ListFrameworksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFrameworksPagedResponse(ListFrameworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFrameworksFixedSizeCollection.createEmptyCollection());
        }
    }
}

