/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.CloudControl;
import com.google.cloud.cloudsecuritycompliance.v1.ConfigClient;
import com.google.cloud.cloudsecuritycompliance.v1.CreateCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.CreateFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.Framework;
import com.google.cloud.cloudsecuritycompliance.v1.GetCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.GetFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworksRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworksResponse;
import com.google.cloud.cloudsecuritycompliance.v1.UpdateCloudControlRequest;
import com.google.cloud.cloudsecuritycompliance.v1.UpdateFrameworkRequest;
import com.google.cloud.cloudsecuritycompliance.v1.stub.ConfigStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.ConfigStubSettings;
import com.google.cloud.cloudsecuritycompliance.v1.stub.HttpJsonConfigCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonConfigStub
extends ConfigStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListFrameworksRequest, ListFrameworksResponse> listFrameworksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/ListFrameworks").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/frameworks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListFrameworksResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetFrameworkRequest, Framework> getFrameworkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/GetFramework").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/frameworks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "majorRevisionId", (Object)request.getMajorRevisionId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Framework.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateFrameworkRequest, Framework> createFrameworkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/CreateFramework").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/frameworks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "frameworkId", (Object)request.getFrameworkId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("framework", (Message)request.getFramework(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Framework.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateFrameworkRequest, Framework> updateFrameworkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/UpdateFramework").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{framework.name=organizations/*/locations/*/frameworks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "framework.name", (Object)request.getFramework().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "majorRevisionId", (Object)request.getMajorRevisionId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("framework", (Message)request.getFramework(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Framework.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteFrameworkRequest, Empty> deleteFrameworkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/DeleteFramework").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/frameworks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCloudControlsRequest, ListCloudControlsResponse> listCloudControlsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/ListCloudControls").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/cloudControls", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCloudControlsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetCloudControlRequest, CloudControl> getCloudControlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/GetCloudControl").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/cloudControls/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "majorRevisionId", (Object)request.getMajorRevisionId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CloudControl.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateCloudControlRequest, CloudControl> createCloudControlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/CreateCloudControl").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/cloudControls", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "cloudControlId", (Object)request.getCloudControlId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cloudControl", (Message)request.getCloudControl(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CloudControl.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCloudControlRequest, CloudControl> updateCloudControlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/UpdateCloudControl").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{cloudControl.name=organizations/*/locations/*/cloudControls/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "cloudControl.name", (Object)request.getCloudControl().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cloudControl", (Message)request.getCloudControl(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CloudControl.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteCloudControlRequest, Empty> deleteCloudControlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Config/DeleteCloudControl").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/cloudControls/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListFrameworksRequest, ListFrameworksResponse> listFrameworksCallable;
    private final UnaryCallable<ListFrameworksRequest, ConfigClient.ListFrameworksPagedResponse> listFrameworksPagedCallable;
    private final UnaryCallable<GetFrameworkRequest, Framework> getFrameworkCallable;
    private final UnaryCallable<CreateFrameworkRequest, Framework> createFrameworkCallable;
    private final UnaryCallable<UpdateFrameworkRequest, Framework> updateFrameworkCallable;
    private final UnaryCallable<DeleteFrameworkRequest, Empty> deleteFrameworkCallable;
    private final UnaryCallable<ListCloudControlsRequest, ListCloudControlsResponse> listCloudControlsCallable;
    private final UnaryCallable<ListCloudControlsRequest, ConfigClient.ListCloudControlsPagedResponse> listCloudControlsPagedCallable;
    private final UnaryCallable<GetCloudControlRequest, CloudControl> getCloudControlCallable;
    private final UnaryCallable<CreateCloudControlRequest, CloudControl> createCloudControlCallable;
    private final UnaryCallable<UpdateCloudControlRequest, CloudControl> updateCloudControlCallable;
    private final UnaryCallable<DeleteCloudControlRequest, Empty> deleteCloudControlCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ConfigClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonConfigStub create(ConfigStubSettings settings) throws IOException {
        return new HttpJsonConfigStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonConfigStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonConfigStub(ConfigStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonConfigStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonConfigStub(ConfigStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonConfigStub(ConfigStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonConfigCallableFactory());
    }

    protected HttpJsonConfigStub(ConfigStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listFrameworksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listFrameworksMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getFrameworkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFrameworkMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createFrameworkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createFrameworkMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateFrameworkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateFrameworkMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("framework.name", String.valueOf(request.getFramework().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteFrameworkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteFrameworkMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listCloudControlsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCloudControlsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getCloudControlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCloudControlMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createCloudControlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createCloudControlMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateCloudControlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCloudControlMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("cloud_control.name", String.valueOf(request.getCloudControl().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteCloudControlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteCloudControlMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listFrameworksCallable = callableFactory.createUnaryCallable(listFrameworksTransportSettings, settings.listFrameworksSettings(), clientContext);
        this.listFrameworksPagedCallable = callableFactory.createPagedCallable(listFrameworksTransportSettings, settings.listFrameworksSettings(), clientContext);
        this.getFrameworkCallable = callableFactory.createUnaryCallable(getFrameworkTransportSettings, settings.getFrameworkSettings(), clientContext);
        this.createFrameworkCallable = callableFactory.createUnaryCallable(createFrameworkTransportSettings, settings.createFrameworkSettings(), clientContext);
        this.updateFrameworkCallable = callableFactory.createUnaryCallable(updateFrameworkTransportSettings, settings.updateFrameworkSettings(), clientContext);
        this.deleteFrameworkCallable = callableFactory.createUnaryCallable(deleteFrameworkTransportSettings, settings.deleteFrameworkSettings(), clientContext);
        this.listCloudControlsCallable = callableFactory.createUnaryCallable(listCloudControlsTransportSettings, settings.listCloudControlsSettings(), clientContext);
        this.listCloudControlsPagedCallable = callableFactory.createPagedCallable(listCloudControlsTransportSettings, settings.listCloudControlsSettings(), clientContext);
        this.getCloudControlCallable = callableFactory.createUnaryCallable(getCloudControlTransportSettings, settings.getCloudControlSettings(), clientContext);
        this.createCloudControlCallable = callableFactory.createUnaryCallable(createCloudControlTransportSettings, settings.createCloudControlSettings(), clientContext);
        this.updateCloudControlCallable = callableFactory.createUnaryCallable(updateCloudControlTransportSettings, settings.updateCloudControlSettings(), clientContext);
        this.deleteCloudControlCallable = callableFactory.createUnaryCallable(deleteCloudControlTransportSettings, settings.deleteCloudControlSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listFrameworksMethodDescriptor);
        methodDescriptors.add(getFrameworkMethodDescriptor);
        methodDescriptors.add(createFrameworkMethodDescriptor);
        methodDescriptors.add(updateFrameworkMethodDescriptor);
        methodDescriptors.add(deleteFrameworkMethodDescriptor);
        methodDescriptors.add(listCloudControlsMethodDescriptor);
        methodDescriptors.add(getCloudControlMethodDescriptor);
        methodDescriptors.add(createCloudControlMethodDescriptor);
        methodDescriptors.add(updateCloudControlMethodDescriptor);
        methodDescriptors.add(deleteCloudControlMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListFrameworksRequest, ListFrameworksResponse> listFrameworksCallable() {
        return this.listFrameworksCallable;
    }

    @Override
    public UnaryCallable<ListFrameworksRequest, ConfigClient.ListFrameworksPagedResponse> listFrameworksPagedCallable() {
        return this.listFrameworksPagedCallable;
    }

    @Override
    public UnaryCallable<GetFrameworkRequest, Framework> getFrameworkCallable() {
        return this.getFrameworkCallable;
    }

    @Override
    public UnaryCallable<CreateFrameworkRequest, Framework> createFrameworkCallable() {
        return this.createFrameworkCallable;
    }

    @Override
    public UnaryCallable<UpdateFrameworkRequest, Framework> updateFrameworkCallable() {
        return this.updateFrameworkCallable;
    }

    @Override
    public UnaryCallable<DeleteFrameworkRequest, Empty> deleteFrameworkCallable() {
        return this.deleteFrameworkCallable;
    }

    @Override
    public UnaryCallable<ListCloudControlsRequest, ListCloudControlsResponse> listCloudControlsCallable() {
        return this.listCloudControlsCallable;
    }

    @Override
    public UnaryCallable<ListCloudControlsRequest, ConfigClient.ListCloudControlsPagedResponse> listCloudControlsPagedCallable() {
        return this.listCloudControlsPagedCallable;
    }

    @Override
    public UnaryCallable<GetCloudControlRequest, CloudControl> getCloudControlCallable() {
        return this.getCloudControlCallable;
    }

    @Override
    public UnaryCallable<CreateCloudControlRequest, CloudControl> createCloudControlCallable() {
        return this.createCloudControlCallable;
    }

    @Override
    public UnaryCallable<UpdateCloudControlRequest, CloudControl> updateCloudControlCallable() {
        return this.updateCloudControlCallable;
    }

    @Override
    public UnaryCallable<DeleteCloudControlRequest, Empty> deleteCloudControlCallable() {
        return this.deleteCloudControlCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ConfigClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

