/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.cloudquotas.v1.stub;

import com.google.api.cloudquotas.v1.CloudQuotasClient;
import com.google.api.cloudquotas.v1.CreateQuotaPreferenceRequest;
import com.google.api.cloudquotas.v1.GetQuotaInfoRequest;
import com.google.api.cloudquotas.v1.GetQuotaPreferenceRequest;
import com.google.api.cloudquotas.v1.ListQuotaInfosRequest;
import com.google.api.cloudquotas.v1.ListQuotaInfosResponse;
import com.google.api.cloudquotas.v1.ListQuotaPreferencesRequest;
import com.google.api.cloudquotas.v1.ListQuotaPreferencesResponse;
import com.google.api.cloudquotas.v1.QuotaInfo;
import com.google.api.cloudquotas.v1.QuotaPreference;
import com.google.api.cloudquotas.v1.UpdateQuotaPreferenceRequest;
import com.google.api.cloudquotas.v1.stub.CloudQuotasStub;
import com.google.api.cloudquotas.v1.stub.CloudQuotasStubSettings;
import com.google.api.cloudquotas.v1.stub.HttpJsonCloudQuotasCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonCloudQuotasStub
extends CloudQuotasStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListQuotaInfosRequest, ListQuotaInfosResponse> listQuotaInfosMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.cloudquotas.v1.CloudQuotas/ListQuotaInfos").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/services/*}/quotaInfos", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=organizations/*/locations/*/services/*}/quotaInfos", "/v1/{parent=folders/*/locations/*/services/*}/quotaInfos"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListQuotaInfosResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetQuotaInfoRequest, QuotaInfo> getQuotaInfoMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.cloudquotas.v1.CloudQuotas/GetQuotaInfo").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/services/*/quotaInfos/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=organizations/*/locations/*/services/*/quotaInfos/*}", "/v1/{name=folders/*/locations/*/services/*/quotaInfos/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)QuotaInfo.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse> listQuotaPreferencesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.cloudquotas.v1.CloudQuotas/ListQuotaPreferences").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/quotaPreferences", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=folders/*/locations/*}/quotaPreferences", "/v1/{parent=organizations/*/locations/*}/quotaPreferences"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListQuotaPreferencesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetQuotaPreferenceRequest, QuotaPreference> getQuotaPreferenceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.cloudquotas.v1.CloudQuotas/GetQuotaPreference").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/quotaPreferences/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=organizations/*/locations/*/quotaPreferences/*}", "/v1/{name=folders/*/locations/*/quotaPreferences/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)QuotaPreference.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateQuotaPreferenceRequest, QuotaPreference> createQuotaPreferenceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.cloudquotas.v1.CloudQuotas/CreateQuotaPreference").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/quotaPreferences", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=folders/*/locations/*}/quotaPreferences", "/v1/{parent=organizations/*/locations/*}/quotaPreferences"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "ignoreSafetyChecks", (Object)request.getIgnoreSafetyChecksList());
        serializer.putQueryParam(fields, "quotaPreferenceId", (Object)request.getQuotaPreferenceId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("quotaPreference", (Message)request.getQuotaPreference(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)QuotaPreference.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateQuotaPreferenceRequest, QuotaPreference> updateQuotaPreferenceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.cloudquotas.v1.CloudQuotas/UpdateQuotaPreference").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{quotaPreference.name=projects/*/locations/*/quotaPreferences/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "quotaPreference.name", (Object)request.getQuotaPreference().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{quotaPreference.name=folders/*/locations/*/quotaPreferences/*}", "/v1/{quotaPreference.name=organizations/*/locations/*/quotaPreferences/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "ignoreSafetyChecks", (Object)request.getIgnoreSafetyChecksList());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("quotaPreference", (Message)request.getQuotaPreference(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)QuotaPreference.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListQuotaInfosRequest, ListQuotaInfosResponse> listQuotaInfosCallable;
    private final UnaryCallable<ListQuotaInfosRequest, CloudQuotasClient.ListQuotaInfosPagedResponse> listQuotaInfosPagedCallable;
    private final UnaryCallable<GetQuotaInfoRequest, QuotaInfo> getQuotaInfoCallable;
    private final UnaryCallable<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse> listQuotaPreferencesCallable;
    private final UnaryCallable<ListQuotaPreferencesRequest, CloudQuotasClient.ListQuotaPreferencesPagedResponse> listQuotaPreferencesPagedCallable;
    private final UnaryCallable<GetQuotaPreferenceRequest, QuotaPreference> getQuotaPreferenceCallable;
    private final UnaryCallable<CreateQuotaPreferenceRequest, QuotaPreference> createQuotaPreferenceCallable;
    private final UnaryCallable<UpdateQuotaPreferenceRequest, QuotaPreference> updateQuotaPreferenceCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCloudQuotasStub create(CloudQuotasStubSettings settings) throws IOException {
        return new HttpJsonCloudQuotasStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCloudQuotasStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCloudQuotasStub(CloudQuotasStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCloudQuotasStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCloudQuotasStub(CloudQuotasStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCloudQuotasStub(CloudQuotasStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCloudQuotasCallableFactory());
    }

    protected HttpJsonCloudQuotasStub(CloudQuotasStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listQuotaInfosTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listQuotaInfosMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getQuotaInfoTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getQuotaInfoMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listQuotaPreferencesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listQuotaPreferencesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getQuotaPreferenceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getQuotaPreferenceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createQuotaPreferenceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createQuotaPreferenceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateQuotaPreferenceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateQuotaPreferenceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("quota_preference.name", String.valueOf(request.getQuotaPreference().getName()));
            return builder.build();
        }).build();
        this.listQuotaInfosCallable = callableFactory.createUnaryCallable(listQuotaInfosTransportSettings, settings.listQuotaInfosSettings(), clientContext);
        this.listQuotaInfosPagedCallable = callableFactory.createPagedCallable(listQuotaInfosTransportSettings, settings.listQuotaInfosSettings(), clientContext);
        this.getQuotaInfoCallable = callableFactory.createUnaryCallable(getQuotaInfoTransportSettings, settings.getQuotaInfoSettings(), clientContext);
        this.listQuotaPreferencesCallable = callableFactory.createUnaryCallable(listQuotaPreferencesTransportSettings, settings.listQuotaPreferencesSettings(), clientContext);
        this.listQuotaPreferencesPagedCallable = callableFactory.createPagedCallable(listQuotaPreferencesTransportSettings, settings.listQuotaPreferencesSettings(), clientContext);
        this.getQuotaPreferenceCallable = callableFactory.createUnaryCallable(getQuotaPreferenceTransportSettings, settings.getQuotaPreferenceSettings(), clientContext);
        this.createQuotaPreferenceCallable = callableFactory.createUnaryCallable(createQuotaPreferenceTransportSettings, settings.createQuotaPreferenceSettings(), clientContext);
        this.updateQuotaPreferenceCallable = callableFactory.createUnaryCallable(updateQuotaPreferenceTransportSettings, settings.updateQuotaPreferenceSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listQuotaInfosMethodDescriptor);
        methodDescriptors.add(getQuotaInfoMethodDescriptor);
        methodDescriptors.add(listQuotaPreferencesMethodDescriptor);
        methodDescriptors.add(getQuotaPreferenceMethodDescriptor);
        methodDescriptors.add(createQuotaPreferenceMethodDescriptor);
        methodDescriptors.add(updateQuotaPreferenceMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListQuotaInfosRequest, ListQuotaInfosResponse> listQuotaInfosCallable() {
        return this.listQuotaInfosCallable;
    }

    @Override
    public UnaryCallable<ListQuotaInfosRequest, CloudQuotasClient.ListQuotaInfosPagedResponse> listQuotaInfosPagedCallable() {
        return this.listQuotaInfosPagedCallable;
    }

    @Override
    public UnaryCallable<GetQuotaInfoRequest, QuotaInfo> getQuotaInfoCallable() {
        return this.getQuotaInfoCallable;
    }

    @Override
    public UnaryCallable<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse> listQuotaPreferencesCallable() {
        return this.listQuotaPreferencesCallable;
    }

    @Override
    public UnaryCallable<ListQuotaPreferencesRequest, CloudQuotasClient.ListQuotaPreferencesPagedResponse> listQuotaPreferencesPagedCallable() {
        return this.listQuotaPreferencesPagedCallable;
    }

    @Override
    public UnaryCallable<GetQuotaPreferenceRequest, QuotaPreference> getQuotaPreferenceCallable() {
        return this.getQuotaPreferenceCallable;
    }

    @Override
    public UnaryCallable<CreateQuotaPreferenceRequest, QuotaPreference> createQuotaPreferenceCallable() {
        return this.createQuotaPreferenceCallable;
    }

    @Override
    public UnaryCallable<UpdateQuotaPreferenceRequest, QuotaPreference> updateQuotaPreferenceCallable() {
        return this.updateQuotaPreferenceCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

