/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.cloudquotas.v1beta;

import com.google.api.cloudquotas.v1beta.CloudQuotasSettings;
import com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest;
import com.google.api.cloudquotas.v1beta.GetQuotaInfoRequest;
import com.google.api.cloudquotas.v1beta.GetQuotaPreferenceRequest;
import com.google.api.cloudquotas.v1beta.ListQuotaInfosRequest;
import com.google.api.cloudquotas.v1beta.ListQuotaInfosResponse;
import com.google.api.cloudquotas.v1beta.ListQuotaPreferencesRequest;
import com.google.api.cloudquotas.v1beta.ListQuotaPreferencesResponse;
import com.google.api.cloudquotas.v1beta.LocationName;
import com.google.api.cloudquotas.v1beta.QuotaInfo;
import com.google.api.cloudquotas.v1beta.QuotaInfoName;
import com.google.api.cloudquotas.v1beta.QuotaPreference;
import com.google.api.cloudquotas.v1beta.QuotaPreferenceName;
import com.google.api.cloudquotas.v1beta.ServiceName;
import com.google.api.cloudquotas.v1beta.UpdateQuotaPreferenceRequest;
import com.google.api.cloudquotas.v1beta.stub.CloudQuotasStub;
import com.google.api.cloudquotas.v1beta.stub.CloudQuotasStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CloudQuotasClient
implements BackgroundResource {
    private final CloudQuotasSettings settings;
    private final CloudQuotasStub stub;

    public static final CloudQuotasClient create() throws IOException {
        return CloudQuotasClient.create(CloudQuotasSettings.newBuilder().build());
    }

    public static final CloudQuotasClient create(CloudQuotasSettings settings) throws IOException {
        return new CloudQuotasClient(settings);
    }

    public static final CloudQuotasClient create(CloudQuotasStub stub) {
        return new CloudQuotasClient(stub);
    }

    protected CloudQuotasClient(CloudQuotasSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudQuotasStubSettings)settings.getStubSettings()).createStub();
    }

    protected CloudQuotasClient(CloudQuotasStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CloudQuotasSettings getSettings() {
        return this.settings;
    }

    public CloudQuotasStub getStub() {
        return this.stub;
    }

    public final ListQuotaInfosPagedResponse listQuotaInfos(ServiceName parent) {
        ListQuotaInfosRequest request = ListQuotaInfosRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listQuotaInfos(request);
    }

    public final ListQuotaInfosPagedResponse listQuotaInfos(String parent) {
        ListQuotaInfosRequest request = ListQuotaInfosRequest.newBuilder().setParent(parent).build();
        return this.listQuotaInfos(request);
    }

    public final ListQuotaInfosPagedResponse listQuotaInfos(ListQuotaInfosRequest request) {
        return (ListQuotaInfosPagedResponse)((Object)this.listQuotaInfosPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListQuotaInfosRequest, ListQuotaInfosPagedResponse> listQuotaInfosPagedCallable() {
        return this.stub.listQuotaInfosPagedCallable();
    }

    public final UnaryCallable<ListQuotaInfosRequest, ListQuotaInfosResponse> listQuotaInfosCallable() {
        return this.stub.listQuotaInfosCallable();
    }

    public final QuotaInfo getQuotaInfo(QuotaInfoName name) {
        GetQuotaInfoRequest request = GetQuotaInfoRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getQuotaInfo(request);
    }

    public final QuotaInfo getQuotaInfo(String name) {
        GetQuotaInfoRequest request = GetQuotaInfoRequest.newBuilder().setName(name).build();
        return this.getQuotaInfo(request);
    }

    public final QuotaInfo getQuotaInfo(GetQuotaInfoRequest request) {
        return (QuotaInfo)this.getQuotaInfoCallable().call((Object)request);
    }

    public final UnaryCallable<GetQuotaInfoRequest, QuotaInfo> getQuotaInfoCallable() {
        return this.stub.getQuotaInfoCallable();
    }

    public final ListQuotaPreferencesPagedResponse listQuotaPreferences(LocationName parent) {
        ListQuotaPreferencesRequest request = ListQuotaPreferencesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listQuotaPreferences(request);
    }

    public final ListQuotaPreferencesPagedResponse listQuotaPreferences(String parent) {
        ListQuotaPreferencesRequest request = ListQuotaPreferencesRequest.newBuilder().setParent(parent).build();
        return this.listQuotaPreferences(request);
    }

    public final ListQuotaPreferencesPagedResponse listQuotaPreferences(ListQuotaPreferencesRequest request) {
        return (ListQuotaPreferencesPagedResponse)((Object)this.listQuotaPreferencesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListQuotaPreferencesRequest, ListQuotaPreferencesPagedResponse> listQuotaPreferencesPagedCallable() {
        return this.stub.listQuotaPreferencesPagedCallable();
    }

    public final UnaryCallable<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse> listQuotaPreferencesCallable() {
        return this.stub.listQuotaPreferencesCallable();
    }

    public final QuotaPreference getQuotaPreference(QuotaPreferenceName name) {
        GetQuotaPreferenceRequest request = GetQuotaPreferenceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getQuotaPreference(request);
    }

    public final QuotaPreference getQuotaPreference(String name) {
        GetQuotaPreferenceRequest request = GetQuotaPreferenceRequest.newBuilder().setName(name).build();
        return this.getQuotaPreference(request);
    }

    public final QuotaPreference getQuotaPreference(GetQuotaPreferenceRequest request) {
        return (QuotaPreference)this.getQuotaPreferenceCallable().call((Object)request);
    }

    public final UnaryCallable<GetQuotaPreferenceRequest, QuotaPreference> getQuotaPreferenceCallable() {
        return this.stub.getQuotaPreferenceCallable();
    }

    public final QuotaPreference createQuotaPreference(LocationName parent, QuotaPreference quotaPreference) {
        CreateQuotaPreferenceRequest request = CreateQuotaPreferenceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setQuotaPreference(quotaPreference).build();
        return this.createQuotaPreference(request);
    }

    public final QuotaPreference createQuotaPreference(String parent, QuotaPreference quotaPreference) {
        CreateQuotaPreferenceRequest request = CreateQuotaPreferenceRequest.newBuilder().setParent(parent).setQuotaPreference(quotaPreference).build();
        return this.createQuotaPreference(request);
    }

    public final QuotaPreference createQuotaPreference(LocationName parent, QuotaPreference quotaPreference, String quotaPreferenceId) {
        CreateQuotaPreferenceRequest request = CreateQuotaPreferenceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setQuotaPreference(quotaPreference).setQuotaPreferenceId(quotaPreferenceId).build();
        return this.createQuotaPreference(request);
    }

    public final QuotaPreference createQuotaPreference(String parent, QuotaPreference quotaPreference, String quotaPreferenceId) {
        CreateQuotaPreferenceRequest request = CreateQuotaPreferenceRequest.newBuilder().setParent(parent).setQuotaPreference(quotaPreference).setQuotaPreferenceId(quotaPreferenceId).build();
        return this.createQuotaPreference(request);
    }

    public final QuotaPreference createQuotaPreference(CreateQuotaPreferenceRequest request) {
        return (QuotaPreference)this.createQuotaPreferenceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateQuotaPreferenceRequest, QuotaPreference> createQuotaPreferenceCallable() {
        return this.stub.createQuotaPreferenceCallable();
    }

    public final QuotaPreference updateQuotaPreference(QuotaPreference quotaPreference, FieldMask updateMask) {
        UpdateQuotaPreferenceRequest request = UpdateQuotaPreferenceRequest.newBuilder().setQuotaPreference(quotaPreference).setUpdateMask(updateMask).build();
        return this.updateQuotaPreference(request);
    }

    public final QuotaPreference updateQuotaPreference(UpdateQuotaPreferenceRequest request) {
        return (QuotaPreference)this.updateQuotaPreferenceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateQuotaPreferenceRequest, QuotaPreference> updateQuotaPreferenceCallable() {
        return this.stub.updateQuotaPreferenceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListQuotaPreferencesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, QuotaPreference, ListQuotaPreferencesPage, ListQuotaPreferencesFixedSizeCollection> {
        private ListQuotaPreferencesFixedSizeCollection(List<ListQuotaPreferencesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListQuotaPreferencesFixedSizeCollection createEmptyCollection() {
            return new ListQuotaPreferencesFixedSizeCollection(null, 0);
        }

        protected ListQuotaPreferencesFixedSizeCollection createCollection(List<ListQuotaPreferencesPage> pages, int collectionSize) {
            return new ListQuotaPreferencesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListQuotaPreferencesPage
    extends AbstractPage<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, QuotaPreference, ListQuotaPreferencesPage> {
        private ListQuotaPreferencesPage(PageContext<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, QuotaPreference> context, ListQuotaPreferencesResponse response) {
            super(context, (Object)response);
        }

        private static ListQuotaPreferencesPage createEmptyPage() {
            return new ListQuotaPreferencesPage(null, null);
        }

        protected ListQuotaPreferencesPage createPage(PageContext<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, QuotaPreference> context, ListQuotaPreferencesResponse response) {
            return new ListQuotaPreferencesPage(context, response);
        }

        public ApiFuture<ListQuotaPreferencesPage> createPageAsync(PageContext<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, QuotaPreference> context, ApiFuture<ListQuotaPreferencesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListQuotaPreferencesPagedResponse
    extends AbstractPagedListResponse<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, QuotaPreference, ListQuotaPreferencesPage, ListQuotaPreferencesFixedSizeCollection> {
        public static ApiFuture<ListQuotaPreferencesPagedResponse> createAsync(PageContext<ListQuotaPreferencesRequest, ListQuotaPreferencesResponse, QuotaPreference> context, ApiFuture<ListQuotaPreferencesResponse> futureResponse) {
            ApiFuture<ListQuotaPreferencesPage> futurePage = ListQuotaPreferencesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListQuotaPreferencesPagedResponse((ListQuotaPreferencesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListQuotaPreferencesPagedResponse(ListQuotaPreferencesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListQuotaPreferencesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListQuotaInfosFixedSizeCollection
    extends AbstractFixedSizeCollection<ListQuotaInfosRequest, ListQuotaInfosResponse, QuotaInfo, ListQuotaInfosPage, ListQuotaInfosFixedSizeCollection> {
        private ListQuotaInfosFixedSizeCollection(List<ListQuotaInfosPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListQuotaInfosFixedSizeCollection createEmptyCollection() {
            return new ListQuotaInfosFixedSizeCollection(null, 0);
        }

        protected ListQuotaInfosFixedSizeCollection createCollection(List<ListQuotaInfosPage> pages, int collectionSize) {
            return new ListQuotaInfosFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListQuotaInfosPage
    extends AbstractPage<ListQuotaInfosRequest, ListQuotaInfosResponse, QuotaInfo, ListQuotaInfosPage> {
        private ListQuotaInfosPage(PageContext<ListQuotaInfosRequest, ListQuotaInfosResponse, QuotaInfo> context, ListQuotaInfosResponse response) {
            super(context, (Object)response);
        }

        private static ListQuotaInfosPage createEmptyPage() {
            return new ListQuotaInfosPage(null, null);
        }

        protected ListQuotaInfosPage createPage(PageContext<ListQuotaInfosRequest, ListQuotaInfosResponse, QuotaInfo> context, ListQuotaInfosResponse response) {
            return new ListQuotaInfosPage(context, response);
        }

        public ApiFuture<ListQuotaInfosPage> createPageAsync(PageContext<ListQuotaInfosRequest, ListQuotaInfosResponse, QuotaInfo> context, ApiFuture<ListQuotaInfosResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListQuotaInfosPagedResponse
    extends AbstractPagedListResponse<ListQuotaInfosRequest, ListQuotaInfosResponse, QuotaInfo, ListQuotaInfosPage, ListQuotaInfosFixedSizeCollection> {
        public static ApiFuture<ListQuotaInfosPagedResponse> createAsync(PageContext<ListQuotaInfosRequest, ListQuotaInfosResponse, QuotaInfo> context, ApiFuture<ListQuotaInfosResponse> futureResponse) {
            ApiFuture<ListQuotaInfosPage> futurePage = ListQuotaInfosPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListQuotaInfosPagedResponse((ListQuotaInfosPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListQuotaInfosPagedResponse(ListQuotaInfosPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListQuotaInfosFixedSizeCollection.createEmptyCollection());
        }
    }
}

