/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudcontrolspartner.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudcontrolspartner.v1beta.CloudControlsPartnerMonitoringSettings;
import com.google.cloud.cloudcontrolspartner.v1beta.GetViolationRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.ListViolationsRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.ListViolationsResponse;
import com.google.cloud.cloudcontrolspartner.v1beta.Violation;
import com.google.cloud.cloudcontrolspartner.v1beta.ViolationName;
import com.google.cloud.cloudcontrolspartner.v1beta.WorkloadName;
import com.google.cloud.cloudcontrolspartner.v1beta.stub.CloudControlsPartnerMonitoringStub;
import com.google.cloud.cloudcontrolspartner.v1beta.stub.CloudControlsPartnerMonitoringStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CloudControlsPartnerMonitoringClient
implements BackgroundResource {
    private final CloudControlsPartnerMonitoringSettings settings;
    private final CloudControlsPartnerMonitoringStub stub;

    public static final CloudControlsPartnerMonitoringClient create() throws IOException {
        return CloudControlsPartnerMonitoringClient.create(CloudControlsPartnerMonitoringSettings.newBuilder().build());
    }

    public static final CloudControlsPartnerMonitoringClient create(CloudControlsPartnerMonitoringSettings settings) throws IOException {
        return new CloudControlsPartnerMonitoringClient(settings);
    }

    public static final CloudControlsPartnerMonitoringClient create(CloudControlsPartnerMonitoringStub stub) {
        return new CloudControlsPartnerMonitoringClient(stub);
    }

    protected CloudControlsPartnerMonitoringClient(CloudControlsPartnerMonitoringSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudControlsPartnerMonitoringStubSettings)settings.getStubSettings()).createStub();
    }

    protected CloudControlsPartnerMonitoringClient(CloudControlsPartnerMonitoringStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CloudControlsPartnerMonitoringSettings getSettings() {
        return this.settings;
    }

    public CloudControlsPartnerMonitoringStub getStub() {
        return this.stub;
    }

    public final ListViolationsPagedResponse listViolations(WorkloadName parent) {
        ListViolationsRequest request = ListViolationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listViolations(request);
    }

    public final ListViolationsPagedResponse listViolations(String parent) {
        ListViolationsRequest request = ListViolationsRequest.newBuilder().setParent(parent).build();
        return this.listViolations(request);
    }

    public final ListViolationsPagedResponse listViolations(ListViolationsRequest request) {
        return (ListViolationsPagedResponse)((Object)this.listViolationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListViolationsRequest, ListViolationsPagedResponse> listViolationsPagedCallable() {
        return this.stub.listViolationsPagedCallable();
    }

    public final UnaryCallable<ListViolationsRequest, ListViolationsResponse> listViolationsCallable() {
        return this.stub.listViolationsCallable();
    }

    public final Violation getViolation(ViolationName name) {
        GetViolationRequest request = GetViolationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getViolation(request);
    }

    public final Violation getViolation(String name) {
        GetViolationRequest request = GetViolationRequest.newBuilder().setName(name).build();
        return this.getViolation(request);
    }

    public final Violation getViolation(GetViolationRequest request) {
        return (Violation)this.getViolationCallable().call((Object)request);
    }

    public final UnaryCallable<GetViolationRequest, Violation> getViolationCallable() {
        return this.stub.getViolationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListViolationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListViolationsRequest, ListViolationsResponse, Violation, ListViolationsPage, ListViolationsFixedSizeCollection> {
        private ListViolationsFixedSizeCollection(List<ListViolationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListViolationsFixedSizeCollection createEmptyCollection() {
            return new ListViolationsFixedSizeCollection(null, 0);
        }

        protected ListViolationsFixedSizeCollection createCollection(List<ListViolationsPage> pages, int collectionSize) {
            return new ListViolationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListViolationsPage
    extends AbstractPage<ListViolationsRequest, ListViolationsResponse, Violation, ListViolationsPage> {
        private ListViolationsPage(PageContext<ListViolationsRequest, ListViolationsResponse, Violation> context, ListViolationsResponse response) {
            super(context, (Object)response);
        }

        private static ListViolationsPage createEmptyPage() {
            return new ListViolationsPage(null, null);
        }

        protected ListViolationsPage createPage(PageContext<ListViolationsRequest, ListViolationsResponse, Violation> context, ListViolationsResponse response) {
            return new ListViolationsPage(context, response);
        }

        public ApiFuture<ListViolationsPage> createPageAsync(PageContext<ListViolationsRequest, ListViolationsResponse, Violation> context, ApiFuture<ListViolationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListViolationsPagedResponse
    extends AbstractPagedListResponse<ListViolationsRequest, ListViolationsResponse, Violation, ListViolationsPage, ListViolationsFixedSizeCollection> {
        public static ApiFuture<ListViolationsPagedResponse> createAsync(PageContext<ListViolationsRequest, ListViolationsResponse, Violation> context, ApiFuture<ListViolationsResponse> futureResponse) {
            ApiFuture<ListViolationsPage> futurePage = ListViolationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListViolationsPagedResponse((ListViolationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListViolationsPagedResponse(ListViolationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListViolationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

