/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateReferenceListRequest;
import com.google.cloud.chronicle.v1.GetReferenceListRequest;
import com.google.cloud.chronicle.v1.ListReferenceListsRequest;
import com.google.cloud.chronicle.v1.ListReferenceListsResponse;
import com.google.cloud.chronicle.v1.ReferenceList;
import com.google.cloud.chronicle.v1.ReferenceListServiceClient;
import com.google.cloud.chronicle.v1.UpdateReferenceListRequest;
import com.google.cloud.chronicle.v1.stub.GrpcReferenceListServiceCallableFactory;
import com.google.cloud.chronicle.v1.stub.ReferenceListServiceStub;
import com.google.cloud.chronicle.v1.stub.ReferenceListServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcReferenceListServiceStub
extends ReferenceListServiceStub {
    private static final MethodDescriptor<GetReferenceListRequest, ReferenceList> getReferenceListMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.chronicle.v1.ReferenceListService/GetReferenceList").setRequestMarshaller(ProtoUtils.marshaller((Message)GetReferenceListRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReferenceList.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListReferenceListsRequest, ListReferenceListsResponse> listReferenceListsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.chronicle.v1.ReferenceListService/ListReferenceLists").setRequestMarshaller(ProtoUtils.marshaller((Message)ListReferenceListsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListReferenceListsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateReferenceListRequest, ReferenceList> createReferenceListMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.chronicle.v1.ReferenceListService/CreateReferenceList").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateReferenceListRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReferenceList.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateReferenceListRequest, ReferenceList> updateReferenceListMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.chronicle.v1.ReferenceListService/UpdateReferenceList").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateReferenceListRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReferenceList.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetReferenceListRequest, ReferenceList> getReferenceListCallable;
    private final UnaryCallable<ListReferenceListsRequest, ListReferenceListsResponse> listReferenceListsCallable;
    private final UnaryCallable<ListReferenceListsRequest, ReferenceListServiceClient.ListReferenceListsPagedResponse> listReferenceListsPagedCallable;
    private final UnaryCallable<CreateReferenceListRequest, ReferenceList> createReferenceListCallable;
    private final UnaryCallable<UpdateReferenceListRequest, ReferenceList> updateReferenceListCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcReferenceListServiceStub create(ReferenceListServiceStubSettings settings) throws IOException {
        return new GrpcReferenceListServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcReferenceListServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcReferenceListServiceStub(ReferenceListServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcReferenceListServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcReferenceListServiceStub(ReferenceListServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcReferenceListServiceStub(ReferenceListServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcReferenceListServiceCallableFactory());
    }

    protected GrpcReferenceListServiceStub(ReferenceListServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getReferenceListTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getReferenceListMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listReferenceListsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listReferenceListsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createReferenceListTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createReferenceListMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateReferenceListTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateReferenceListMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("reference_list.name", String.valueOf(request.getReferenceList().getName()));
            return builder.build();
        }).build();
        this.getReferenceListCallable = callableFactory.createUnaryCallable(getReferenceListTransportSettings, settings.getReferenceListSettings(), clientContext);
        this.listReferenceListsCallable = callableFactory.createUnaryCallable(listReferenceListsTransportSettings, settings.listReferenceListsSettings(), clientContext);
        this.listReferenceListsPagedCallable = callableFactory.createPagedCallable(listReferenceListsTransportSettings, settings.listReferenceListsSettings(), clientContext);
        this.createReferenceListCallable = callableFactory.createUnaryCallable(createReferenceListTransportSettings, settings.createReferenceListSettings(), clientContext);
        this.updateReferenceListCallable = callableFactory.createUnaryCallable(updateReferenceListTransportSettings, settings.updateReferenceListSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetReferenceListRequest, ReferenceList> getReferenceListCallable() {
        return this.getReferenceListCallable;
    }

    @Override
    public UnaryCallable<ListReferenceListsRequest, ListReferenceListsResponse> listReferenceListsCallable() {
        return this.listReferenceListsCallable;
    }

    @Override
    public UnaryCallable<ListReferenceListsRequest, ReferenceListServiceClient.ListReferenceListsPagedResponse> listReferenceListsPagedCallable() {
        return this.listReferenceListsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateReferenceListRequest, ReferenceList> createReferenceListCallable() {
        return this.createReferenceListCallable;
    }

    @Override
    public UnaryCallable<UpdateReferenceListRequest, ReferenceList> updateReferenceListCallable() {
        return this.updateReferenceListCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

