/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateReferenceListRequest;
import com.google.cloud.chronicle.v1.GetReferenceListRequest;
import com.google.cloud.chronicle.v1.ListReferenceListsRequest;
import com.google.cloud.chronicle.v1.ListReferenceListsResponse;
import com.google.cloud.chronicle.v1.ReferenceList;
import com.google.cloud.chronicle.v1.ReferenceListServiceClient;
import com.google.cloud.chronicle.v1.UpdateReferenceListRequest;
import com.google.cloud.chronicle.v1.stub.HttpJsonReferenceListServiceCallableFactory;
import com.google.cloud.chronicle.v1.stub.ReferenceListServiceStub;
import com.google.cloud.chronicle.v1.stub.ReferenceListServiceStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonReferenceListServiceStub
extends ReferenceListServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetReferenceListRequest, ReferenceList> getReferenceListMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.ReferenceListService/GetReferenceList").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/instances/*/referenceLists/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReferenceList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListReferenceListsRequest, ListReferenceListsResponse> listReferenceListsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.ReferenceListService/ListReferenceLists").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/instances/*}/referenceLists", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListReferenceListsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateReferenceListRequest, ReferenceList> createReferenceListMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.ReferenceListService/CreateReferenceList").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/instances/*}/referenceLists", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "referenceListId", (Object)request.getReferenceListId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("referenceList", (Message)request.getReferenceList(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReferenceList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateReferenceListRequest, ReferenceList> updateReferenceListMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.ReferenceListService/UpdateReferenceList").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{referenceList.name=projects/*/locations/*/instances/*/referenceLists/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "referenceList.name", (Object)request.getReferenceList().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("referenceList", (Message)request.getReferenceList(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReferenceList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetReferenceListRequest, ReferenceList> getReferenceListCallable;
    private final UnaryCallable<ListReferenceListsRequest, ListReferenceListsResponse> listReferenceListsCallable;
    private final UnaryCallable<ListReferenceListsRequest, ReferenceListServiceClient.ListReferenceListsPagedResponse> listReferenceListsPagedCallable;
    private final UnaryCallable<CreateReferenceListRequest, ReferenceList> createReferenceListCallable;
    private final UnaryCallable<UpdateReferenceListRequest, ReferenceList> updateReferenceListCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonReferenceListServiceStub create(ReferenceListServiceStubSettings settings) throws IOException {
        return new HttpJsonReferenceListServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonReferenceListServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonReferenceListServiceStub(ReferenceListServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonReferenceListServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonReferenceListServiceStub(ReferenceListServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonReferenceListServiceStub(ReferenceListServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonReferenceListServiceCallableFactory());
    }

    protected HttpJsonReferenceListServiceStub(ReferenceListServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getReferenceListTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getReferenceListMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listReferenceListsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listReferenceListsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createReferenceListTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createReferenceListMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateReferenceListTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateReferenceListMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("reference_list.name", String.valueOf(request.getReferenceList().getName()));
            return builder.build();
        }).build();
        this.getReferenceListCallable = callableFactory.createUnaryCallable(getReferenceListTransportSettings, settings.getReferenceListSettings(), clientContext);
        this.listReferenceListsCallable = callableFactory.createUnaryCallable(listReferenceListsTransportSettings, settings.listReferenceListsSettings(), clientContext);
        this.listReferenceListsPagedCallable = callableFactory.createPagedCallable(listReferenceListsTransportSettings, settings.listReferenceListsSettings(), clientContext);
        this.createReferenceListCallable = callableFactory.createUnaryCallable(createReferenceListTransportSettings, settings.createReferenceListSettings(), clientContext);
        this.updateReferenceListCallable = callableFactory.createUnaryCallable(updateReferenceListTransportSettings, settings.updateReferenceListSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getReferenceListMethodDescriptor);
        methodDescriptors.add(listReferenceListsMethodDescriptor);
        methodDescriptors.add(createReferenceListMethodDescriptor);
        methodDescriptors.add(updateReferenceListMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetReferenceListRequest, ReferenceList> getReferenceListCallable() {
        return this.getReferenceListCallable;
    }

    @Override
    public UnaryCallable<ListReferenceListsRequest, ListReferenceListsResponse> listReferenceListsCallable() {
        return this.listReferenceListsCallable;
    }

    @Override
    public UnaryCallable<ListReferenceListsRequest, ReferenceListServiceClient.ListReferenceListsPagedResponse> listReferenceListsPagedCallable() {
        return this.listReferenceListsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateReferenceListRequest, ReferenceList> createReferenceListCallable() {
        return this.createReferenceListCallable;
    }

    @Override
    public UnaryCallable<UpdateReferenceListRequest, ReferenceList> updateReferenceListCallable() {
        return this.updateReferenceListCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

