/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.capacityplanner.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.capacityplanner.v1beta.ExportForecastsRequest;
import com.google.cloud.capacityplanner.v1beta.ExportForecastsResponse;
import com.google.cloud.capacityplanner.v1beta.ExportReservationsUsageRequest;
import com.google.cloud.capacityplanner.v1beta.ExportReservationsUsageResponse;
import com.google.cloud.capacityplanner.v1beta.ExportUsageHistoriesRequest;
import com.google.cloud.capacityplanner.v1beta.ExportUsageHistoriesResponse;
import com.google.cloud.capacityplanner.v1beta.OperationMetadata;
import com.google.cloud.capacityplanner.v1beta.QueryForecastsRequest;
import com.google.cloud.capacityplanner.v1beta.QueryForecastsResponse;
import com.google.cloud.capacityplanner.v1beta.QueryReservationsRequest;
import com.google.cloud.capacityplanner.v1beta.QueryReservationsResponse;
import com.google.cloud.capacityplanner.v1beta.QueryUsageHistoriesRequest;
import com.google.cloud.capacityplanner.v1beta.QueryUsageHistoriesResponse;
import com.google.cloud.capacityplanner.v1beta.stub.GrpcUsageServiceCallableFactory;
import com.google.cloud.capacityplanner.v1beta.stub.UsageServiceStub;
import com.google.cloud.capacityplanner.v1beta.stub.UsageServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcUsageServiceStub
extends UsageServiceStub {
    private static final MethodDescriptor<QueryUsageHistoriesRequest, QueryUsageHistoriesResponse> queryUsageHistoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.capacityplanner.v1beta.UsageService/QueryUsageHistories").setRequestMarshaller(ProtoUtils.marshaller((Message)QueryUsageHistoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)QueryUsageHistoriesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<QueryForecastsRequest, QueryForecastsResponse> queryForecastsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.capacityplanner.v1beta.UsageService/QueryForecasts").setRequestMarshaller(ProtoUtils.marshaller((Message)QueryForecastsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)QueryForecastsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<QueryReservationsRequest, QueryReservationsResponse> queryReservationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.capacityplanner.v1beta.UsageService/QueryReservations").setRequestMarshaller(ProtoUtils.marshaller((Message)QueryReservationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)QueryReservationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ExportUsageHistoriesRequest, Operation> exportUsageHistoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.capacityplanner.v1beta.UsageService/ExportUsageHistories").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportUsageHistoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ExportForecastsRequest, Operation> exportForecastsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.capacityplanner.v1beta.UsageService/ExportForecasts").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportForecastsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ExportReservationsUsageRequest, Operation> exportReservationsUsageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.capacityplanner.v1beta.UsageService/ExportReservationsUsage").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportReservationsUsageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<QueryUsageHistoriesRequest, QueryUsageHistoriesResponse> queryUsageHistoriesCallable;
    private final UnaryCallable<QueryForecastsRequest, QueryForecastsResponse> queryForecastsCallable;
    private final UnaryCallable<QueryReservationsRequest, QueryReservationsResponse> queryReservationsCallable;
    private final UnaryCallable<ExportUsageHistoriesRequest, Operation> exportUsageHistoriesCallable;
    private final OperationCallable<ExportUsageHistoriesRequest, ExportUsageHistoriesResponse, OperationMetadata> exportUsageHistoriesOperationCallable;
    private final UnaryCallable<ExportForecastsRequest, Operation> exportForecastsCallable;
    private final OperationCallable<ExportForecastsRequest, ExportForecastsResponse, OperationMetadata> exportForecastsOperationCallable;
    private final UnaryCallable<ExportReservationsUsageRequest, Operation> exportReservationsUsageCallable;
    private final OperationCallable<ExportReservationsUsageRequest, ExportReservationsUsageResponse, OperationMetadata> exportReservationsUsageOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcUsageServiceStub create(UsageServiceStubSettings settings) throws IOException {
        return new GrpcUsageServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcUsageServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcUsageServiceStub(UsageServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcUsageServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcUsageServiceStub(UsageServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcUsageServiceStub(UsageServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcUsageServiceCallableFactory());
    }

    protected GrpcUsageServiceStub(UsageServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings queryUsageHistoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(queryUsageHistoriesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings queryForecastsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(queryForecastsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings queryReservationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(queryReservationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings exportUsageHistoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportUsageHistoriesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings exportForecastsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportForecastsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings exportReservationsUsageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportReservationsUsageMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.queryUsageHistoriesCallable = callableFactory.createUnaryCallable(queryUsageHistoriesTransportSettings, settings.queryUsageHistoriesSettings(), clientContext);
        this.queryForecastsCallable = callableFactory.createUnaryCallable(queryForecastsTransportSettings, settings.queryForecastsSettings(), clientContext);
        this.queryReservationsCallable = callableFactory.createUnaryCallable(queryReservationsTransportSettings, settings.queryReservationsSettings(), clientContext);
        this.exportUsageHistoriesCallable = callableFactory.createUnaryCallable(exportUsageHistoriesTransportSettings, settings.exportUsageHistoriesSettings(), clientContext);
        this.exportUsageHistoriesOperationCallable = callableFactory.createOperationCallable(exportUsageHistoriesTransportSettings, settings.exportUsageHistoriesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportForecastsCallable = callableFactory.createUnaryCallable(exportForecastsTransportSettings, settings.exportForecastsSettings(), clientContext);
        this.exportForecastsOperationCallable = callableFactory.createOperationCallable(exportForecastsTransportSettings, settings.exportForecastsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportReservationsUsageCallable = callableFactory.createUnaryCallable(exportReservationsUsageTransportSettings, settings.exportReservationsUsageSettings(), clientContext);
        this.exportReservationsUsageOperationCallable = callableFactory.createOperationCallable(exportReservationsUsageTransportSettings, settings.exportReservationsUsageOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<QueryUsageHistoriesRequest, QueryUsageHistoriesResponse> queryUsageHistoriesCallable() {
        return this.queryUsageHistoriesCallable;
    }

    @Override
    public UnaryCallable<QueryForecastsRequest, QueryForecastsResponse> queryForecastsCallable() {
        return this.queryForecastsCallable;
    }

    @Override
    public UnaryCallable<QueryReservationsRequest, QueryReservationsResponse> queryReservationsCallable() {
        return this.queryReservationsCallable;
    }

    @Override
    public UnaryCallable<ExportUsageHistoriesRequest, Operation> exportUsageHistoriesCallable() {
        return this.exportUsageHistoriesCallable;
    }

    @Override
    public OperationCallable<ExportUsageHistoriesRequest, ExportUsageHistoriesResponse, OperationMetadata> exportUsageHistoriesOperationCallable() {
        return this.exportUsageHistoriesOperationCallable;
    }

    @Override
    public UnaryCallable<ExportForecastsRequest, Operation> exportForecastsCallable() {
        return this.exportForecastsCallable;
    }

    @Override
    public OperationCallable<ExportForecastsRequest, ExportForecastsResponse, OperationMetadata> exportForecastsOperationCallable() {
        return this.exportForecastsOperationCallable;
    }

    @Override
    public UnaryCallable<ExportReservationsUsageRequest, Operation> exportReservationsUsageCallable() {
        return this.exportReservationsUsageCallable;
    }

    @Override
    public OperationCallable<ExportReservationsUsageRequest, ExportReservationsUsageResponse, OperationMetadata> exportReservationsUsageOperationCallable() {
        return this.exportReservationsUsageOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

