/*
 * Decompiled with CFR 0.152.
 */
package google.devtools.cloudbuild.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import google.devtools.cloudbuild.v2.BatchCreateRepositoriesRequest;
import google.devtools.cloudbuild.v2.BatchCreateRepositoriesResponse;
import google.devtools.cloudbuild.v2.Connection;
import google.devtools.cloudbuild.v2.CreateConnectionRequest;
import google.devtools.cloudbuild.v2.CreateRepositoryRequest;
import google.devtools.cloudbuild.v2.DeleteConnectionRequest;
import google.devtools.cloudbuild.v2.DeleteRepositoryRequest;
import google.devtools.cloudbuild.v2.FetchLinkableRepositoriesRequest;
import google.devtools.cloudbuild.v2.FetchLinkableRepositoriesResponse;
import google.devtools.cloudbuild.v2.FetchReadTokenRequest;
import google.devtools.cloudbuild.v2.FetchReadTokenResponse;
import google.devtools.cloudbuild.v2.FetchReadWriteTokenRequest;
import google.devtools.cloudbuild.v2.FetchReadWriteTokenResponse;
import google.devtools.cloudbuild.v2.GetConnectionRequest;
import google.devtools.cloudbuild.v2.GetRepositoryRequest;
import google.devtools.cloudbuild.v2.ListConnectionsRequest;
import google.devtools.cloudbuild.v2.ListConnectionsResponse;
import google.devtools.cloudbuild.v2.ListRepositoriesRequest;
import google.devtools.cloudbuild.v2.ListRepositoriesResponse;
import google.devtools.cloudbuild.v2.OperationMetadata;
import google.devtools.cloudbuild.v2.Repository;
import google.devtools.cloudbuild.v2.RepositoryManagerClient;
import google.devtools.cloudbuild.v2.UpdateConnectionRequest;
import google.devtools.cloudbuild.v2.stub.HttpJsonRepositoryManagerCallableFactory;
import google.devtools.cloudbuild.v2.stub.RepositoryManagerStub;
import google.devtools.cloudbuild.v2.stub.RepositoryManagerStubSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonRepositoryManagerStub
extends RepositoryManagerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Repository.getDescriptor()).add(OperationMetadata.getDescriptor()).add(Empty.getDescriptor()).add(BatchCreateRepositoriesResponse.getDescriptor()).add(Connection.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateConnectionRequest, Operation> createConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/CreateConnection").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/connections", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "connectionId", (Object)request.getConnectionId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("connection", (Message)request.getConnection(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetConnectionRequest, Connection> getConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/GetConnection").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/connections/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Connection.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListConnectionsRequest, ListConnectionsResponse> listConnectionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/ListConnections").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/connections", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListConnectionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateConnectionRequest, Operation> updateConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/UpdateConnection").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{connection.name=projects/*/locations/*/connections/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "connection.name", (Object)request.getConnection().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("connection", (Message)request.getConnection(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteConnectionRequest, Operation> deleteConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/DeleteConnection").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/connections/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CreateRepositoryRequest, Operation> createRepositoryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/CreateRepository").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*/connections/*}/repositories", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "repositoryId", (Object)request.getRepositoryId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("repository", (Message)request.getRepository(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<BatchCreateRepositoriesRequest, Operation> batchCreateRepositoriesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/BatchCreateRepositories").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*/connections/*}/repositories:batchCreate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetRepositoryRequest, Repository> getRepositoryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/GetRepository").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/connections/*/repositories/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Repository.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/ListRepositories").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*/connections/*}/repositories", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRepositoriesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteRepositoryRequest, Operation> deleteRepositoryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/DeleteRepository").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/connections/*/repositories/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/FetchReadWriteToken").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{repository=projects/*/locations/*/connections/*/repositories/*}:accessReadWriteToken", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "repository", (Object)request.getRepository());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearRepository().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchReadWriteTokenResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/FetchReadToken").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{repository=projects/*/locations/*/connections/*/repositories/*}:accessReadToken", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "repository", (Object)request.getRepository());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearRepository().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchReadTokenResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse> fetchLinkableRepositoriesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudbuild.v2.RepositoryManager/FetchLinkableRepositories").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{connection=projects/*/locations/*/connections/*}:fetchLinkableRepositories", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "connection", (Object)request.getConnection());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchLinkableRepositoriesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{resource=projects/*/locations/*/connections/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{resource=projects/*/locations/*/connections/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{resource=projects/*/locations/*/connections/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateConnectionRequest, Operation> createConnectionCallable;
    private final OperationCallable<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationCallable;
    private final UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable;
    private final UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable;
    private final UnaryCallable<ListConnectionsRequest, RepositoryManagerClient.ListConnectionsPagedResponse> listConnectionsPagedCallable;
    private final UnaryCallable<UpdateConnectionRequest, Operation> updateConnectionCallable;
    private final OperationCallable<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationCallable;
    private final UnaryCallable<DeleteConnectionRequest, Operation> deleteConnectionCallable;
    private final OperationCallable<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationCallable;
    private final UnaryCallable<CreateRepositoryRequest, Operation> createRepositoryCallable;
    private final OperationCallable<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationCallable;
    private final UnaryCallable<BatchCreateRepositoriesRequest, Operation> batchCreateRepositoriesCallable;
    private final OperationCallable<BatchCreateRepositoriesRequest, BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesOperationCallable;
    private final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable;
    private final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable;
    private final UnaryCallable<ListRepositoriesRequest, RepositoryManagerClient.ListRepositoriesPagedResponse> listRepositoriesPagedCallable;
    private final UnaryCallable<DeleteRepositoryRequest, Operation> deleteRepositoryCallable;
    private final OperationCallable<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationCallable;
    private final UnaryCallable<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenCallable;
    private final UnaryCallable<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenCallable;
    private final UnaryCallable<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse> fetchLinkableRepositoriesCallable;
    private final UnaryCallable<FetchLinkableRepositoriesRequest, RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse> fetchLinkableRepositoriesPagedCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRepositoryManagerStub create(RepositoryManagerStubSettings settings) throws IOException {
        return new HttpJsonRepositoryManagerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRepositoryManagerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRepositoryManagerStub(RepositoryManagerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonRepositoryManagerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRepositoryManagerStub(RepositoryManagerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRepositoryManagerStub(RepositoryManagerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRepositoryManagerCallableFactory());
    }

    protected HttpJsonRepositoryManagerStub(RepositoryManagerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings createConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createConnectionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getConnectionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listConnectionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listConnectionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateConnectionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteConnectionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createRepositoryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createRepositoryMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings batchCreateRepositoriesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchCreateRepositoriesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getRepositoryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRepositoryMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listRepositoriesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRepositoriesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteRepositoryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRepositoryMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings fetchReadWriteTokenTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchReadWriteTokenMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings fetchReadTokenTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchReadTokenMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings fetchLinkableRepositoriesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchLinkableRepositoriesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createConnectionCallable = callableFactory.createUnaryCallable(createConnectionTransportSettings, settings.createConnectionSettings(), clientContext);
        this.createConnectionOperationCallable = callableFactory.createOperationCallable(createConnectionTransportSettings, settings.createConnectionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getConnectionCallable = callableFactory.createUnaryCallable(getConnectionTransportSettings, settings.getConnectionSettings(), clientContext);
        this.listConnectionsCallable = callableFactory.createUnaryCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.listConnectionsPagedCallable = callableFactory.createPagedCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.updateConnectionCallable = callableFactory.createUnaryCallable(updateConnectionTransportSettings, settings.updateConnectionSettings(), clientContext);
        this.updateConnectionOperationCallable = callableFactory.createOperationCallable(updateConnectionTransportSettings, settings.updateConnectionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteConnectionCallable = callableFactory.createUnaryCallable(deleteConnectionTransportSettings, settings.deleteConnectionSettings(), clientContext);
        this.deleteConnectionOperationCallable = callableFactory.createOperationCallable(deleteConnectionTransportSettings, settings.deleteConnectionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createRepositoryCallable = callableFactory.createUnaryCallable(createRepositoryTransportSettings, settings.createRepositorySettings(), clientContext);
        this.createRepositoryOperationCallable = callableFactory.createOperationCallable(createRepositoryTransportSettings, settings.createRepositoryOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.batchCreateRepositoriesCallable = callableFactory.createUnaryCallable(batchCreateRepositoriesTransportSettings, settings.batchCreateRepositoriesSettings(), clientContext);
        this.batchCreateRepositoriesOperationCallable = callableFactory.createOperationCallable(batchCreateRepositoriesTransportSettings, settings.batchCreateRepositoriesOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getRepositoryCallable = callableFactory.createUnaryCallable(getRepositoryTransportSettings, settings.getRepositorySettings(), clientContext);
        this.listRepositoriesCallable = callableFactory.createUnaryCallable(listRepositoriesTransportSettings, settings.listRepositoriesSettings(), clientContext);
        this.listRepositoriesPagedCallable = callableFactory.createPagedCallable(listRepositoriesTransportSettings, settings.listRepositoriesSettings(), clientContext);
        this.deleteRepositoryCallable = callableFactory.createUnaryCallable(deleteRepositoryTransportSettings, settings.deleteRepositorySettings(), clientContext);
        this.deleteRepositoryOperationCallable = callableFactory.createOperationCallable(deleteRepositoryTransportSettings, settings.deleteRepositoryOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.fetchReadWriteTokenCallable = callableFactory.createUnaryCallable(fetchReadWriteTokenTransportSettings, settings.fetchReadWriteTokenSettings(), clientContext);
        this.fetchReadTokenCallable = callableFactory.createUnaryCallable(fetchReadTokenTransportSettings, settings.fetchReadTokenSettings(), clientContext);
        this.fetchLinkableRepositoriesCallable = callableFactory.createUnaryCallable(fetchLinkableRepositoriesTransportSettings, settings.fetchLinkableRepositoriesSettings(), clientContext);
        this.fetchLinkableRepositoriesPagedCallable = callableFactory.createPagedCallable(fetchLinkableRepositoriesTransportSettings, settings.fetchLinkableRepositoriesSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createConnectionMethodDescriptor);
        methodDescriptors.add(getConnectionMethodDescriptor);
        methodDescriptors.add(listConnectionsMethodDescriptor);
        methodDescriptors.add(updateConnectionMethodDescriptor);
        methodDescriptors.add(deleteConnectionMethodDescriptor);
        methodDescriptors.add(createRepositoryMethodDescriptor);
        methodDescriptors.add(batchCreateRepositoriesMethodDescriptor);
        methodDescriptors.add(getRepositoryMethodDescriptor);
        methodDescriptors.add(listRepositoriesMethodDescriptor);
        methodDescriptors.add(deleteRepositoryMethodDescriptor);
        methodDescriptors.add(fetchReadWriteTokenMethodDescriptor);
        methodDescriptors.add(fetchReadTokenMethodDescriptor);
        methodDescriptors.add(fetchLinkableRepositoriesMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateConnectionRequest, Operation> createConnectionCallable() {
        return this.createConnectionCallable;
    }

    @Override
    public OperationCallable<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationCallable() {
        return this.createConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable() {
        return this.getConnectionCallable;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable() {
        return this.listConnectionsCallable;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, RepositoryManagerClient.ListConnectionsPagedResponse> listConnectionsPagedCallable() {
        return this.listConnectionsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateConnectionRequest, Operation> updateConnectionCallable() {
        return this.updateConnectionCallable;
    }

    @Override
    public OperationCallable<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationCallable() {
        return this.updateConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteConnectionRequest, Operation> deleteConnectionCallable() {
        return this.deleteConnectionCallable;
    }

    @Override
    public OperationCallable<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationCallable() {
        return this.deleteConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<CreateRepositoryRequest, Operation> createRepositoryCallable() {
        return this.createRepositoryCallable;
    }

    @Override
    public OperationCallable<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationCallable() {
        return this.createRepositoryOperationCallable;
    }

    @Override
    public UnaryCallable<BatchCreateRepositoriesRequest, Operation> batchCreateRepositoriesCallable() {
        return this.batchCreateRepositoriesCallable;
    }

    @Override
    public OperationCallable<BatchCreateRepositoriesRequest, BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesOperationCallable() {
        return this.batchCreateRepositoriesOperationCallable;
    }

    @Override
    public UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.getRepositoryCallable;
    }

    @Override
    public UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.listRepositoriesCallable;
    }

    @Override
    public UnaryCallable<ListRepositoriesRequest, RepositoryManagerClient.ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.listRepositoriesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteRepositoryRequest, Operation> deleteRepositoryCallable() {
        return this.deleteRepositoryCallable;
    }

    @Override
    public OperationCallable<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationCallable() {
        return this.deleteRepositoryOperationCallable;
    }

    @Override
    public UnaryCallable<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenCallable() {
        return this.fetchReadWriteTokenCallable;
    }

    @Override
    public UnaryCallable<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenCallable() {
        return this.fetchReadTokenCallable;
    }

    @Override
    public UnaryCallable<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse> fetchLinkableRepositoriesCallable() {
        return this.fetchLinkableRepositoriesCallable;
    }

    @Override
    public UnaryCallable<FetchLinkableRepositoriesRequest, RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse> fetchLinkableRepositoriesPagedCallable() {
        return this.fetchLinkableRepositoriesPagedCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

