/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devtools.cloudbuild.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devtools.cloudbuild.v1.CloudBuildSettings;
import com.google.cloud.devtools.cloudbuild.v1.stub.CloudBuildStub;
import com.google.cloud.devtools.cloudbuild.v1.stub.CloudBuildStubSettings;
import com.google.cloudbuild.v1.Build;
import com.google.cloudbuild.v1.BuildTrigger;
import com.google.cloudbuild.v1.CancelBuildRequest;
import com.google.cloudbuild.v1.CreateBuildRequest;
import com.google.cloudbuild.v1.CreateBuildTriggerRequest;
import com.google.cloudbuild.v1.CreateWorkerPoolRequest;
import com.google.cloudbuild.v1.DeleteBuildTriggerRequest;
import com.google.cloudbuild.v1.DeleteWorkerPoolRequest;
import com.google.cloudbuild.v1.GetBuildRequest;
import com.google.cloudbuild.v1.GetBuildTriggerRequest;
import com.google.cloudbuild.v1.GetWorkerPoolRequest;
import com.google.cloudbuild.v1.ListBuildTriggersRequest;
import com.google.cloudbuild.v1.ListBuildTriggersResponse;
import com.google.cloudbuild.v1.ListBuildsRequest;
import com.google.cloudbuild.v1.ListBuildsResponse;
import com.google.cloudbuild.v1.ListWorkerPoolsRequest;
import com.google.cloudbuild.v1.ListWorkerPoolsResponse;
import com.google.cloudbuild.v1.RepoSource;
import com.google.cloudbuild.v1.RetryBuildRequest;
import com.google.cloudbuild.v1.RunBuildTriggerRequest;
import com.google.cloudbuild.v1.UpdateBuildTriggerRequest;
import com.google.cloudbuild.v1.UpdateWorkerPoolRequest;
import com.google.cloudbuild.v1.WorkerPool;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CloudBuildClient
implements BackgroundResource {
    private final CloudBuildSettings settings;
    private final CloudBuildStub stub;

    public static final CloudBuildClient create() throws IOException {
        return CloudBuildClient.create(CloudBuildSettings.newBuilder().build());
    }

    public static final CloudBuildClient create(CloudBuildSettings settings) throws IOException {
        return new CloudBuildClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CloudBuildClient create(CloudBuildStub stub) {
        return new CloudBuildClient(stub);
    }

    protected CloudBuildClient(CloudBuildSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudBuildStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CloudBuildClient(CloudBuildStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CloudBuildSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudBuildStub getStub() {
        return this.stub;
    }

    public final Operation createBuild(String projectId, Build build) {
        CreateBuildRequest request = CreateBuildRequest.newBuilder().setProjectId(projectId).setBuild(build).build();
        return this.createBuild(request);
    }

    public final Operation createBuild(CreateBuildRequest request) {
        return (Operation)this.createBuildCallable().call((Object)request);
    }

    public final UnaryCallable<CreateBuildRequest, Operation> createBuildCallable() {
        return this.stub.createBuildCallable();
    }

    public final Build getBuild(String projectId, String id) {
        GetBuildRequest request = GetBuildRequest.newBuilder().setProjectId(projectId).setId(id).build();
        return this.getBuild(request);
    }

    public final Build getBuild(GetBuildRequest request) {
        return (Build)this.getBuildCallable().call((Object)request);
    }

    public final UnaryCallable<GetBuildRequest, Build> getBuildCallable() {
        return this.stub.getBuildCallable();
    }

    public final ListBuildsPagedResponse listBuilds(String projectId, String filter) {
        ListBuildsRequest request = ListBuildsRequest.newBuilder().setProjectId(projectId).setFilter(filter).build();
        return this.listBuilds(request);
    }

    public final ListBuildsPagedResponse listBuilds(ListBuildsRequest request) {
        return (ListBuildsPagedResponse)((Object)this.listBuildsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBuildsRequest, ListBuildsPagedResponse> listBuildsPagedCallable() {
        return this.stub.listBuildsPagedCallable();
    }

    public final UnaryCallable<ListBuildsRequest, ListBuildsResponse> listBuildsCallable() {
        return this.stub.listBuildsCallable();
    }

    public final Build cancelBuild(String projectId, String id) {
        CancelBuildRequest request = CancelBuildRequest.newBuilder().setProjectId(projectId).setId(id).build();
        return this.cancelBuild(request);
    }

    public final Build cancelBuild(CancelBuildRequest request) {
        return (Build)this.cancelBuildCallable().call((Object)request);
    }

    public final UnaryCallable<CancelBuildRequest, Build> cancelBuildCallable() {
        return this.stub.cancelBuildCallable();
    }

    public final BuildTrigger createBuildTrigger(String projectId, BuildTrigger trigger) {
        CreateBuildTriggerRequest request = CreateBuildTriggerRequest.newBuilder().setProjectId(projectId).setTrigger(trigger).build();
        return this.createBuildTrigger(request);
    }

    public final BuildTrigger createBuildTrigger(CreateBuildTriggerRequest request) {
        return (BuildTrigger)this.createBuildTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerCallable() {
        return this.stub.createBuildTriggerCallable();
    }

    public final BuildTrigger getBuildTrigger(String projectId, String triggerId) {
        GetBuildTriggerRequest request = GetBuildTriggerRequest.newBuilder().setProjectId(projectId).setTriggerId(triggerId).build();
        return this.getBuildTrigger(request);
    }

    public final BuildTrigger getBuildTrigger(GetBuildTriggerRequest request) {
        return (BuildTrigger)this.getBuildTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerCallable() {
        return this.stub.getBuildTriggerCallable();
    }

    public final ListBuildTriggersResponse listBuildTriggers(String projectId) {
        ListBuildTriggersRequest request = ListBuildTriggersRequest.newBuilder().setProjectId(projectId).build();
        return this.listBuildTriggers(request);
    }

    public final ListBuildTriggersResponse listBuildTriggers(ListBuildTriggersRequest request) {
        return (ListBuildTriggersResponse)this.listBuildTriggersCallable().call((Object)request);
    }

    public final UnaryCallable<ListBuildTriggersRequest, ListBuildTriggersResponse> listBuildTriggersCallable() {
        return this.stub.listBuildTriggersCallable();
    }

    public final void deleteBuildTrigger(String projectId, String triggerId) {
        DeleteBuildTriggerRequest request = DeleteBuildTriggerRequest.newBuilder().setProjectId(projectId).setTriggerId(triggerId).build();
        this.deleteBuildTrigger(request);
    }

    public final void deleteBuildTrigger(DeleteBuildTriggerRequest request) {
        this.deleteBuildTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerCallable() {
        return this.stub.deleteBuildTriggerCallable();
    }

    public final BuildTrigger updateBuildTrigger(String projectId, String triggerId, BuildTrigger trigger) {
        UpdateBuildTriggerRequest request = UpdateBuildTriggerRequest.newBuilder().setProjectId(projectId).setTriggerId(triggerId).setTrigger(trigger).build();
        return this.updateBuildTrigger(request);
    }

    public final BuildTrigger updateBuildTrigger(UpdateBuildTriggerRequest request) {
        return (BuildTrigger)this.updateBuildTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerCallable() {
        return this.stub.updateBuildTriggerCallable();
    }

    public final Operation runBuildTrigger(String projectId, String triggerId, RepoSource source) {
        RunBuildTriggerRequest request = RunBuildTriggerRequest.newBuilder().setProjectId(projectId).setTriggerId(triggerId).setSource(source).build();
        return this.runBuildTrigger(request);
    }

    public final Operation runBuildTrigger(RunBuildTriggerRequest request) {
        return (Operation)this.runBuildTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<RunBuildTriggerRequest, Operation> runBuildTriggerCallable() {
        return this.stub.runBuildTriggerCallable();
    }

    public final Operation retryBuild(String projectId, String id) {
        RetryBuildRequest request = RetryBuildRequest.newBuilder().setProjectId(projectId).setId(id).build();
        return this.retryBuild(request);
    }

    public final Operation retryBuild(RetryBuildRequest request) {
        return (Operation)this.retryBuildCallable().call((Object)request);
    }

    public final UnaryCallable<RetryBuildRequest, Operation> retryBuildCallable() {
        return this.stub.retryBuildCallable();
    }

    public final WorkerPool createWorkerPool(CreateWorkerPoolRequest request) {
        return (WorkerPool)this.createWorkerPoolCallable().call((Object)request);
    }

    public final UnaryCallable<CreateWorkerPoolRequest, WorkerPool> createWorkerPoolCallable() {
        return this.stub.createWorkerPoolCallable();
    }

    public final WorkerPool getWorkerPool(GetWorkerPoolRequest request) {
        return (WorkerPool)this.getWorkerPoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkerPoolRequest, WorkerPool> getWorkerPoolCallable() {
        return this.stub.getWorkerPoolCallable();
    }

    public final void deleteWorkerPool(DeleteWorkerPoolRequest request) {
        this.deleteWorkerPoolCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteWorkerPoolRequest, Empty> deleteWorkerPoolCallable() {
        return this.stub.deleteWorkerPoolCallable();
    }

    public final WorkerPool updateWorkerPool(UpdateWorkerPoolRequest request) {
        return (WorkerPool)this.updateWorkerPoolCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateWorkerPoolRequest, WorkerPool> updateWorkerPoolCallable() {
        return this.stub.updateWorkerPoolCallable();
    }

    public final ListWorkerPoolsResponse listWorkerPools(ListWorkerPoolsRequest request) {
        return (ListWorkerPoolsResponse)this.listWorkerPoolsCallable().call((Object)request);
    }

    public final UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsCallable() {
        return this.stub.listWorkerPoolsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBuildsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBuildsRequest, ListBuildsResponse, Build, ListBuildsPage, ListBuildsFixedSizeCollection> {
        private ListBuildsFixedSizeCollection(List<ListBuildsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBuildsFixedSizeCollection createEmptyCollection() {
            return new ListBuildsFixedSizeCollection(null, 0);
        }

        protected ListBuildsFixedSizeCollection createCollection(List<ListBuildsPage> pages, int collectionSize) {
            return new ListBuildsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBuildsPage
    extends AbstractPage<ListBuildsRequest, ListBuildsResponse, Build, ListBuildsPage> {
        private ListBuildsPage(PageContext<ListBuildsRequest, ListBuildsResponse, Build> context, ListBuildsResponse response) {
            super(context, (Object)response);
        }

        private static ListBuildsPage createEmptyPage() {
            return new ListBuildsPage(null, null);
        }

        protected ListBuildsPage createPage(PageContext<ListBuildsRequest, ListBuildsResponse, Build> context, ListBuildsResponse response) {
            return new ListBuildsPage(context, response);
        }

        public ApiFuture<ListBuildsPage> createPageAsync(PageContext<ListBuildsRequest, ListBuildsResponse, Build> context, ApiFuture<ListBuildsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBuildsPagedResponse
    extends AbstractPagedListResponse<ListBuildsRequest, ListBuildsResponse, Build, ListBuildsPage, ListBuildsFixedSizeCollection> {
        public static ApiFuture<ListBuildsPagedResponse> createAsync(PageContext<ListBuildsRequest, ListBuildsResponse, Build> context, ApiFuture<ListBuildsResponse> futureResponse) {
            ApiFuture<ListBuildsPage> futurePage = ListBuildsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListBuildsPage, ListBuildsPagedResponse>(){

                public ListBuildsPagedResponse apply(ListBuildsPage input) {
                    return new ListBuildsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListBuildsPagedResponse(ListBuildsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBuildsFixedSizeCollection.createEmptyCollection());
        }
    }
}

