/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.billing.v1.CloudCatalogClient;
import com.google.cloud.billing.v1.ListServicesRequest;
import com.google.cloud.billing.v1.ListServicesResponse;
import com.google.cloud.billing.v1.ListSkusRequest;
import com.google.cloud.billing.v1.ListSkusResponse;
import com.google.cloud.billing.v1.stub.CloudCatalogStub;
import com.google.cloud.billing.v1.stub.CloudCatalogStubSettings;
import com.google.cloud.billing.v1.stub.HttpJsonCloudCatalogCallableFactory;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCloudCatalogStub
extends CloudCatalogStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListServicesRequest, ListServicesResponse> listServicesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudCatalog/ListServices").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListServicesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSkusRequest, ListSkusResponse> listSkusMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.v1.CloudCatalog/ListSkus").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=services/*}/skus", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "currencyCode", (Object)request.getCurrencyCode());
        serializer.putQueryParam(fields, "endTime", (Object)request.getEndTime());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "startTime", (Object)request.getStartTime());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSkusResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable;
    private final UnaryCallable<ListServicesRequest, CloudCatalogClient.ListServicesPagedResponse> listServicesPagedCallable;
    private final UnaryCallable<ListSkusRequest, ListSkusResponse> listSkusCallable;
    private final UnaryCallable<ListSkusRequest, CloudCatalogClient.ListSkusPagedResponse> listSkusPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCloudCatalogStub create(CloudCatalogStubSettings settings) throws IOException {
        return new HttpJsonCloudCatalogStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCloudCatalogStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCloudCatalogStub(CloudCatalogStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCloudCatalogStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCloudCatalogStub(CloudCatalogStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCloudCatalogStub(CloudCatalogStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCloudCatalogCallableFactory());
    }

    protected HttpJsonCloudCatalogStub(CloudCatalogStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listServicesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listServicesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listSkusTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSkusMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listServicesCallable = callableFactory.createUnaryCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listServicesPagedCallable = callableFactory.createPagedCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listSkusCallable = callableFactory.createUnaryCallable(listSkusTransportSettings, settings.listSkusSettings(), clientContext);
        this.listSkusPagedCallable = callableFactory.createPagedCallable(listSkusTransportSettings, settings.listSkusSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listServicesMethodDescriptor);
        methodDescriptors.add(listSkusMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.listServicesCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, CloudCatalogClient.ListServicesPagedResponse> listServicesPagedCallable() {
        return this.listServicesPagedCallable;
    }

    @Override
    public UnaryCallable<ListSkusRequest, ListSkusResponse> listSkusCallable() {
        return this.listSkusCallable;
    }

    @Override
    public UnaryCallable<ListSkusRequest, CloudCatalogClient.ListSkusPagedResponse> listSkusPagedCallable() {
        return this.listSkusPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

