/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.StreamResumptionStrategy;

@InternalApi
/** Expand StreamResumptionStrategy to also process the error. */
public abstract class BigtableStreamResumptionStrategy<RequestT, ResponseT>
    implements StreamResumptionStrategy<RequestT, ResponseT> {

  public abstract Throwable processError(Throwable throwable);
}
