/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import javax.annotation.Nonnull;

public final class CreateTableRequest {
    private final CreateTableRequest.Builder createTableRequest = com.google.bigtable.admin.v2.CreateTableRequest.newBuilder();
    private final Table.Builder tableRequest = Table.newBuilder();

    public static CreateTableRequest of(String tableId) {
        return new CreateTableRequest(tableId);
    }

    private CreateTableRequest(String tableId) {
        this.createTableRequest.setTableId(tableId);
    }

    public CreateTableRequest addFamily(String familyId) {
        Preconditions.checkNotNull((Object)familyId);
        this.tableRequest.putColumnFamilies(familyId, ColumnFamily.getDefaultInstance());
        return this;
    }

    public CreateTableRequest addFamily(String familyId, GCRules.GCRule gcRule) {
        Preconditions.checkNotNull((Object)familyId);
        this.tableRequest.putColumnFamilies(familyId, ColumnFamily.newBuilder().setGcRule(gcRule.toProto()).build());
        return this;
    }

    public CreateTableRequest addSplit(ByteString key) {
        Preconditions.checkNotNull((Object)key);
        this.createTableRequest.addInitialSplitsBuilder().setKey(key);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTableRequest that = (CreateTableRequest)o;
        return Objects.equal((Object)this.createTableRequest, (Object)that.createTableRequest) && Objects.equal((Object)this.tableRequest, (Object)that.tableRequest);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.createTableRequest, this.tableRequest});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.CreateTableRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)instanceId);
        return this.createTableRequest.setParent(NameUtil.formatInstanceName(projectId, instanceId)).setTable(this.tableRequest.build()).build();
    }
}

