/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsRequest;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1.FlushRowsRequest;
import com.google.cloud.bigquery.storage.v1.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1.GetWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.TableName;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.bigquery.storage.v1.WriteStreamName;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryWriteStub;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryWriteStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class BigQueryWriteClient
implements BackgroundResource {
    private final BigQueryWriteSettings settings;
    private final BigQueryWriteStub stub;

    public static final BigQueryWriteClient create() throws IOException {
        return BigQueryWriteClient.create(BigQueryWriteSettings.newBuilder().build());
    }

    public static final BigQueryWriteClient create(BigQueryWriteSettings settings) throws IOException {
        return new BigQueryWriteClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BigQueryWriteClient create(BigQueryWriteStub stub) {
        return new BigQueryWriteClient(stub);
    }

    protected BigQueryWriteClient(BigQueryWriteSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BigQueryWriteStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BigQueryWriteClient(BigQueryWriteStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BigQueryWriteSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BigQueryWriteStub getStub() {
        return this.stub;
    }

    public final WriteStream createWriteStream(TableName parent, WriteStream writeStream) {
        CreateWriteStreamRequest request = CreateWriteStreamRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWriteStream(writeStream).build();
        return this.createWriteStream(request);
    }

    public final WriteStream createWriteStream(String parent, WriteStream writeStream) {
        CreateWriteStreamRequest request = CreateWriteStreamRequest.newBuilder().setParent(parent).setWriteStream(writeStream).build();
        return this.createWriteStream(request);
    }

    public final WriteStream createWriteStream(CreateWriteStreamRequest request) {
        return (WriteStream)this.createWriteStreamCallable().call((Object)request);
    }

    public final UnaryCallable<CreateWriteStreamRequest, WriteStream> createWriteStreamCallable() {
        return this.stub.createWriteStreamCallable();
    }

    public final BidiStreamingCallable<AppendRowsRequest, AppendRowsResponse> appendRowsCallable() {
        return this.stub.appendRowsCallable();
    }

    public final WriteStream getWriteStream(WriteStreamName name) {
        GetWriteStreamRequest request = GetWriteStreamRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWriteStream(request);
    }

    public final WriteStream getWriteStream(String name) {
        GetWriteStreamRequest request = GetWriteStreamRequest.newBuilder().setName(name).build();
        return this.getWriteStream(request);
    }

    public final WriteStream getWriteStream(GetWriteStreamRequest request) {
        return (WriteStream)this.getWriteStreamCallable().call((Object)request);
    }

    public final UnaryCallable<GetWriteStreamRequest, WriteStream> getWriteStreamCallable() {
        return this.stub.getWriteStreamCallable();
    }

    public final FinalizeWriteStreamResponse finalizeWriteStream(WriteStreamName name) {
        FinalizeWriteStreamRequest request = FinalizeWriteStreamRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.finalizeWriteStream(request);
    }

    public final FinalizeWriteStreamResponse finalizeWriteStream(String name) {
        FinalizeWriteStreamRequest request = FinalizeWriteStreamRequest.newBuilder().setName(name).build();
        return this.finalizeWriteStream(request);
    }

    public final FinalizeWriteStreamResponse finalizeWriteStream(FinalizeWriteStreamRequest request) {
        return (FinalizeWriteStreamResponse)this.finalizeWriteStreamCallable().call((Object)request);
    }

    public final UnaryCallable<FinalizeWriteStreamRequest, FinalizeWriteStreamResponse> finalizeWriteStreamCallable() {
        return this.stub.finalizeWriteStreamCallable();
    }

    public final BatchCommitWriteStreamsResponse batchCommitWriteStreams(TableName parent) {
        BatchCommitWriteStreamsRequest request = BatchCommitWriteStreamsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.batchCommitWriteStreams(request);
    }

    public final BatchCommitWriteStreamsResponse batchCommitWriteStreams(String parent) {
        BatchCommitWriteStreamsRequest request = BatchCommitWriteStreamsRequest.newBuilder().setParent(parent).build();
        return this.batchCommitWriteStreams(request);
    }

    public final BatchCommitWriteStreamsResponse batchCommitWriteStreams(BatchCommitWriteStreamsRequest request) {
        return (BatchCommitWriteStreamsResponse)this.batchCommitWriteStreamsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCommitWriteStreamsRequest, BatchCommitWriteStreamsResponse> batchCommitWriteStreamsCallable() {
        return this.stub.batchCommitWriteStreamsCallable();
    }

    public final FlushRowsResponse flushRows(WriteStreamName writeStream) {
        FlushRowsRequest request = FlushRowsRequest.newBuilder().setWriteStream(writeStream == null ? null : writeStream.toString()).build();
        return this.flushRows(request);
    }

    public final FlushRowsResponse flushRows(String writeStream) {
        FlushRowsRequest request = FlushRowsRequest.newBuilder().setWriteStream(writeStream).build();
        return this.flushRows(request);
    }

    public final FlushRowsResponse flushRows(FlushRowsRequest request) {
        return (FlushRowsResponse)this.flushRowsCallable().call((Object)request);
    }

    public final UnaryCallable<FlushRowsRequest, FlushRowsResponse> flushRowsCallable() {
        return this.stub.flushRowsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

