/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.cloud.bigquery.storage.v1.StorageError;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Status;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import javax.annotation.Nullable;

public final class Exceptions {
    private static StorageError toStorageError(Status rpcStatus) {
        for (Any detail : rpcStatus.getDetailsList()) {
            if (!detail.is(StorageError.class)) continue;
            try {
                return (StorageError)detail.unpack(StorageError.class);
            }
            catch (InvalidProtocolBufferException protoException) {
                throw new IllegalStateException(protoException);
            }
        }
        return null;
    }

    @Nullable
    public static StorageException toStorageException(Status rpcStatus, Throwable exception) {
        StorageError error = Exceptions.toStorageError(rpcStatus);
        io.grpc.Status grpcStatus = io.grpc.Status.fromCodeValue((int)rpcStatus.getCode()).withDescription(rpcStatus.getMessage());
        if (error == null) {
            return null;
        }
        switch (error.getCode()) {
            case STREAM_FINALIZED: {
                return new StreamFinalizedException(grpcStatus, null, error.getEntity());
            }
            case SCHEMA_MISMATCH_EXTRA_FIELDS: {
                return new SchemaMismatchedException(grpcStatus, null, error.getEntity());
            }
        }
        return null;
    }

    @Nullable
    public static StorageException toStorageException(Throwable exception) {
        Status rpcStatus = StatusProto.fromThrowable((Throwable)exception);
        return Exceptions.toStorageException(rpcStatus, exception);
    }

    private Exceptions() {
    }

    public static final class SchemaMismatchedException
    extends StorageException {
        protected SchemaMismatchedException(io.grpc.Status grpcStatus, Metadata metadata, String name) {
            super(grpcStatus, metadata, name, ImmutableMap.of());
        }
    }

    public static final class StreamFinalizedException
    extends StorageException {
        protected StreamFinalizedException(io.grpc.Status grpcStatus, Metadata metadata, String name) {
            super(grpcStatus, metadata, name, ImmutableMap.of());
        }
    }

    public static class StorageException
    extends StatusRuntimeException {
        private final ImmutableMap<String, GrpcStatusCode> errors;
        private final String streamName;

        private StorageException() {
            this(null, null, null, (ImmutableMap<String, GrpcStatusCode>)ImmutableMap.of());
        }

        private StorageException(@Nullable io.grpc.Status grpcStatus, @Nullable Metadata metadata, @Nullable String streamName, ImmutableMap<String, GrpcStatusCode> errors) {
            super(grpcStatus, metadata);
            this.streamName = streamName;
            this.errors = errors;
        }

        public ImmutableMap<String, GrpcStatusCode> getErrors() {
            return this.errors;
        }

        public String getStreamName() {
            return this.streamName;
        }
    }

    public static class WriterClosedException
    extends Exception {
        public WriterClosedException(String streamName) {
            super("Writer closed on: " + streamName);
        }
    }
}

