/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1.stub.readrows;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.ServerStreamingAttemptException;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.stub.readrows.ReadRowsAttemptCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class ReadRowsRetryingCallable
extends ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> {
    private final ApiCallContext context;
    private final ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> innerCallable;
    private final ScheduledRetryingExecutor<Void> executor;
    private final StreamResumptionStrategy<Storage.ReadRowsRequest, Storage.ReadRowsResponse> resumptionStrategyPrototype;

    public ReadRowsRetryingCallable(ApiCallContext context, ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> innerCallable, ScheduledRetryingExecutor<Void> executor, StreamResumptionStrategy<Storage.ReadRowsRequest, Storage.ReadRowsResponse> resumptionStrategyPrototype) {
        this.context = context;
        this.innerCallable = innerCallable;
        this.executor = executor;
        this.resumptionStrategyPrototype = resumptionStrategyPrototype;
    }

    public void call(Storage.ReadRowsRequest request, final ResponseObserver<Storage.ReadRowsResponse> responseObserver, ApiCallContext context) {
        ReadRowsAttemptCallable attemptCallable = new ReadRowsAttemptCallable(this.innerCallable, (StreamResumptionStrategy<Storage.ReadRowsRequest, Storage.ReadRowsResponse>)this.resumptionStrategyPrototype.createNew(), request, this.context, responseObserver);
        RetryingFuture retryingFuture = this.executor.createFuture((Callable)attemptCallable, (RetryingContext)this.context);
        attemptCallable.setExternalFuture((RetryingFuture<Void>)retryingFuture);
        attemptCallable.start();
        ApiFutures.addCallback((ApiFuture)retryingFuture, (ApiFutureCallback)new ApiFutureCallback<Void>(){

            public void onFailure(Throwable throwable) {
                if (throwable instanceof ServerStreamingAttemptException) {
                    throwable = throwable.getCause();
                }
                responseObserver.onError(throwable);
            }

            public void onSuccess(Void ignored) {
                responseObserver.onComplete();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

