/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1beta2.StreamConnection;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public class StreamWriterV2
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(StreamWriterV2.class.getName());
    private Lock lock = new ReentrantLock();
    private Condition hasMessageInWaitingQueue = this.lock.newCondition();
    private Condition inflightReduced = this.lock.newCondition();
    private final String streamName;
    private final long maxInflightRequests;
    private final long maxInflightBytes;
    @GuardedBy(value="lock")
    private long inflightRequests = 0L;
    @GuardedBy(value="lock")
    private long inflightBytes = 0L;
    @GuardedBy(value="lock")
    private boolean userClosed = false;
    @GuardedBy(value="lock")
    private Throwable connectionFinalStatus = null;
    @GuardedBy(value="lock")
    private final Deque<AppendRequestAndResponse> waitingRequestQueue;
    @GuardedBy(value="lock")
    private final Deque<AppendRequestAndResponse> inflightRequestQueue;
    private BigQueryWriteClient client;
    private boolean ownsBigQueryWriteClient = false;
    private StreamConnection streamConnection;
    private Thread appendThread;

    public static long getApiMaxRequestBytes() {
        return 8000000L;
    }

    private StreamWriterV2(Builder builder) throws IOException {
        this.streamName = builder.streamName;
        this.maxInflightRequests = builder.maxInflightRequest;
        this.maxInflightBytes = builder.maxInflightBytes;
        this.waitingRequestQueue = new LinkedList<AppendRequestAndResponse>();
        this.inflightRequestQueue = new LinkedList<AppendRequestAndResponse>();
        if (builder.client == null) {
            BigQueryWriteSettings stubSettings = ((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider(builder.credentialsProvider)).setTransportChannelProvider(builder.channelProvider)).setEndpoint(builder.endpoint)).build();
            this.client = BigQueryWriteClient.create(stubSettings);
            this.ownsBigQueryWriteClient = true;
        } else {
            this.client = builder.client;
            this.ownsBigQueryWriteClient = false;
        }
        this.streamConnection = new StreamConnection(this.client, new StreamConnection.RequestCallback(){

            @Override
            public void run(AppendRowsResponse response) {
                StreamWriterV2.this.requestCallback(response);
            }
        }, new StreamConnection.DoneCallback(){

            @Override
            public void run(Throwable finalStatus) {
                StreamWriterV2.this.doneCallback(finalStatus);
            }
        });
        this.appendThread = new Thread(new Runnable(){

            @Override
            public void run() {
                StreamWriterV2.this.appendLoop();
            }
        });
        this.appendThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<AppendRowsResponse> append(AppendRowsRequest message) {
        AppendRequestAndResponse requestWrapper = new AppendRequestAndResponse(message);
        if (requestWrapper.messageSize > StreamWriterV2.getApiMaxRequestBytes()) {
            requestWrapper.appendResult.setException((Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INVALID_ARGUMENT).withDescription("MessageSize is too large. Max allow: " + StreamWriterV2.getApiMaxRequestBytes() + " Actual: " + requestWrapper.messageSize)));
            return requestWrapper.appendResult;
        }
        this.lock.lock();
        try {
            if (this.userClosed) {
                requestWrapper.appendResult.setException((Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.FAILED_PRECONDITION).withDescription("Stream is already closed")));
                SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
                return settableApiFuture;
            }
            if (this.connectionFinalStatus != null) {
                requestWrapper.appendResult.setException((Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.FAILED_PRECONDITION).withDescription("Stream is closed due to " + this.connectionFinalStatus.toString())));
                SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
                return settableApiFuture;
            }
            ++this.inflightRequests;
            this.inflightBytes += requestWrapper.messageSize;
            this.waitingRequestQueue.addLast(requestWrapper);
            this.hasMessageInWaitingQueue.signal();
            this.maybeWaitForInflightQuota();
            SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
            return settableApiFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private void maybeWaitForInflightQuota() {
        while (this.inflightRequests >= this.maxInflightRequests || this.inflightBytes >= this.maxInflightBytes) {
            try {
                this.inflightReduced.await(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.warning("Interrupted while waiting for inflight quota. Stream: " + this.streamName + " Error: " + e.toString());
                throw new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.CANCELLED).withCause((Throwable)e).withDescription("Interrupted while waiting for quota."));
            }
        }
    }

    @Override
    public void close() {
        log.info("User closing stream: " + this.streamName);
        this.lock.lock();
        try {
            this.userClosed = true;
        }
        finally {
            this.lock.unlock();
        }
        log.info("Waiting for append thread to finish. Stream: " + this.streamName);
        try {
            this.appendThread.join();
            log.info("User close complete. Stream: " + this.streamName);
        }
        catch (InterruptedException e) {
            log.warning("Append handler join is interrupted. Stream: " + this.streamName + " Error: " + e.toString());
        }
        if (this.ownsBigQueryWriteClient) {
            this.client.close();
        }
    }

    private void appendLoop() {
        LinkedList<AppendRequestAndResponse> localQueue = new LinkedList<AppendRequestAndResponse>();
        while (!this.waitingQueueDrained()) {
            this.lock.lock();
            try {
                this.hasMessageInWaitingQueue.await(100L, TimeUnit.MILLISECONDS);
                while (!this.waitingRequestQueue.isEmpty()) {
                    AppendRequestAndResponse requestWrapper = this.waitingRequestQueue.pollFirst();
                    this.inflightRequestQueue.addLast(requestWrapper);
                    localQueue.addLast(requestWrapper);
                }
            }
            catch (InterruptedException e) {
                log.warning("Interrupted while waiting for message. Stream: " + this.streamName + " Error: " + e.toString());
            }
            finally {
                this.lock.unlock();
            }
            if (localQueue.isEmpty()) continue;
            while (!localQueue.isEmpty()) {
                this.streamConnection.send(((AppendRequestAndResponse)localQueue.pollFirst()).message);
            }
        }
        log.info("Cleanup starts. Stream: " + this.streamName);
        this.streamConnection.close();
        this.waitForDoneCallback();
        log.info("Stream connection is fully closed. Cleaning up inflight requests. Stream: " + this.streamName);
        this.cleanupInflightRequests();
        log.info("Append thread is done. Stream: " + this.streamName);
    }

    private boolean waitingQueueDrained() {
        this.lock.lock();
        try {
            boolean bl = (this.userClosed || this.connectionFinalStatus != null) && this.waitingRequestQueue.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitForDoneCallback() {
        log.info("Waiting for done callback from stream connection. Stream: " + this.streamName);
        while (true) {
            this.lock.lock();
            try {
                if (this.connectionFinalStatus != null) {
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private void cleanupInflightRequests() {
        Throwable finalStatus;
        LinkedList<AppendRequestAndResponse> localQueue = new LinkedList<AppendRequestAndResponse>();
        this.lock.lock();
        try {
            finalStatus = this.connectionFinalStatus;
            while (!this.inflightRequestQueue.isEmpty()) {
                localQueue.addLast(this.pollInflightRequestQueue());
            }
        }
        finally {
            this.lock.unlock();
        }
        log.info("Cleaning " + localQueue.size() + " inflight requests with error: " + finalStatus.toString());
        while (!localQueue.isEmpty()) {
            ((AppendRequestAndResponse)localQueue.pollFirst()).appendResult.setException(finalStatus);
        }
    }

    private void requestCallback(AppendRowsResponse response) {
        AppendRequestAndResponse requestWrapper;
        this.lock.lock();
        try {
            requestWrapper = this.pollInflightRequestQueue();
        }
        finally {
            this.lock.unlock();
        }
        requestWrapper.appendResult.set((Object)response);
    }

    private void doneCallback(Throwable finalStatus) {
        log.info("Received done callback. Stream: " + this.streamName + " Final status: " + finalStatus.toString());
        this.lock.lock();
        try {
            this.connectionFinalStatus = finalStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private AppendRequestAndResponse pollInflightRequestQueue() {
        AppendRequestAndResponse requestWrapper = this.inflightRequestQueue.pollFirst();
        --this.inflightRequests;
        this.inflightBytes -= requestWrapper.messageSize;
        this.inflightReduced.signal();
        return requestWrapper;
    }

    public static Builder newBuilder(String streamName, BigQueryWriteClient client) {
        return new Builder(streamName, client);
    }

    public static Builder newBuilder(String streamName) {
        return new Builder(streamName);
    }

    private static final class AppendRequestAndResponse {
        final SettableApiFuture<AppendRowsResponse> appendResult = SettableApiFuture.create();
        final AppendRowsRequest message;
        final long messageSize;

        AppendRequestAndResponse(AppendRowsRequest message) {
            this.message = message;
            this.messageSize = message.getProtoRows().getSerializedSize();
        }
    }

    public static final class Builder {
        private static final long DEFAULT_MAX_INFLIGHT_REQUESTS = 1000L;
        private static final long DEFAULT_MAX_INFLIGHT_BYTES = 0x6400000L;
        private String streamName;
        private BigQueryWriteClient client;
        private long maxInflightRequest = 1000L;
        private long maxInflightBytes = 0x6400000L;
        private String endpoint = BigQueryWriteSettings.getDefaultEndpoint();
        private TransportChannelProvider channelProvider = BigQueryWriteSettings.defaultGrpcTransportProviderBuilder().setChannelsPerCpu(1.0).build();
        private CredentialsProvider credentialsProvider = BigQueryWriteSettings.defaultCredentialsProviderBuilder().build();

        private Builder(String streamName) {
            this.streamName = (String)Preconditions.checkNotNull((Object)streamName);
            this.client = null;
        }

        private Builder(String streamName, BigQueryWriteClient client) {
            this.streamName = (String)Preconditions.checkNotNull((Object)streamName);
            this.client = (BigQueryWriteClient)Preconditions.checkNotNull((Object)client);
        }

        public Builder setMaxInflightRequests(long value) {
            this.maxInflightRequest = value;
            return this;
        }

        public Builder setMaxInflightBytes(long value) {
            this.maxInflightBytes = value;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"Endpoint is null.");
            return this;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider, (Object)"ChannelProvider is null.");
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider, (Object)"CredentialsProvider is null.");
            return this;
        }

        public StreamWriterV2 build() throws IOException {
            return new StreamWriterV2(this);
        }
    }
}

