/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1alpha2.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1alpha2.Storage;
import com.google.cloud.bigquery.storage.v1alpha2.Stream;
import com.google.cloud.bigquery.storage.v1alpha2.TableName;
import com.google.cloud.bigquery.storage.v1alpha2.WriteStreamName;
import com.google.cloud.bigquery.storage.v1alpha2.stub.BigQueryWriteStub;
import com.google.cloud.bigquery.storage.v1alpha2.stub.BigQueryWriteStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BigQueryWriteClient
implements BackgroundResource {
    private final BigQueryWriteSettings settings;
    private final BigQueryWriteStub stub;

    public static final BigQueryWriteClient create() throws IOException {
        return BigQueryWriteClient.create(BigQueryWriteSettings.newBuilder().build());
    }

    public static final BigQueryWriteClient create(BigQueryWriteSettings settings) throws IOException {
        return new BigQueryWriteClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BigQueryWriteClient create(BigQueryWriteStub stub) {
        return new BigQueryWriteClient(stub);
    }

    protected BigQueryWriteClient(BigQueryWriteSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BigQueryWriteStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BigQueryWriteClient(BigQueryWriteStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BigQueryWriteSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BigQueryWriteStub getStub() {
        return this.stub;
    }

    public final Stream.WriteStream createWriteStream(TableName parent, Stream.WriteStream writeStream) {
        Storage.CreateWriteStreamRequest request = Storage.CreateWriteStreamRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWriteStream(writeStream).build();
        return this.createWriteStream(request);
    }

    public final Stream.WriteStream createWriteStream(String parent, Stream.WriteStream writeStream) {
        Storage.CreateWriteStreamRequest request = Storage.CreateWriteStreamRequest.newBuilder().setParent(parent).setWriteStream(writeStream).build();
        return this.createWriteStream(request);
    }

    public final Stream.WriteStream createWriteStream(Storage.CreateWriteStreamRequest request) {
        return (Stream.WriteStream)this.createWriteStreamCallable().call((Object)request);
    }

    public final UnaryCallable<Storage.CreateWriteStreamRequest, Stream.WriteStream> createWriteStreamCallable() {
        return this.stub.createWriteStreamCallable();
    }

    public final BidiStreamingCallable<Storage.AppendRowsRequest, Storage.AppendRowsResponse> appendRowsCallable() {
        return this.stub.appendRowsCallable();
    }

    public final Stream.WriteStream getWriteStream(WriteStreamName name) {
        Storage.GetWriteStreamRequest request = Storage.GetWriteStreamRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWriteStream(request);
    }

    public final Stream.WriteStream getWriteStream(String name) {
        Storage.GetWriteStreamRequest request = Storage.GetWriteStreamRequest.newBuilder().setName(name).build();
        return this.getWriteStream(request);
    }

    public final Stream.WriteStream getWriteStream(Storage.GetWriteStreamRequest request) {
        return (Stream.WriteStream)this.getWriteStreamCallable().call((Object)request);
    }

    public final UnaryCallable<Storage.GetWriteStreamRequest, Stream.WriteStream> getWriteStreamCallable() {
        return this.stub.getWriteStreamCallable();
    }

    public final Storage.FinalizeWriteStreamResponse finalizeWriteStream(WriteStreamName name) {
        Storage.FinalizeWriteStreamRequest request = Storage.FinalizeWriteStreamRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.finalizeWriteStream(request);
    }

    public final Storage.FinalizeWriteStreamResponse finalizeWriteStream(String name) {
        Storage.FinalizeWriteStreamRequest request = Storage.FinalizeWriteStreamRequest.newBuilder().setName(name).build();
        return this.finalizeWriteStream(request);
    }

    public final Storage.FinalizeWriteStreamResponse finalizeWriteStream(Storage.FinalizeWriteStreamRequest request) {
        return (Storage.FinalizeWriteStreamResponse)this.finalizeWriteStreamCallable().call((Object)request);
    }

    public final UnaryCallable<Storage.FinalizeWriteStreamRequest, Storage.FinalizeWriteStreamResponse> finalizeWriteStreamCallable() {
        return this.stub.finalizeWriteStreamCallable();
    }

    public final Storage.BatchCommitWriteStreamsResponse batchCommitWriteStreams(TableName parent) {
        Storage.BatchCommitWriteStreamsRequest request = Storage.BatchCommitWriteStreamsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.batchCommitWriteStreams(request);
    }

    public final Storage.BatchCommitWriteStreamsResponse batchCommitWriteStreams(String parent) {
        Storage.BatchCommitWriteStreamsRequest request = Storage.BatchCommitWriteStreamsRequest.newBuilder().setParent(parent).build();
        return this.batchCommitWriteStreams(request);
    }

    public final Storage.BatchCommitWriteStreamsResponse batchCommitWriteStreams(Storage.BatchCommitWriteStreamsRequest request) {
        return (Storage.BatchCommitWriteStreamsResponse)this.batchCommitWriteStreamsCallable().call((Object)request);
    }

    public final UnaryCallable<Storage.BatchCommitWriteStreamsRequest, Storage.BatchCommitWriteStreamsResponse> batchCommitWriteStreamsCallable() {
        return this.stub.batchCommitWriteStreamsCallable();
    }

    public final Storage.FlushRowsResponse flushRows(WriteStreamName writeStream) {
        Storage.FlushRowsRequest request = Storage.FlushRowsRequest.newBuilder().setWriteStream(writeStream == null ? null : writeStream.toString()).build();
        return this.flushRows(request);
    }

    public final Storage.FlushRowsResponse flushRows(String writeStream) {
        Storage.FlushRowsRequest request = Storage.FlushRowsRequest.newBuilder().setWriteStream(writeStream).build();
        return this.flushRows(request);
    }

    public final Storage.FlushRowsResponse flushRows(Storage.FlushRowsRequest request) {
        return (Storage.FlushRowsResponse)this.flushRowsCallable().call((Object)request);
    }

    public final UnaryCallable<Storage.FlushRowsRequest, Storage.FlushRowsResponse> flushRowsCallable() {
        return this.stub.flushRowsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

