/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.api.core.InternalApi;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

class Waiter {
    private static final Logger LOG = Logger.getLogger(Waiter.class.getName());
    private long pendingCount = 0L;
    private long pendingSize = 0L;
    private long countLimit;
    private long sizeLimit;
    private FlowController.LimitExceededBehavior behavior;
    private LinkedList<CountDownLatch> awaitingMessageAcquires = new LinkedList();
    private LinkedList<CountDownLatch> awaitingBytesAcquires = new LinkedList();
    private final Lock lock;

    Waiter(FlowControlSettings flowControlSettings) {
        this.countLimit = flowControlSettings.getMaxOutstandingElementCount();
        this.sizeLimit = flowControlSettings.getMaxOutstandingRequestBytes();
        this.behavior = flowControlSettings.getLimitExceededBehavior();
        this.lock = new ReentrantLock();
    }

    private void notifyNextAcquires() {
        CountDownLatch awaitingAcquire;
        if (!this.awaitingMessageAcquires.isEmpty()) {
            awaitingAcquire = this.awaitingMessageAcquires.getFirst();
            awaitingAcquire.countDown();
        }
        if (!this.awaitingBytesAcquires.isEmpty()) {
            awaitingAcquire = this.awaitingBytesAcquires.getFirst();
            awaitingAcquire.countDown();
        }
    }

    public synchronized void release(long messageSize) {
        this.lock.lock();
        --this.pendingCount;
        this.pendingSize -= messageSize;
        this.notifyNextAcquires();
        this.lock.unlock();
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(long messageSize) throws FlowController.FlowControlException {
        this.lock.lock();
        try {
            if (this.pendingCount >= this.countLimit && this.behavior == FlowController.LimitExceededBehavior.ThrowException) {
                throw new FlowController.MaxOutstandingElementCountReachedException(this.countLimit);
            }
            if (this.pendingSize + messageSize >= this.sizeLimit && this.behavior == FlowController.LimitExceededBehavior.ThrowException) {
                throw new FlowController.MaxOutstandingRequestBytesReachedException(this.sizeLimit);
            }
            CountDownLatch messageWaiter = null;
            while (this.pendingCount >= this.countLimit) {
                if (messageWaiter == null) {
                    messageWaiter = new CountDownLatch(1);
                    this.awaitingMessageAcquires.addLast(messageWaiter);
                } else {
                    messageWaiter = new CountDownLatch(1);
                    this.awaitingMessageAcquires.set(0, messageWaiter);
                }
                this.lock.unlock();
                try {
                    messageWaiter.await();
                }
                catch (InterruptedException e) {
                    LOG.warning("Interrupted while waiting to acquire flow control tokens");
                }
                this.lock.lock();
            }
            ++this.pendingCount;
            if (messageWaiter != null) {
                this.awaitingMessageAcquires.removeFirst();
            }
            if (!this.awaitingMessageAcquires.isEmpty() && this.pendingCount < this.countLimit) {
                this.awaitingMessageAcquires.getFirst().countDown();
            }
            CountDownLatch bytesWaiter = null;
            Long bytesRemaining = messageSize;
            while (this.pendingSize + messageSize >= this.sizeLimit) {
                if (bytesWaiter == null) {
                    bytesWaiter = new CountDownLatch(1);
                    this.awaitingBytesAcquires.addLast(bytesWaiter);
                } else {
                    bytesWaiter = new CountDownLatch(1);
                    this.awaitingBytesAcquires.set(0, bytesWaiter);
                }
                this.lock.unlock();
                try {
                    bytesWaiter.await();
                }
                catch (InterruptedException e) {
                    LOG.warning("Interrupted while waiting to acquire flow control tokens");
                }
                this.lock.lock();
            }
            this.pendingSize += messageSize;
            if (bytesWaiter != null) {
                this.awaitingBytesAcquires.removeFirst();
            }
            if (!this.awaitingBytesAcquires.isEmpty() && this.pendingSize < this.sizeLimit) {
                this.awaitingBytesAcquires.getFirst().countDown();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized void waitComplete() {
        this.lock.lock();
        try {
            while (this.pendingCount > 0L) {
                this.lock.unlock();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    LOG.warning("Interrupted while waiting for completion");
                }
                this.lock.lock();
            }
        }
        catch (Exception e) {
            LOG.warning(e.toString());
        }
        finally {
            this.lock.unlock();
        }
    }

    @InternalApi
    public long pendingCount() {
        return this.pendingCount;
    }

    @InternalApi
    public long pendingSize() {
        return this.pendingSize;
    }
}

