/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryReadStub;
import com.google.cloud.bigquery.storage.v1.stub.GrpcBigQueryReadStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class BigQueryReadStubSettings
extends StubSettings<BigQueryReadStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigquery").add((Object)"https://www.googleapis.com/auth/bigquery.readonly").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateReadSessionRequest, ReadSession> createReadSessionSettings;
    private final ServerStreamingCallSettings<ReadRowsRequest, ReadRowsResponse> readRowsSettings;
    private final UnaryCallSettings<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamSettings;

    public UnaryCallSettings<CreateReadSessionRequest, ReadSession> createReadSessionSettings() {
        return this.createReadSessionSettings;
    }

    public ServerStreamingCallSettings<ReadRowsRequest, ReadRowsResponse> readRowsSettings() {
        return this.readRowsSettings;
    }

    public UnaryCallSettings<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamSettings() {
        return this.splitReadStreamSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BigQueryReadStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBigQueryReadStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "bigquerystorage.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BigQueryReadStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BigQueryReadStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BigQueryReadStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createReadSessionSettings = settingsBuilder.createReadSessionSettings().build();
        this.readRowsSettings = settingsBuilder.readRowsSettings().build();
        this.splitReadStreamSettings = settingsBuilder.splitReadStreamSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BigQueryReadStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateReadSessionRequest, ReadSession> createReadSessionSettings;
        private final ServerStreamingCallSettings.Builder<ReadRowsRequest, ReadRowsResponse> readRowsSettings;
        private final UnaryCallSettings.Builder<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createReadSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.readRowsSettings = ServerStreamingCallSettings.newBuilder();
            this.splitReadStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createReadSessionSettings, this.splitReadStreamSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BigQueryReadStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BigQueryReadStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BigQueryReadStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BigQueryReadStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createReadSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"create_read_session"));
            builder.readRowsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"unary_streaming")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"read_rows"));
            builder.splitReadStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(BigQueryReadStubSettings settings) {
            super((StubSettings)settings);
            this.createReadSessionSettings = settings.createReadSessionSettings.toBuilder();
            this.readRowsSettings = settings.readRowsSettings.toBuilder();
            this.splitReadStreamSettings = settings.splitReadStreamSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createReadSessionSettings, this.splitReadStreamSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateReadSessionRequest, ReadSession> createReadSessionSettings() {
            return this.createReadSessionSettings;
        }

        public ServerStreamingCallSettings.Builder<ReadRowsRequest, ReadRowsResponse> readRowsSettings() {
            return this.readRowsSettings;
        }

        public UnaryCallSettings.Builder<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamSettings() {
            return this.splitReadStreamSettings;
        }

        public BigQueryReadStubSettings build() throws IOException {
            return new BigQueryReadStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"unary_streaming", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"create_read_session", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)86400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)86400000L)).setTotalTimeout(Duration.ofMillis((long)86400000L)).build();
            definitions.put((Object)"read_rows", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

