/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.AbortedException;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1alpha2.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1alpha2.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto;
import com.google.cloud.bigquery.storage.v1alpha2.Storage;
import com.google.cloud.bigquery.storage.v1alpha2.Stream;
import com.google.cloud.bigquery.storage.v1alpha2.Waiter;
import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

public class StreamWriter
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(StreamWriter.class.getName());
    private static String streamPatternString = "(projects/[^/]+/datasets/[^/]+/tables/[^/]+)/streams/[^/]+";
    private static Pattern streamPattern = Pattern.compile(streamPatternString);
    private final String streamName;
    private final String tableName;
    private final BatchingSettings batchingSettings;
    private final RetrySettings retrySettings;
    private final BigQueryWriteSettings stubSettings;
    private final Lock messagesBatchLock;
    private final MessagesBatch messagesBatch;
    private BackgroundResource backgroundResources;
    private List<BackgroundResource> backgroundResourceList;
    private BigQueryWriteClient stub;
    BidiStreamingCallable<Storage.AppendRowsRequest, Storage.AppendRowsResponse> bidiStreamingCallable;
    ClientStream<Storage.AppendRowsRequest> clientStream;
    private final AppendResponseObserver responseObserver;
    private final ScheduledExecutorService executor;
    private final AtomicBoolean shutdown;
    private final Waiter messagesWaiter;
    private final AtomicBoolean activeAlarm;
    private ScheduledFuture<?> currentAlarmFuture;
    private Instant createTime;
    private Duration streamTTL = Duration.ofDays((long)1L);
    private Integer currentRetries = 0;

    public static long getApiMaxRequestBytes() {
        return 10000000L;
    }

    public static long getApiMaxInflightRequests() {
        return 5000L;
    }

    private StreamWriter(Builder builder) throws IllegalArgumentException, IOException, InterruptedException {
        Matcher matcher = streamPattern.matcher(builder.streamName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid stream name: " + builder.streamName);
        }
        this.streamName = builder.streamName;
        this.tableName = matcher.group(1);
        this.batchingSettings = builder.batchingSettings;
        this.retrySettings = builder.retrySettings;
        this.messagesBatch = new MessagesBatch(this.batchingSettings, this.streamName);
        this.messagesBatchLock = new ReentrantLock();
        this.activeAlarm = new AtomicBoolean(false);
        this.executor = builder.executorProvider.getExecutor();
        this.backgroundResourceList = new ArrayList<BackgroundResource>();
        if (builder.executorProvider.shouldAutoClose()) {
            this.backgroundResourceList.add((BackgroundResource)new ExecutorAsBackgroundResource((ExecutorService)this.executor));
        }
        this.messagesWaiter = new Waiter(this.batchingSettings.getFlowControlSettings());
        this.responseObserver = new AppendResponseObserver(this);
        this.stubSettings = ((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider(builder.credentialsProvider)).setExecutorProvider(builder.executorProvider)).setTransportChannelProvider(builder.channelProvider)).setEndpoint(builder.endpoint)).build();
        this.shutdown = new AtomicBoolean(false);
        this.refreshAppend();
        Stream.WriteStream stream = this.stub.getWriteStream(Storage.GetWriteStreamRequest.newBuilder().setName(this.streamName).build());
        this.createTime = Instant.ofEpochSecond((long)stream.getCreateTime().getSeconds(), (long)stream.getCreateTime().getNanos());
        if (stream.getType() == Stream.WriteStream.Type.PENDING && stream.hasCommitTime()) {
            throw new IllegalStateException("Cannot write to a stream that is already committed: " + this.streamName);
        }
        if (this.createTime.plus((TemporalAmount)this.streamTTL).compareTo(Instant.now()) < 0) {
            throw new IllegalStateException("Cannot write to a stream that is already expired: " + this.streamName);
        }
    }

    public String getStreamNameString() {
        return this.streamName;
    }

    public String getTableNameString() {
        return this.tableName;
    }

    public Boolean expired() {
        return this.createTime.plus((TemporalAmount)this.streamTTL).compareTo(Instant.now()) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<Storage.AppendRowsResponse> append(Storage.AppendRowsRequest message) {
        Preconditions.checkState((!this.shutdown.get() ? 1 : 0) != 0, (Object)"Cannot append on a shut-down writer.");
        AppendRequestAndFutureResponse outstandingAppend = new AppendRequestAndFutureResponse(message);
        this.messagesBatchLock.lock();
        try {
            List batchesToSend = this.messagesBatch.add(outstandingAppend);
            this.setupAlarm();
            if (!batchesToSend.isEmpty()) {
                for (InflightBatch batch : batchesToSend) {
                    LOG.fine("Scheduling a batch for immediate sending.");
                    this.writeBatch(batch);
                }
            }
        }
        finally {
            this.messagesBatchLock.unlock();
        }
        return outstandingAppend.appendResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAppend() throws IOException, InterruptedException {
        StreamWriter streamWriter = this;
        synchronized (streamWriter) {
            Preconditions.checkState((!this.shutdown.get() ? 1 : 0) != 0, (Object)"Cannot append on a shut-down writer.");
            if (this.stub != null) {
                this.clientStream.closeSend();
                this.stub.shutdown();
                this.stub.awaitTermination(1L, TimeUnit.MINUTES);
            }
            this.backgroundResourceList.remove(this.stub);
            this.stub = BigQueryWriteClient.create(this.stubSettings);
            this.backgroundResourceList.add(this.stub);
            this.backgroundResources = new BackgroundResourceAggregation(this.backgroundResourceList);
            this.messagesBatch.resetAttachSchema();
            this.bidiStreamingCallable = this.stub.appendRowsCallable();
            this.clientStream = this.bidiStreamingCallable.splitCall((ResponseObserver)this.responseObserver);
        }
        try {
            while (!this.clientStream.isSendReady()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.info("Write Stream " + this.streamName + " connection established");
    }

    private void setupAlarm() {
        if (!this.messagesBatch.isEmpty()) {
            if (!this.activeAlarm.getAndSet(true)) {
                long delayThresholdMs = this.getBatchingSettings().getDelayThreshold().toMillis();
                LOG.log(Level.FINE, "Setting up alarm for the next {0} ms.", delayThresholdMs);
                this.currentAlarmFuture = this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        LOG.fine("Sending messages based on schedule");
                        StreamWriter.this.activeAlarm.getAndSet(false);
                        StreamWriter.this.messagesBatchLock.lock();
                        try {
                            StreamWriter.this.writeBatch(StreamWriter.this.messagesBatch.popBatch());
                        }
                        finally {
                            StreamWriter.this.messagesBatchLock.unlock();
                        }
                    }
                }, delayThresholdMs, TimeUnit.MILLISECONDS);
            }
        } else if (this.currentAlarmFuture != null) {
            LOG.log(Level.FINER, "Cancelling alarm, no more messages");
            if (this.activeAlarm.getAndSet(false)) {
                this.currentAlarmFuture.cancel(false);
            }
        }
    }

    public void writeAllOutstanding() {
        Object unorderedOutstandingBatch = null;
        this.messagesBatchLock.lock();
        try {
            if (!this.messagesBatch.isEmpty()) {
                this.writeBatch(this.messagesBatch.popBatch());
            }
            this.messagesBatch.reset();
        }
        finally {
            this.messagesBatchLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBatch(InflightBatch inflightBatch) {
        if (inflightBatch != null) {
            Storage.AppendRowsRequest request = inflightBatch.getMergedRequest();
            this.messagesWaiter.waitOnElementCount();
            this.messagesWaiter.waitOnSizeLimit(inflightBatch.getByteSize());
            this.responseObserver.addInflightBatch(inflightBatch);
            this.clientStream.send((Object)request);
            Waiter waiter = this.messagesWaiter;
            synchronized (waiter) {
                this.messagesWaiter.incrementPendingCount(1);
                this.messagesWaiter.incrementPendingSize(inflightBatch.getByteSize());
            }
        }
    }

    @Override
    public void close() {
        LOG.info("Closing stream writer");
        this.shutdown();
        try {
            this.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public BatchingSettings getBatchingSettings() {
        return this.batchingSettings;
    }

    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    public void shutdown() {
        Preconditions.checkState((!this.shutdown.getAndSet(true) ? 1 : 0) != 0, (Object)"Cannot shut down a writer already shut-down.");
        if (this.currentAlarmFuture != null && this.activeAlarm.getAndSet(false)) {
            this.currentAlarmFuture.cancel(false);
        }
        this.writeAllOutstanding();
        this.messagesWaiter.waitComplete();
        if (this.clientStream.isSendReady()) {
            this.clientStream.closeSend();
        }
        this.backgroundResources.shutdown();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }

    public static Builder newBuilder(String streamName) {
        return new Builder(streamName);
    }

    private static class MessagesBatch {
        private List<AppendRequestAndFutureResponse> messages;
        private int batchedBytes;
        private final BatchingSettings batchingSettings;
        private Boolean attachSchema = true;
        private final String streamName;

        private MessagesBatch(BatchingSettings batchingSettings, String streamName) {
            this.batchingSettings = batchingSettings;
            this.streamName = streamName;
            this.reset();
        }

        private InflightBatch popBatch() {
            InflightBatch batch = new InflightBatch(this.messages, this.batchedBytes, this.streamName, this.attachSchema);
            this.attachSchema = false;
            this.reset();
            return batch;
        }

        private void reset() {
            this.messages = new LinkedList<AppendRequestAndFutureResponse>();
            this.batchedBytes = 0;
        }

        private void resetAttachSchema() {
            this.attachSchema = true;
        }

        private boolean isEmpty() {
            return this.messages.isEmpty();
        }

        private int getBatchedBytes() {
            return this.batchedBytes;
        }

        private int getMessagesCount() {
            return this.messages.size();
        }

        private boolean hasBatchingBytes() {
            return this.getMaxBatchBytes() > 0L;
        }

        private long getMaxBatchBytes() {
            return this.batchingSettings.getRequestByteThreshold();
        }

        private List<InflightBatch> add(AppendRequestAndFutureResponse outstandingAppend) {
            ArrayList<InflightBatch> batchesToSend = new ArrayList<InflightBatch>();
            if (!this.isEmpty() && this.hasBatchingBytes() && (long)(this.getBatchedBytes() + outstandingAppend.messageSize) >= this.getMaxBatchBytes()) {
                batchesToSend.add(this.popBatch());
            }
            this.messages.add(outstandingAppend);
            this.batchedBytes += outstandingAppend.messageSize;
            if (this.hasBatchingBytes() && (long)outstandingAppend.messageSize >= this.getMaxBatchBytes() || (long)this.getMessagesCount() == this.batchingSettings.getElementCountThreshold()) {
                batchesToSend.add(this.popBatch());
            }
            return batchesToSend;
        }
    }

    private static final class AppendResponseObserver
    implements ResponseObserver<Storage.AppendRowsResponse> {
        private Queue<InflightBatch> inflightBatches = new LinkedList<InflightBatch>();
        private StreamWriter streamWriter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInflightBatch(InflightBatch batch) {
            Queue<InflightBatch> queue = this.inflightBatches;
            synchronized (queue) {
                this.inflightBatches.add(batch);
            }
        }

        public AppendResponseObserver(StreamWriter streamWriter) {
            this.streamWriter = streamWriter;
        }

        private boolean isRecoverableError(Throwable t) {
            Status status = Status.fromThrowable((Throwable)t);
            return status.getCode() == Status.Code.UNAVAILABLE;
        }

        public void onStart(StreamController controller) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void abortInflightRequests(Throwable t) {
            Queue<InflightBatch> queue = this.inflightBatches;
            synchronized (queue) {
                while (!this.inflightBatches.isEmpty()) {
                    this.inflightBatches.poll().onFailure((Throwable)new AbortedException("Request aborted due to previous failures", t, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.ABORTED), true));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(Storage.AppendRowsResponse response) {
            InflightBatch inflightBatch = null;
            Object object = this.inflightBatches;
            synchronized (object) {
                inflightBatch = this.inflightBatches.poll();
            }
            try {
                Object exception;
                this.streamWriter.currentRetries = 0;
                if (response == null) {
                    inflightBatch.onFailure(new IllegalStateException("Response is null"));
                }
                if (response.hasError()) {
                    exception = new StatusRuntimeException(Status.fromCodeValue((int)response.getError().getCode()).withDescription(response.getError().getMessage()));
                    inflightBatch.onFailure((Throwable)exception);
                }
                if (inflightBatch.getExpectedOffset() > 0L && response.getOffset() != inflightBatch.getExpectedOffset()) {
                    exception = new IllegalStateException(String.format("The append result offset %s does not match the expected offset %s.", response.getOffset(), inflightBatch.getExpectedOffset()));
                    inflightBatch.onFailure((Throwable)exception);
                    this.abortInflightRequests((Throwable)exception);
                } else {
                    inflightBatch.onSuccess(response);
                }
            }
            finally {
                object = this.streamWriter.messagesWaiter;
                synchronized (object) {
                    this.streamWriter.messagesWaiter.incrementPendingCount(-1);
                    this.streamWriter.messagesWaiter.incrementPendingSize(0 - inflightBatch.getByteSize());
                    this.streamWriter.messagesWaiter.notifyAll();
                }
            }
        }

        public void onComplete() {
            LOG.info("OnComplete called");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            block29: {
                LOG.fine("OnError called");
                if (this.streamWriter.shutdown.get()) {
                    return;
                }
                InflightBatch inflightBatch = null;
                Object object = this.inflightBatches;
                synchronized (object) {
                    if (this.inflightBatches.isEmpty()) {
                        return;
                    }
                    inflightBatch = this.inflightBatches.poll();
                }
                try {
                    if (this.isRecoverableError(t)) {
                        try {
                            if (this.streamWriter.currentRetries < this.streamWriter.getRetrySettings().getMaxAttempts() && !this.streamWriter.shutdown.get()) {
                                this.streamWriter.refreshAppend();
                                Thread.sleep(Math.min(this.streamWriter.getRetrySettings().getInitialRetryDelay().toMillis(), Duration.ofSeconds((long)5L).toMillis()));
                                this.streamWriter.writeBatch(inflightBatch);
                                object = this.streamWriter.currentRetries;
                                synchronized (object) {
                                    StreamWriter streamWriter = this.streamWriter;
                                    Integer n = streamWriter.currentRetries;
                                    Integer n2 = streamWriter.currentRetries = streamWriter.currentRetries + 1;
                                    break block29;
                                }
                            }
                            object = this.streamWriter.currentRetries;
                            synchronized (object) {
                                this.streamWriter.currentRetries = 0;
                            }
                            inflightBatch.onFailure(t);
                        }
                        catch (IOException | InterruptedException e) {
                            this.streamWriter.currentRetries = 0;
                            inflightBatch.onFailure(e);
                        }
                        break block29;
                    }
                    Integer e = this.streamWriter.currentRetries;
                    synchronized (e) {
                        this.streamWriter.currentRetries = 0;
                    }
                    inflightBatch.onFailure(t);
                    try {
                        this.streamWriter.refreshAppend();
                    }
                    catch (IOException | InterruptedException e2) {
                        LOG.info("Failed to establish a new connection");
                    }
                }
                finally {
                    object = this.streamWriter.messagesWaiter;
                    synchronized (object) {
                        this.streamWriter.messagesWaiter.incrementPendingCount(-1);
                        this.streamWriter.messagesWaiter.incrementPendingSize(0 - inflightBatch.getByteSize());
                        this.streamWriter.messagesWaiter.notifyAll();
                    }
                }
            }
        }
    }

    public static final class Builder {
        static final Duration MIN_TOTAL_TIMEOUT = Duration.ofSeconds((long)10L);
        static final Duration MIN_RPC_TIMEOUT = Duration.ofMillis((long)10L);
        static final long DEFAULT_ELEMENT_COUNT_THRESHOLD = 100L;
        static final long DEFAULT_REQUEST_BYTES_THRESHOLD = 102400L;
        static final Duration DEFAULT_DELAY_THRESHOLD = Duration.ofMillis((long)10L);
        static final FlowControlSettings DEFAULT_FLOW_CONTROL_SETTINGS = FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).setMaxOutstandingElementCount(Long.valueOf(1000L)).setMaxOutstandingRequestBytes(Long.valueOf(0x6400000L)).build();
        public static final BatchingSettings DEFAULT_BATCHING_SETTINGS = BatchingSettings.newBuilder().setDelayThreshold(DEFAULT_DELAY_THRESHOLD).setRequestByteThreshold(Long.valueOf(102400L)).setElementCountThreshold(Long.valueOf(100L)).setFlowControlSettings(DEFAULT_FLOW_CONTROL_SETTINGS).build();
        public static final RetrySettings DEFAULT_RETRY_SETTINGS = RetrySettings.newBuilder().setMaxRetryDelay(Duration.ofSeconds((long)60L)).setInitialRetryDelay(Duration.ofMillis((long)100L)).setMaxAttempts(3).build();
        static final boolean DEFAULT_ENABLE_MESSAGE_ORDERING = false;
        private static final int THREADS_PER_CPU = 5;
        static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(5 * Runtime.getRuntime().availableProcessors()).build();
        private String streamName;
        private String endpoint = BigQueryWriteSettings.getDefaultEndpoint();
        BatchingSettings batchingSettings = DEFAULT_BATCHING_SETTINGS;
        RetrySettings retrySettings = DEFAULT_RETRY_SETTINGS;
        private boolean enableMessageOrdering = false;
        private TransportChannelProvider channelProvider = BigQueryWriteSettings.defaultGrpcTransportProviderBuilder().setChannelsPerCpu(1.0).build();
        ExecutorProvider executorProvider = DEFAULT_EXECUTOR_PROVIDER;
        private CredentialsProvider credentialsProvider = BigQueryWriteSettings.defaultCredentialsProviderBuilder().build();

        private Builder(String stream) {
            this.streamName = (String)Preconditions.checkNotNull((Object)stream);
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this;
        }

        public Builder setBatchingSettings(BatchingSettings batchingSettings) {
            Preconditions.checkNotNull((Object)batchingSettings);
            BatchingSettings.Builder builder = batchingSettings.toBuilder();
            Preconditions.checkNotNull((Object)batchingSettings.getElementCountThreshold());
            Preconditions.checkArgument((batchingSettings.getElementCountThreshold() > 0L ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)batchingSettings.getRequestByteThreshold());
            Preconditions.checkArgument((batchingSettings.getRequestByteThreshold() > 0L ? 1 : 0) != 0);
            if (batchingSettings.getRequestByteThreshold() > StreamWriter.getApiMaxRequestBytes()) {
                builder.setRequestByteThreshold(Long.valueOf(StreamWriter.getApiMaxRequestBytes()));
            }
            Preconditions.checkNotNull((Object)batchingSettings.getDelayThreshold());
            Preconditions.checkArgument((batchingSettings.getDelayThreshold().toMillis() > 0L ? 1 : 0) != 0);
            if (batchingSettings.getFlowControlSettings() == null) {
                builder.setFlowControlSettings(DEFAULT_FLOW_CONTROL_SETTINGS);
            } else {
                if (batchingSettings.getFlowControlSettings().getMaxOutstandingElementCount() == null) {
                    builder.setFlowControlSettings(batchingSettings.getFlowControlSettings().toBuilder().setMaxOutstandingElementCount(DEFAULT_FLOW_CONTROL_SETTINGS.getMaxOutstandingElementCount()).build());
                } else {
                    Preconditions.checkArgument((batchingSettings.getFlowControlSettings().getMaxOutstandingElementCount() > 0L ? 1 : 0) != 0);
                    if (batchingSettings.getFlowControlSettings().getMaxOutstandingElementCount() > StreamWriter.getApiMaxInflightRequests()) {
                        builder.setFlowControlSettings(batchingSettings.getFlowControlSettings().toBuilder().setMaxOutstandingElementCount(Long.valueOf(StreamWriter.getApiMaxInflightRequests())).build());
                    }
                }
                if (batchingSettings.getFlowControlSettings().getMaxOutstandingRequestBytes() == null) {
                    builder.setFlowControlSettings(batchingSettings.getFlowControlSettings().toBuilder().setMaxOutstandingRequestBytes(DEFAULT_FLOW_CONTROL_SETTINGS.getMaxOutstandingRequestBytes()).build());
                } else {
                    Preconditions.checkArgument((batchingSettings.getFlowControlSettings().getMaxOutstandingRequestBytes() > 0L ? 1 : 0) != 0);
                }
                if (batchingSettings.getFlowControlSettings().getLimitExceededBehavior() == null) {
                    builder.setFlowControlSettings(batchingSettings.getFlowControlSettings().toBuilder().setLimitExceededBehavior(DEFAULT_FLOW_CONTROL_SETTINGS.getLimitExceededBehavior()).build());
                } else {
                    Preconditions.checkArgument((batchingSettings.getFlowControlSettings().getLimitExceededBehavior() != FlowController.LimitExceededBehavior.Ignore ? 1 : 0) != 0);
                }
            }
            this.batchingSettings = builder.build();
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            Preconditions.checkNotNull((Object)retrySettings);
            Preconditions.checkArgument((retrySettings.getTotalTimeout().compareTo(MIN_TOTAL_TIMEOUT) >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((retrySettings.getInitialRpcTimeout().compareTo(MIN_RPC_TIMEOUT) >= 0 ? 1 : 0) != 0);
            this.retrySettings = retrySettings;
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public StreamWriter build() throws IllegalArgumentException, IOException, InterruptedException {
            return new StreamWriter(this);
        }
    }

    private static final class AppendRequestAndFutureResponse {
        final SettableApiFuture<Storage.AppendRowsResponse> appendResult = SettableApiFuture.create();
        final Storage.AppendRowsRequest message;
        final int messageSize;

        AppendRequestAndFutureResponse(Storage.AppendRowsRequest message) {
            this.message = message;
            this.messageSize = message.getProtoRows().getSerializedSize();
            if ((long)this.messageSize > StreamWriter.getApiMaxRequestBytes()) {
                throw new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.FAILED_PRECONDITION).withDescription("Message exceeded max size limit: " + StreamWriter.getApiMaxRequestBytes()));
            }
        }
    }

    private static final class InflightBatch {
        final List<AppendRequestAndFutureResponse> inflightRequests;
        final ArrayList<Long> offsetList;
        final long creationTime;
        int attempt;
        int batchSizeBytes;
        long expectedOffset;
        Boolean attachSchema;
        String streamName;

        InflightBatch(List<AppendRequestAndFutureResponse> inflightRequests, int batchSizeBytes, String streamName, Boolean attachSchema) {
            this.inflightRequests = inflightRequests;
            this.offsetList = new ArrayList(inflightRequests.size());
            for (AppendRequestAndFutureResponse request : inflightRequests) {
                if (request.message.getOffset().getValue() > 0L) {
                    this.offsetList.add(new Long(request.message.getOffset().getValue()));
                    continue;
                }
                this.offsetList.add(new Long(-1L));
            }
            this.expectedOffset = this.offsetList.get(0);
            this.attempt = 1;
            this.creationTime = System.currentTimeMillis();
            this.batchSizeBytes = batchSizeBytes;
            this.attachSchema = attachSchema;
            this.streamName = streamName;
        }

        int count() {
            return this.inflightRequests.size();
        }

        int getByteSize() {
            return this.batchSizeBytes;
        }

        long getExpectedOffset() {
            return this.expectedOffset;
        }

        private Storage.AppendRowsRequest getMergedRequest() throws IllegalStateException {
            if (this.inflightRequests.size() == 0) {
                throw new IllegalStateException("Unexpected empty message batch");
            }
            ProtoBufProto.ProtoRows.Builder rowsBuilder = this.inflightRequests.get((int)0).message.getProtoRows().getRows().toBuilder();
            for (int i = 1; i < this.inflightRequests.size(); ++i) {
                rowsBuilder.addAllSerializedRows((Iterable)this.inflightRequests.get((int)i).message.getProtoRows().getRows().getSerializedRowsList());
            }
            Storage.AppendRowsRequest.ProtoData.Builder data = this.inflightRequests.get((int)0).message.getProtoRows().toBuilder().setRows(rowsBuilder.build());
            Storage.AppendRowsRequest.Builder requestBuilder = this.inflightRequests.get((int)0).message.toBuilder();
            if (!this.attachSchema.booleanValue()) {
                data.clearWriterSchema();
                requestBuilder.clearWriteStream();
            } else {
                if (!data.hasWriterSchema()) {
                    throw new IllegalStateException("The first message on the connection must have writer schema set");
                }
                requestBuilder.setWriteStream(this.streamName);
            }
            return requestBuilder.setProtoRows(data.build()).build();
        }

        private void onFailure(Throwable t) {
            for (AppendRequestAndFutureResponse request : this.inflightRequests) {
                request.appendResult.setException(t);
            }
        }

        private void onSuccess(Storage.AppendRowsResponse response) {
            for (int i = 0; i < this.inflightRequests.size(); ++i) {
                Storage.AppendRowsResponse.Builder singleResponse = response.toBuilder();
                if (this.offsetList.get(i) > 0L) {
                    singleResponse.setOffset(this.offsetList.get(i).longValue());
                } else {
                    long actualOffset = response.getOffset();
                    for (int j = 0; j < i; ++j) {
                        actualOffset += (long)this.inflightRequests.get((int)j).message.getProtoRows().getRows().getSerializedRowsCount();
                    }
                    singleResponse.setOffset(actualOffset);
                }
                this.inflightRequests.get((int)i).appendResult.set((Object)singleResponse.build());
            }
        }
    }
}

