/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.reservation.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.reservation.v1.Assignment;
import com.google.cloud.bigquery.reservation.v1.BiReservation;
import com.google.cloud.bigquery.reservation.v1.CapacityCommitment;
import com.google.cloud.bigquery.reservation.v1.CreateAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.CreateCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.CreateReservationRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteReservationRequest;
import com.google.cloud.bigquery.reservation.v1.GetBiReservationRequest;
import com.google.cloud.bigquery.reservation.v1.GetCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.GetReservationRequest;
import com.google.cloud.bigquery.reservation.v1.ListAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.ListAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsRequest;
import com.google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsResponse;
import com.google.cloud.bigquery.reservation.v1.ListReservationsRequest;
import com.google.cloud.bigquery.reservation.v1.ListReservationsResponse;
import com.google.cloud.bigquery.reservation.v1.MergeCapacityCommitmentsRequest;
import com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.Reservation;
import com.google.cloud.bigquery.reservation.v1.ReservationServiceClient;
import com.google.cloud.bigquery.reservation.v1.SearchAllAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.SearchAllAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.SearchAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.SearchAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentResponse;
import com.google.cloud.bigquery.reservation.v1.UpdateAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateBiReservationRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateReservationRequest;
import com.google.cloud.bigquery.reservation.v1.stub.HttpJsonReservationServiceCallableFactory;
import com.google.cloud.bigquery.reservation.v1.stub.ReservationServiceStub;
import com.google.cloud.bigquery.reservation.v1.stub.ReservationServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonReservationServiceStub
extends ReservationServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateReservationRequest, Reservation> createReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/CreateReservation").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/reservations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "reservationId", (Object)request.getReservationId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("reservation", (Message)request.getReservation())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Reservation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListReservationsRequest, ListReservationsResponse> listReservationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/ListReservations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/reservations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListReservationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetReservationRequest, Reservation> getReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/GetReservation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/reservations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Reservation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteReservationRequest, Empty> deleteReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/DeleteReservation").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/reservations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateReservationRequest, Reservation> updateReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/UpdateReservation").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{reservation.name=projects/*/locations/*/reservations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "reservation.name", (Object)request.getReservation().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("reservation", (Message)request.getReservation())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Reservation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateCapacityCommitmentRequest, CapacityCommitment> createCapacityCommitmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/CreateCapacityCommitment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/capacityCommitments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "capacityCommitmentId", (Object)request.getCapacityCommitmentId());
        serializer.putQueryParam(fields, "enforceSingleAdminProjectPerOrg", (Object)request.getEnforceSingleAdminProjectPerOrg());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("capacityCommitment", (Message)request.getCapacityCommitment())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CapacityCommitment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse> listCapacityCommitmentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/ListCapacityCommitments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/capacityCommitments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCapacityCommitmentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetCapacityCommitmentRequest, CapacityCommitment> getCapacityCommitmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/GetCapacityCommitment").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/capacityCommitments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CapacityCommitment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteCapacityCommitmentRequest, Empty> deleteCapacityCommitmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/DeleteCapacityCommitment").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/capacityCommitments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCapacityCommitmentRequest, CapacityCommitment> updateCapacityCommitmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/UpdateCapacityCommitment").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{capacityCommitment.name=projects/*/locations/*/capacityCommitments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "capacityCommitment.name", (Object)request.getCapacityCommitment().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("capacityCommitment", (Message)request.getCapacityCommitment())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CapacityCommitment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SplitCapacityCommitmentRequest, SplitCapacityCommitmentResponse> splitCapacityCommitmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/SplitCapacityCommitment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/capacityCommitments/*}:split", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SplitCapacityCommitmentResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<MergeCapacityCommitmentsRequest, CapacityCommitment> mergeCapacityCommitmentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/MergeCapacityCommitments").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/capacityCommitments:merge", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CapacityCommitment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateAssignmentRequest, Assignment> createAssignmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/CreateAssignment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/reservations/*}/assignments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "assignmentId", (Object)request.getAssignmentId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("assignment", (Message)request.getAssignment())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Assignment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListAssignmentsRequest, ListAssignmentsResponse> listAssignmentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/ListAssignments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/reservations/*}/assignments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListAssignmentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteAssignmentRequest, Empty> deleteAssignmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/DeleteAssignment").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/reservations/*/assignments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchAssignmentsRequest, SearchAssignmentsResponse> searchAssignmentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/SearchAssignments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}:searchAssignments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchAssignmentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse> searchAllAssignmentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/SearchAllAssignments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}:searchAllAssignments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchAllAssignmentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<MoveAssignmentRequest, Assignment> moveAssignmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/MoveAssignment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/reservations/*/assignments/*}:move", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Assignment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateAssignmentRequest, Assignment> updateAssignmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/UpdateAssignment").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{assignment.name=projects/*/locations/*/reservations/*/assignments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "assignment.name", (Object)request.getAssignment().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("assignment", (Message)request.getAssignment())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Assignment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetBiReservationRequest, BiReservation> getBiReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/GetBiReservation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/biReservation}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BiReservation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateBiReservationRequest, BiReservation> updateBiReservationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.reservation.v1.ReservationService/UpdateBiReservation").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{biReservation.name=projects/*/locations/*/biReservation}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "biReservation.name", (Object)request.getBiReservation().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("biReservation", (Message)request.getBiReservation())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BiReservation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateReservationRequest, Reservation> createReservationCallable;
    private final UnaryCallable<ListReservationsRequest, ListReservationsResponse> listReservationsCallable;
    private final UnaryCallable<ListReservationsRequest, ReservationServiceClient.ListReservationsPagedResponse> listReservationsPagedCallable;
    private final UnaryCallable<GetReservationRequest, Reservation> getReservationCallable;
    private final UnaryCallable<DeleteReservationRequest, Empty> deleteReservationCallable;
    private final UnaryCallable<UpdateReservationRequest, Reservation> updateReservationCallable;
    private final UnaryCallable<CreateCapacityCommitmentRequest, CapacityCommitment> createCapacityCommitmentCallable;
    private final UnaryCallable<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse> listCapacityCommitmentsCallable;
    private final UnaryCallable<ListCapacityCommitmentsRequest, ReservationServiceClient.ListCapacityCommitmentsPagedResponse> listCapacityCommitmentsPagedCallable;
    private final UnaryCallable<GetCapacityCommitmentRequest, CapacityCommitment> getCapacityCommitmentCallable;
    private final UnaryCallable<DeleteCapacityCommitmentRequest, Empty> deleteCapacityCommitmentCallable;
    private final UnaryCallable<UpdateCapacityCommitmentRequest, CapacityCommitment> updateCapacityCommitmentCallable;
    private final UnaryCallable<SplitCapacityCommitmentRequest, SplitCapacityCommitmentResponse> splitCapacityCommitmentCallable;
    private final UnaryCallable<MergeCapacityCommitmentsRequest, CapacityCommitment> mergeCapacityCommitmentsCallable;
    private final UnaryCallable<CreateAssignmentRequest, Assignment> createAssignmentCallable;
    private final UnaryCallable<ListAssignmentsRequest, ListAssignmentsResponse> listAssignmentsCallable;
    private final UnaryCallable<ListAssignmentsRequest, ReservationServiceClient.ListAssignmentsPagedResponse> listAssignmentsPagedCallable;
    private final UnaryCallable<DeleteAssignmentRequest, Empty> deleteAssignmentCallable;
    private final UnaryCallable<SearchAssignmentsRequest, SearchAssignmentsResponse> searchAssignmentsCallable;
    private final UnaryCallable<SearchAssignmentsRequest, ReservationServiceClient.SearchAssignmentsPagedResponse> searchAssignmentsPagedCallable;
    private final UnaryCallable<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse> searchAllAssignmentsCallable;
    private final UnaryCallable<SearchAllAssignmentsRequest, ReservationServiceClient.SearchAllAssignmentsPagedResponse> searchAllAssignmentsPagedCallable;
    private final UnaryCallable<MoveAssignmentRequest, Assignment> moveAssignmentCallable;
    private final UnaryCallable<UpdateAssignmentRequest, Assignment> updateAssignmentCallable;
    private final UnaryCallable<GetBiReservationRequest, BiReservation> getBiReservationCallable;
    private final UnaryCallable<UpdateBiReservationRequest, BiReservation> updateBiReservationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonReservationServiceStub create(ReservationServiceStubSettings settings) throws IOException {
        return new HttpJsonReservationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonReservationServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonReservationServiceStub(ReservationServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonReservationServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonReservationServiceStub(ReservationServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonReservationServiceStub(ReservationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonReservationServiceCallableFactory());
    }

    protected HttpJsonReservationServiceStub(ReservationServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createReservationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listReservationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listReservationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getReservationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteReservationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateReservationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createCapacityCommitmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createCapacityCommitmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listCapacityCommitmentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCapacityCommitmentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getCapacityCommitmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCapacityCommitmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteCapacityCommitmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteCapacityCommitmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateCapacityCommitmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCapacityCommitmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings splitCapacityCommitmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(splitCapacityCommitmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings mergeCapacityCommitmentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(mergeCapacityCommitmentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createAssignmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createAssignmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listAssignmentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listAssignmentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteAssignmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteAssignmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings searchAssignmentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchAssignmentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings searchAllAssignmentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchAllAssignmentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings moveAssignmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(moveAssignmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateAssignmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateAssignmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getBiReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBiReservationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateBiReservationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateBiReservationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createReservationCallable = callableFactory.createUnaryCallable(createReservationTransportSettings, settings.createReservationSettings(), clientContext);
        this.listReservationsCallable = callableFactory.createUnaryCallable(listReservationsTransportSettings, settings.listReservationsSettings(), clientContext);
        this.listReservationsPagedCallable = callableFactory.createPagedCallable(listReservationsTransportSettings, settings.listReservationsSettings(), clientContext);
        this.getReservationCallable = callableFactory.createUnaryCallable(getReservationTransportSettings, settings.getReservationSettings(), clientContext);
        this.deleteReservationCallable = callableFactory.createUnaryCallable(deleteReservationTransportSettings, settings.deleteReservationSettings(), clientContext);
        this.updateReservationCallable = callableFactory.createUnaryCallable(updateReservationTransportSettings, settings.updateReservationSettings(), clientContext);
        this.createCapacityCommitmentCallable = callableFactory.createUnaryCallable(createCapacityCommitmentTransportSettings, settings.createCapacityCommitmentSettings(), clientContext);
        this.listCapacityCommitmentsCallable = callableFactory.createUnaryCallable(listCapacityCommitmentsTransportSettings, settings.listCapacityCommitmentsSettings(), clientContext);
        this.listCapacityCommitmentsPagedCallable = callableFactory.createPagedCallable(listCapacityCommitmentsTransportSettings, settings.listCapacityCommitmentsSettings(), clientContext);
        this.getCapacityCommitmentCallable = callableFactory.createUnaryCallable(getCapacityCommitmentTransportSettings, settings.getCapacityCommitmentSettings(), clientContext);
        this.deleteCapacityCommitmentCallable = callableFactory.createUnaryCallable(deleteCapacityCommitmentTransportSettings, settings.deleteCapacityCommitmentSettings(), clientContext);
        this.updateCapacityCommitmentCallable = callableFactory.createUnaryCallable(updateCapacityCommitmentTransportSettings, settings.updateCapacityCommitmentSettings(), clientContext);
        this.splitCapacityCommitmentCallable = callableFactory.createUnaryCallable(splitCapacityCommitmentTransportSettings, settings.splitCapacityCommitmentSettings(), clientContext);
        this.mergeCapacityCommitmentsCallable = callableFactory.createUnaryCallable(mergeCapacityCommitmentsTransportSettings, settings.mergeCapacityCommitmentsSettings(), clientContext);
        this.createAssignmentCallable = callableFactory.createUnaryCallable(createAssignmentTransportSettings, settings.createAssignmentSettings(), clientContext);
        this.listAssignmentsCallable = callableFactory.createUnaryCallable(listAssignmentsTransportSettings, settings.listAssignmentsSettings(), clientContext);
        this.listAssignmentsPagedCallable = callableFactory.createPagedCallable(listAssignmentsTransportSettings, settings.listAssignmentsSettings(), clientContext);
        this.deleteAssignmentCallable = callableFactory.createUnaryCallable(deleteAssignmentTransportSettings, settings.deleteAssignmentSettings(), clientContext);
        this.searchAssignmentsCallable = callableFactory.createUnaryCallable(searchAssignmentsTransportSettings, settings.searchAssignmentsSettings(), clientContext);
        this.searchAssignmentsPagedCallable = callableFactory.createPagedCallable(searchAssignmentsTransportSettings, settings.searchAssignmentsSettings(), clientContext);
        this.searchAllAssignmentsCallable = callableFactory.createUnaryCallable(searchAllAssignmentsTransportSettings, settings.searchAllAssignmentsSettings(), clientContext);
        this.searchAllAssignmentsPagedCallable = callableFactory.createPagedCallable(searchAllAssignmentsTransportSettings, settings.searchAllAssignmentsSettings(), clientContext);
        this.moveAssignmentCallable = callableFactory.createUnaryCallable(moveAssignmentTransportSettings, settings.moveAssignmentSettings(), clientContext);
        this.updateAssignmentCallable = callableFactory.createUnaryCallable(updateAssignmentTransportSettings, settings.updateAssignmentSettings(), clientContext);
        this.getBiReservationCallable = callableFactory.createUnaryCallable(getBiReservationTransportSettings, settings.getBiReservationSettings(), clientContext);
        this.updateBiReservationCallable = callableFactory.createUnaryCallable(updateBiReservationTransportSettings, settings.updateBiReservationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createReservationMethodDescriptor);
        methodDescriptors.add(listReservationsMethodDescriptor);
        methodDescriptors.add(getReservationMethodDescriptor);
        methodDescriptors.add(deleteReservationMethodDescriptor);
        methodDescriptors.add(updateReservationMethodDescriptor);
        methodDescriptors.add(createCapacityCommitmentMethodDescriptor);
        methodDescriptors.add(listCapacityCommitmentsMethodDescriptor);
        methodDescriptors.add(getCapacityCommitmentMethodDescriptor);
        methodDescriptors.add(deleteCapacityCommitmentMethodDescriptor);
        methodDescriptors.add(updateCapacityCommitmentMethodDescriptor);
        methodDescriptors.add(splitCapacityCommitmentMethodDescriptor);
        methodDescriptors.add(mergeCapacityCommitmentsMethodDescriptor);
        methodDescriptors.add(createAssignmentMethodDescriptor);
        methodDescriptors.add(listAssignmentsMethodDescriptor);
        methodDescriptors.add(deleteAssignmentMethodDescriptor);
        methodDescriptors.add(searchAssignmentsMethodDescriptor);
        methodDescriptors.add(searchAllAssignmentsMethodDescriptor);
        methodDescriptors.add(moveAssignmentMethodDescriptor);
        methodDescriptors.add(updateAssignmentMethodDescriptor);
        methodDescriptors.add(getBiReservationMethodDescriptor);
        methodDescriptors.add(updateBiReservationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateReservationRequest, Reservation> createReservationCallable() {
        return this.createReservationCallable;
    }

    @Override
    public UnaryCallable<ListReservationsRequest, ListReservationsResponse> listReservationsCallable() {
        return this.listReservationsCallable;
    }

    @Override
    public UnaryCallable<ListReservationsRequest, ReservationServiceClient.ListReservationsPagedResponse> listReservationsPagedCallable() {
        return this.listReservationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetReservationRequest, Reservation> getReservationCallable() {
        return this.getReservationCallable;
    }

    @Override
    public UnaryCallable<DeleteReservationRequest, Empty> deleteReservationCallable() {
        return this.deleteReservationCallable;
    }

    @Override
    public UnaryCallable<UpdateReservationRequest, Reservation> updateReservationCallable() {
        return this.updateReservationCallable;
    }

    @Override
    public UnaryCallable<CreateCapacityCommitmentRequest, CapacityCommitment> createCapacityCommitmentCallable() {
        return this.createCapacityCommitmentCallable;
    }

    @Override
    public UnaryCallable<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse> listCapacityCommitmentsCallable() {
        return this.listCapacityCommitmentsCallable;
    }

    @Override
    public UnaryCallable<ListCapacityCommitmentsRequest, ReservationServiceClient.ListCapacityCommitmentsPagedResponse> listCapacityCommitmentsPagedCallable() {
        return this.listCapacityCommitmentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetCapacityCommitmentRequest, CapacityCommitment> getCapacityCommitmentCallable() {
        return this.getCapacityCommitmentCallable;
    }

    @Override
    public UnaryCallable<DeleteCapacityCommitmentRequest, Empty> deleteCapacityCommitmentCallable() {
        return this.deleteCapacityCommitmentCallable;
    }

    @Override
    public UnaryCallable<UpdateCapacityCommitmentRequest, CapacityCommitment> updateCapacityCommitmentCallable() {
        return this.updateCapacityCommitmentCallable;
    }

    @Override
    public UnaryCallable<SplitCapacityCommitmentRequest, SplitCapacityCommitmentResponse> splitCapacityCommitmentCallable() {
        return this.splitCapacityCommitmentCallable;
    }

    @Override
    public UnaryCallable<MergeCapacityCommitmentsRequest, CapacityCommitment> mergeCapacityCommitmentsCallable() {
        return this.mergeCapacityCommitmentsCallable;
    }

    @Override
    public UnaryCallable<CreateAssignmentRequest, Assignment> createAssignmentCallable() {
        return this.createAssignmentCallable;
    }

    @Override
    public UnaryCallable<ListAssignmentsRequest, ListAssignmentsResponse> listAssignmentsCallable() {
        return this.listAssignmentsCallable;
    }

    @Override
    public UnaryCallable<ListAssignmentsRequest, ReservationServiceClient.ListAssignmentsPagedResponse> listAssignmentsPagedCallable() {
        return this.listAssignmentsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteAssignmentRequest, Empty> deleteAssignmentCallable() {
        return this.deleteAssignmentCallable;
    }

    @Override
    public UnaryCallable<SearchAssignmentsRequest, SearchAssignmentsResponse> searchAssignmentsCallable() {
        return this.searchAssignmentsCallable;
    }

    @Override
    public UnaryCallable<SearchAssignmentsRequest, ReservationServiceClient.SearchAssignmentsPagedResponse> searchAssignmentsPagedCallable() {
        return this.searchAssignmentsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse> searchAllAssignmentsCallable() {
        return this.searchAllAssignmentsCallable;
    }

    @Override
    public UnaryCallable<SearchAllAssignmentsRequest, ReservationServiceClient.SearchAllAssignmentsPagedResponse> searchAllAssignmentsPagedCallable() {
        return this.searchAllAssignmentsPagedCallable;
    }

    @Override
    public UnaryCallable<MoveAssignmentRequest, Assignment> moveAssignmentCallable() {
        return this.moveAssignmentCallable;
    }

    @Override
    public UnaryCallable<UpdateAssignmentRequest, Assignment> updateAssignmentCallable() {
        return this.updateAssignmentCallable;
    }

    @Override
    public UnaryCallable<GetBiReservationRequest, BiReservation> getBiReservationCallable() {
        return this.getBiReservationCallable;
    }

    @Override
    public UnaryCallable<UpdateBiReservationRequest, BiReservation> updateBiReservationCallable() {
        return this.updateBiReservationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

