/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.migration.v2alpha;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.migration.v2alpha.LocationName;
import com.google.cloud.bigquery.migration.v2alpha.SqlTranslationServiceSettings;
import com.google.cloud.bigquery.migration.v2alpha.TranslateQueryRequest;
import com.google.cloud.bigquery.migration.v2alpha.TranslateQueryResponse;
import com.google.cloud.bigquery.migration.v2alpha.stub.SqlTranslationServiceStub;
import com.google.cloud.bigquery.migration.v2alpha.stub.SqlTranslationServiceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SqlTranslationServiceClient
implements BackgroundResource {
    private final SqlTranslationServiceSettings settings;
    private final SqlTranslationServiceStub stub;

    public static final SqlTranslationServiceClient create() throws IOException {
        return SqlTranslationServiceClient.create(SqlTranslationServiceSettings.newBuilder().build());
    }

    public static final SqlTranslationServiceClient create(SqlTranslationServiceSettings settings) throws IOException {
        return new SqlTranslationServiceClient(settings);
    }

    public static final SqlTranslationServiceClient create(SqlTranslationServiceStub stub) {
        return new SqlTranslationServiceClient(stub);
    }

    protected SqlTranslationServiceClient(SqlTranslationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SqlTranslationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SqlTranslationServiceClient(SqlTranslationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SqlTranslationServiceSettings getSettings() {
        return this.settings;
    }

    public SqlTranslationServiceStub getStub() {
        return this.stub;
    }

    public final TranslateQueryResponse translateQuery(LocationName parent, TranslateQueryRequest.SqlTranslationSourceDialect sourceDialect, String query) {
        TranslateQueryRequest request = TranslateQueryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSourceDialect(sourceDialect).setQuery(query).build();
        return this.translateQuery(request);
    }

    public final TranslateQueryResponse translateQuery(String parent, TranslateQueryRequest.SqlTranslationSourceDialect sourceDialect, String query) {
        TranslateQueryRequest request = TranslateQueryRequest.newBuilder().setParent(parent).setSourceDialect(sourceDialect).setQuery(query).build();
        return this.translateQuery(request);
    }

    public final TranslateQueryResponse translateQuery(TranslateQueryRequest request) {
        return (TranslateQueryResponse)this.translateQueryCallable().call((Object)request);
    }

    public final UnaryCallable<TranslateQueryRequest, TranslateQueryResponse> translateQueryCallable() {
        return this.stub.translateQueryCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

