/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.datatransfer.v1.CheckValidCredsRequest;
import com.google.cloud.bigquery.datatransfer.v1.CheckValidCredsResponse;
import com.google.cloud.bigquery.datatransfer.v1.CreateTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.DataSource;
import com.google.cloud.bigquery.datatransfer.v1.DataSourceNameOneof;
import com.google.cloud.bigquery.datatransfer.v1.DataTransferServiceSettings;
import com.google.cloud.bigquery.datatransfer.v1.DeleteTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.DeleteTransferRunRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetDataSourceRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetTransferRunRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListDataSourcesRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListDataSourcesResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferConfigsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferConfigsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.PagedResponseWrappers;
import com.google.cloud.bigquery.datatransfer.v1.ParentNameOneof;
import com.google.cloud.bigquery.datatransfer.v1.RunNameOneof;
import com.google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfig;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfigNameOneof;
import com.google.cloud.bigquery.datatransfer.v1.TransferRun;
import com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.stub.DataTransferServiceStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataTransferServiceClient
implements BackgroundResource {
    private final DataTransferServiceSettings settings;
    private final DataTransferServiceStub stub;

    public static final DataTransferServiceClient create() throws IOException {
        return DataTransferServiceClient.create(DataTransferServiceSettings.newBuilder().build());
    }

    public static final DataTransferServiceClient create(DataTransferServiceSettings settings) throws IOException {
        return new DataTransferServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DataTransferServiceClient create(DataTransferServiceStub stub) {
        return new DataTransferServiceClient(stub);
    }

    protected DataTransferServiceClient(DataTransferServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DataTransferServiceClient(DataTransferServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataTransferServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DataTransferServiceStub getStub() {
        return this.stub;
    }

    public final DataSource getDataSource(DataSourceNameOneof name) {
        GetDataSourceRequest request = GetDataSourceRequest.newBuilder().setNameWithDataSourceNameOneof(name).build();
        return this.getDataSource(request);
    }

    private final DataSource getDataSource(GetDataSourceRequest request) {
        return (DataSource)this.getDataSourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataSourceRequest, DataSource> getDataSourceCallable() {
        return this.stub.getDataSourceCallable();
    }

    public final PagedResponseWrappers.ListDataSourcesPagedResponse listDataSources(ParentNameOneof parent) {
        ListDataSourcesRequest request = ListDataSourcesRequest.newBuilder().setParentWithParentNameOneof(parent).build();
        return this.listDataSources(request);
    }

    public final PagedResponseWrappers.ListDataSourcesPagedResponse listDataSources(ListDataSourcesRequest request) {
        return (PagedResponseWrappers.ListDataSourcesPagedResponse)((Object)this.listDataSourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataSourcesRequest, PagedResponseWrappers.ListDataSourcesPagedResponse> listDataSourcesPagedCallable() {
        return this.stub.listDataSourcesPagedCallable();
    }

    public final UnaryCallable<ListDataSourcesRequest, ListDataSourcesResponse> listDataSourcesCallable() {
        return this.stub.listDataSourcesCallable();
    }

    public final TransferConfig createTransferConfig(ParentNameOneof parent, TransferConfig transferConfig) {
        CreateTransferConfigRequest request = CreateTransferConfigRequest.newBuilder().setParentWithParentNameOneof(parent).setTransferConfig(transferConfig).build();
        return this.createTransferConfig(request);
    }

    public final TransferConfig createTransferConfig(CreateTransferConfigRequest request) {
        return (TransferConfig)this.createTransferConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTransferConfigRequest, TransferConfig> createTransferConfigCallable() {
        return this.stub.createTransferConfigCallable();
    }

    public final TransferConfig updateTransferConfig(TransferConfig transferConfig, FieldMask updateMask) {
        UpdateTransferConfigRequest request = UpdateTransferConfigRequest.newBuilder().setTransferConfig(transferConfig).setUpdateMask(updateMask).build();
        return this.updateTransferConfig(request);
    }

    public final TransferConfig updateTransferConfig(UpdateTransferConfigRequest request) {
        return (TransferConfig)this.updateTransferConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigCallable() {
        return this.stub.updateTransferConfigCallable();
    }

    public final void deleteTransferConfig(TransferConfigNameOneof name) {
        DeleteTransferConfigRequest request = DeleteTransferConfigRequest.newBuilder().setNameWithTransferConfigNameOneof(name).build();
        this.deleteTransferConfig(request);
    }

    private final void deleteTransferConfig(DeleteTransferConfigRequest request) {
        this.deleteTransferConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTransferConfigRequest, Empty> deleteTransferConfigCallable() {
        return this.stub.deleteTransferConfigCallable();
    }

    public final TransferConfig getTransferConfig(TransferConfigNameOneof name) {
        GetTransferConfigRequest request = GetTransferConfigRequest.newBuilder().setNameWithTransferConfigNameOneof(name).build();
        return this.getTransferConfig(request);
    }

    private final TransferConfig getTransferConfig(GetTransferConfigRequest request) {
        return (TransferConfig)this.getTransferConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetTransferConfigRequest, TransferConfig> getTransferConfigCallable() {
        return this.stub.getTransferConfigCallable();
    }

    public final PagedResponseWrappers.ListTransferConfigsPagedResponse listTransferConfigs(ParentNameOneof parent) {
        ListTransferConfigsRequest request = ListTransferConfigsRequest.newBuilder().setParentWithParentNameOneof(parent).build();
        return this.listTransferConfigs(request);
    }

    public final PagedResponseWrappers.ListTransferConfigsPagedResponse listTransferConfigs(ListTransferConfigsRequest request) {
        return (PagedResponseWrappers.ListTransferConfigsPagedResponse)((Object)this.listTransferConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTransferConfigsRequest, PagedResponseWrappers.ListTransferConfigsPagedResponse> listTransferConfigsPagedCallable() {
        return this.stub.listTransferConfigsPagedCallable();
    }

    public final UnaryCallable<ListTransferConfigsRequest, ListTransferConfigsResponse> listTransferConfigsCallable() {
        return this.stub.listTransferConfigsCallable();
    }

    public final ScheduleTransferRunsResponse scheduleTransferRuns(TransferConfigNameOneof parent, Timestamp startTime, Timestamp endTime) {
        ScheduleTransferRunsRequest request = ScheduleTransferRunsRequest.newBuilder().setParentWithTransferConfigNameOneof(parent).setStartTime(startTime).setEndTime(endTime).build();
        return this.scheduleTransferRuns(request);
    }

    public final ScheduleTransferRunsResponse scheduleTransferRuns(ScheduleTransferRunsRequest request) {
        return (ScheduleTransferRunsResponse)this.scheduleTransferRunsCallable().call((Object)request);
    }

    public final UnaryCallable<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsCallable() {
        return this.stub.scheduleTransferRunsCallable();
    }

    public final TransferRun getTransferRun(RunNameOneof name) {
        GetTransferRunRequest request = GetTransferRunRequest.newBuilder().setNameWithRunNameOneof(name).build();
        return this.getTransferRun(request);
    }

    private final TransferRun getTransferRun(GetTransferRunRequest request) {
        return (TransferRun)this.getTransferRunCallable().call((Object)request);
    }

    public final UnaryCallable<GetTransferRunRequest, TransferRun> getTransferRunCallable() {
        return this.stub.getTransferRunCallable();
    }

    public final void deleteTransferRun(RunNameOneof name) {
        DeleteTransferRunRequest request = DeleteTransferRunRequest.newBuilder().setNameWithRunNameOneof(name).build();
        this.deleteTransferRun(request);
    }

    private final void deleteTransferRun(DeleteTransferRunRequest request) {
        this.deleteTransferRunCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTransferRunRequest, Empty> deleteTransferRunCallable() {
        return this.stub.deleteTransferRunCallable();
    }

    public final PagedResponseWrappers.ListTransferRunsPagedResponse listTransferRuns(TransferConfigNameOneof parent) {
        ListTransferRunsRequest request = ListTransferRunsRequest.newBuilder().setParentWithTransferConfigNameOneof(parent).build();
        return this.listTransferRuns(request);
    }

    public final PagedResponseWrappers.ListTransferRunsPagedResponse listTransferRuns(ListTransferRunsRequest request) {
        return (PagedResponseWrappers.ListTransferRunsPagedResponse)((Object)this.listTransferRunsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTransferRunsRequest, PagedResponseWrappers.ListTransferRunsPagedResponse> listTransferRunsPagedCallable() {
        return this.stub.listTransferRunsPagedCallable();
    }

    public final UnaryCallable<ListTransferRunsRequest, ListTransferRunsResponse> listTransferRunsCallable() {
        return this.stub.listTransferRunsCallable();
    }

    public final PagedResponseWrappers.ListTransferLogsPagedResponse listTransferLogs(RunNameOneof parent) {
        ListTransferLogsRequest request = ListTransferLogsRequest.newBuilder().setParentWithRunNameOneof(parent).build();
        return this.listTransferLogs(request);
    }

    public final PagedResponseWrappers.ListTransferLogsPagedResponse listTransferLogs(ListTransferLogsRequest request) {
        return (PagedResponseWrappers.ListTransferLogsPagedResponse)((Object)this.listTransferLogsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTransferLogsRequest, PagedResponseWrappers.ListTransferLogsPagedResponse> listTransferLogsPagedCallable() {
        return this.stub.listTransferLogsPagedCallable();
    }

    public final UnaryCallable<ListTransferLogsRequest, ListTransferLogsResponse> listTransferLogsCallable() {
        return this.stub.listTransferLogsCallable();
    }

    public final CheckValidCredsResponse checkValidCreds(DataSourceNameOneof name) {
        CheckValidCredsRequest request = CheckValidCredsRequest.newBuilder().setNameWithDataSourceNameOneof(name).build();
        return this.checkValidCreds(request);
    }

    private final CheckValidCredsResponse checkValidCreds(CheckValidCredsRequest request) {
        return (CheckValidCredsResponse)this.checkValidCredsCallable().call((Object)request);
    }

    public final UnaryCallable<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsCallable() {
        return this.stub.checkValidCredsCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

