/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.datatransfer.v1.CheckValidCredsRequest;
import com.google.cloud.bigquery.datatransfer.v1.CheckValidCredsResponse;
import com.google.cloud.bigquery.datatransfer.v1.CreateTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.DataSource;
import com.google.cloud.bigquery.datatransfer.v1.DataTransferServiceClient;
import com.google.cloud.bigquery.datatransfer.v1.DeleteTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.DeleteTransferRunRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetDataSourceRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetTransferRunRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListDataSourcesRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListDataSourcesResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferConfigsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferConfigsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfig;
import com.google.cloud.bigquery.datatransfer.v1.TransferMessage;
import com.google.cloud.bigquery.datatransfer.v1.TransferRun;
import com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.stub.DataTransferServiceStub;
import com.google.cloud.bigquery.datatransfer.v1.stub.GrpcDataTransferServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DataTransferServiceStubSettings
extends StubSettings<DataTransferServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetDataSourceRequest, DataSource> getDataSourceSettings;
    private final PagedCallSettings<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse> listDataSourcesSettings;
    private final UnaryCallSettings<CreateTransferConfigRequest, TransferConfig> createTransferConfigSettings;
    private final UnaryCallSettings<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigSettings;
    private final UnaryCallSettings<DeleteTransferConfigRequest, Empty> deleteTransferConfigSettings;
    private final UnaryCallSettings<GetTransferConfigRequest, TransferConfig> getTransferConfigSettings;
    private final PagedCallSettings<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse> listTransferConfigsSettings;
    private final UnaryCallSettings<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsSettings;
    private final UnaryCallSettings<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsSettings;
    private final UnaryCallSettings<GetTransferRunRequest, TransferRun> getTransferRunSettings;
    private final UnaryCallSettings<DeleteTransferRunRequest, Empty> deleteTransferRunSettings;
    private final PagedCallSettings<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse> listTransferRunsSettings;
    private final PagedCallSettings<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse> listTransferLogsSettings;
    private final UnaryCallSettings<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsSettings;
    private static final PagedListDescriptor<ListDataSourcesRequest, ListDataSourcesResponse, DataSource> LIST_DATA_SOURCES_PAGE_STR_DESC = new PagedListDescriptor<ListDataSourcesRequest, ListDataSourcesResponse, DataSource>(){

        public String emptyToken() {
            return "";
        }

        public ListDataSourcesRequest injectToken(ListDataSourcesRequest payload, String token) {
            return ListDataSourcesRequest.newBuilder((ListDataSourcesRequest)payload).setPageToken(token).build();
        }

        public ListDataSourcesRequest injectPageSize(ListDataSourcesRequest payload, int pageSize) {
            return ListDataSourcesRequest.newBuilder((ListDataSourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataSourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataSourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataSource> extractResources(ListDataSourcesResponse payload) {
            return payload.getDataSourcesList() != null ? payload.getDataSourcesList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig> LIST_TRANSFER_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListTransferConfigsRequest injectToken(ListTransferConfigsRequest payload, String token) {
            return ListTransferConfigsRequest.newBuilder((ListTransferConfigsRequest)payload).setPageToken(token).build();
        }

        public ListTransferConfigsRequest injectPageSize(ListTransferConfigsRequest payload, int pageSize) {
            return ListTransferConfigsRequest.newBuilder((ListTransferConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTransferConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTransferConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TransferConfig> extractResources(ListTransferConfigsResponse payload) {
            return payload.getTransferConfigsList() != null ? payload.getTransferConfigsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun> LIST_TRANSFER_RUNS_PAGE_STR_DESC = new PagedListDescriptor<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun>(){

        public String emptyToken() {
            return "";
        }

        public ListTransferRunsRequest injectToken(ListTransferRunsRequest payload, String token) {
            return ListTransferRunsRequest.newBuilder((ListTransferRunsRequest)payload).setPageToken(token).build();
        }

        public ListTransferRunsRequest injectPageSize(ListTransferRunsRequest payload, int pageSize) {
            return ListTransferRunsRequest.newBuilder((ListTransferRunsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTransferRunsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTransferRunsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TransferRun> extractResources(ListTransferRunsResponse payload) {
            return payload.getTransferRunsList() != null ? payload.getTransferRunsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage> LIST_TRANSFER_LOGS_PAGE_STR_DESC = new PagedListDescriptor<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage>(){

        public String emptyToken() {
            return "";
        }

        public ListTransferLogsRequest injectToken(ListTransferLogsRequest payload, String token) {
            return ListTransferLogsRequest.newBuilder((ListTransferLogsRequest)payload).setPageToken(token).build();
        }

        public ListTransferLogsRequest injectPageSize(ListTransferLogsRequest payload, int pageSize) {
            return ListTransferLogsRequest.newBuilder((ListTransferLogsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTransferLogsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTransferLogsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TransferMessage> extractResources(ListTransferLogsResponse payload) {
            return payload.getTransferMessagesList() != null ? payload.getTransferMessagesList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse> LIST_DATA_SOURCES_PAGE_STR_FACT = new PagedListResponseFactory<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListDataSourcesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataSourcesRequest, ListDataSourcesResponse> callable, ListDataSourcesRequest request, ApiCallContext context, ApiFuture<ListDataSourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_SOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListDataSourcesPagedResponse.createAsync((PageContext<ListDataSourcesRequest, ListDataSourcesResponse, DataSource>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse> LIST_TRANSFER_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListTransferConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTransferConfigsRequest, ListTransferConfigsResponse> callable, ListTransferConfigsRequest request, ApiCallContext context, ApiFuture<ListTransferConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRANSFER_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListTransferConfigsPagedResponse.createAsync((PageContext<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse> LIST_TRANSFER_RUNS_PAGE_STR_FACT = new PagedListResponseFactory<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListTransferRunsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTransferRunsRequest, ListTransferRunsResponse> callable, ListTransferRunsRequest request, ApiCallContext context, ApiFuture<ListTransferRunsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRANSFER_RUNS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListTransferRunsPagedResponse.createAsync((PageContext<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse> LIST_TRANSFER_LOGS_PAGE_STR_FACT = new PagedListResponseFactory<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListTransferLogsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTransferLogsRequest, ListTransferLogsResponse> callable, ListTransferLogsRequest request, ApiCallContext context, ApiFuture<ListTransferLogsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRANSFER_LOGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListTransferLogsPagedResponse.createAsync((PageContext<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetDataSourceRequest, DataSource> getDataSourceSettings() {
        return this.getDataSourceSettings;
    }

    public PagedCallSettings<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse> listDataSourcesSettings() {
        return this.listDataSourcesSettings;
    }

    public UnaryCallSettings<CreateTransferConfigRequest, TransferConfig> createTransferConfigSettings() {
        return this.createTransferConfigSettings;
    }

    public UnaryCallSettings<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigSettings() {
        return this.updateTransferConfigSettings;
    }

    public UnaryCallSettings<DeleteTransferConfigRequest, Empty> deleteTransferConfigSettings() {
        return this.deleteTransferConfigSettings;
    }

    public UnaryCallSettings<GetTransferConfigRequest, TransferConfig> getTransferConfigSettings() {
        return this.getTransferConfigSettings;
    }

    public PagedCallSettings<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse> listTransferConfigsSettings() {
        return this.listTransferConfigsSettings;
    }

    public UnaryCallSettings<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsSettings() {
        return this.scheduleTransferRunsSettings;
    }

    public UnaryCallSettings<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsSettings() {
        return this.startManualTransferRunsSettings;
    }

    public UnaryCallSettings<GetTransferRunRequest, TransferRun> getTransferRunSettings() {
        return this.getTransferRunSettings;
    }

    public UnaryCallSettings<DeleteTransferRunRequest, Empty> deleteTransferRunSettings() {
        return this.deleteTransferRunSettings;
    }

    public PagedCallSettings<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse> listTransferRunsSettings() {
        return this.listTransferRunsSettings;
    }

    public PagedCallSettings<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse> listTransferLogsSettings() {
        return this.listTransferLogsSettings;
    }

    public UnaryCallSettings<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsSettings() {
        return this.checkValidCredsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DataTransferServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataTransferServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "bigquerydatatransfer.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataTransferServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataTransferServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataTransferServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getDataSourceSettings = settingsBuilder.getDataSourceSettings().build();
        this.listDataSourcesSettings = settingsBuilder.listDataSourcesSettings().build();
        this.createTransferConfigSettings = settingsBuilder.createTransferConfigSettings().build();
        this.updateTransferConfigSettings = settingsBuilder.updateTransferConfigSettings().build();
        this.deleteTransferConfigSettings = settingsBuilder.deleteTransferConfigSettings().build();
        this.getTransferConfigSettings = settingsBuilder.getTransferConfigSettings().build();
        this.listTransferConfigsSettings = settingsBuilder.listTransferConfigsSettings().build();
        this.scheduleTransferRunsSettings = settingsBuilder.scheduleTransferRunsSettings().build();
        this.startManualTransferRunsSettings = settingsBuilder.startManualTransferRunsSettings().build();
        this.getTransferRunSettings = settingsBuilder.getTransferRunSettings().build();
        this.deleteTransferRunSettings = settingsBuilder.deleteTransferRunSettings().build();
        this.listTransferRunsSettings = settingsBuilder.listTransferRunsSettings().build();
        this.listTransferLogsSettings = settingsBuilder.listTransferLogsSettings().build();
        this.checkValidCredsSettings = settingsBuilder.checkValidCredsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataTransferServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetDataSourceRequest, DataSource> getDataSourceSettings;
        private final PagedCallSettings.Builder<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse> listDataSourcesSettings;
        private final UnaryCallSettings.Builder<CreateTransferConfigRequest, TransferConfig> createTransferConfigSettings;
        private final UnaryCallSettings.Builder<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigSettings;
        private final UnaryCallSettings.Builder<DeleteTransferConfigRequest, Empty> deleteTransferConfigSettings;
        private final UnaryCallSettings.Builder<GetTransferConfigRequest, TransferConfig> getTransferConfigSettings;
        private final PagedCallSettings.Builder<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse> listTransferConfigsSettings;
        private final UnaryCallSettings.Builder<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsSettings;
        private final UnaryCallSettings.Builder<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsSettings;
        private final UnaryCallSettings.Builder<GetTransferRunRequest, TransferRun> getTransferRunSettings;
        private final UnaryCallSettings.Builder<DeleteTransferRunRequest, Empty> deleteTransferRunSettings;
        private final PagedCallSettings.Builder<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse> listTransferRunsSettings;
        private final PagedCallSettings.Builder<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse> listTransferLogsSettings;
        private final UnaryCallSettings.Builder<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getDataSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDataSourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_SOURCES_PAGE_STR_FACT);
            this.createTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTransferConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRANSFER_CONFIGS_PAGE_STR_FACT);
            this.scheduleTransferRunsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startManualTransferRunsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTransferRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTransferRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTransferRunsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRANSFER_RUNS_PAGE_STR_FACT);
            this.listTransferLogsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRANSFER_LOGS_PAGE_STR_FACT);
            this.checkValidCredsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDataSourceSettings, this.listDataSourcesSettings, this.createTransferConfigSettings, this.updateTransferConfigSettings, this.deleteTransferConfigSettings, this.getTransferConfigSettings, this.listTransferConfigsSettings, this.scheduleTransferRunsSettings, this.startManualTransferRunsSettings, this.getTransferRunSettings, this.deleteTransferRunSettings, this.listTransferRunsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listTransferLogsSettings, this.checkValidCredsSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataTransferServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataTransferServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataTransferServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataTransferServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getDataSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listDataSourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTransferConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.scheduleTransferRunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.startManualTransferRunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTransferRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteTransferRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTransferRunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTransferLogsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.checkValidCredsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(DataTransferServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getDataSourceSettings = settings.getDataSourceSettings.toBuilder();
            this.listDataSourcesSettings = settings.listDataSourcesSettings.toBuilder();
            this.createTransferConfigSettings = settings.createTransferConfigSettings.toBuilder();
            this.updateTransferConfigSettings = settings.updateTransferConfigSettings.toBuilder();
            this.deleteTransferConfigSettings = settings.deleteTransferConfigSettings.toBuilder();
            this.getTransferConfigSettings = settings.getTransferConfigSettings.toBuilder();
            this.listTransferConfigsSettings = settings.listTransferConfigsSettings.toBuilder();
            this.scheduleTransferRunsSettings = settings.scheduleTransferRunsSettings.toBuilder();
            this.startManualTransferRunsSettings = settings.startManualTransferRunsSettings.toBuilder();
            this.getTransferRunSettings = settings.getTransferRunSettings.toBuilder();
            this.deleteTransferRunSettings = settings.deleteTransferRunSettings.toBuilder();
            this.listTransferRunsSettings = settings.listTransferRunsSettings.toBuilder();
            this.listTransferLogsSettings = settings.listTransferLogsSettings.toBuilder();
            this.checkValidCredsSettings = settings.checkValidCredsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDataSourceSettings, this.listDataSourcesSettings, this.createTransferConfigSettings, this.updateTransferConfigSettings, this.deleteTransferConfigSettings, this.getTransferConfigSettings, this.listTransferConfigsSettings, this.scheduleTransferRunsSettings, this.startManualTransferRunsSettings, this.getTransferRunSettings, this.deleteTransferRunSettings, this.listTransferRunsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listTransferLogsSettings, this.checkValidCredsSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetDataSourceRequest, DataSource> getDataSourceSettings() {
            return this.getDataSourceSettings;
        }

        public PagedCallSettings.Builder<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse> listDataSourcesSettings() {
            return this.listDataSourcesSettings;
        }

        public UnaryCallSettings.Builder<CreateTransferConfigRequest, TransferConfig> createTransferConfigSettings() {
            return this.createTransferConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigSettings() {
            return this.updateTransferConfigSettings;
        }

        public UnaryCallSettings.Builder<DeleteTransferConfigRequest, Empty> deleteTransferConfigSettings() {
            return this.deleteTransferConfigSettings;
        }

        public UnaryCallSettings.Builder<GetTransferConfigRequest, TransferConfig> getTransferConfigSettings() {
            return this.getTransferConfigSettings;
        }

        public PagedCallSettings.Builder<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse> listTransferConfigsSettings() {
            return this.listTransferConfigsSettings;
        }

        public UnaryCallSettings.Builder<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsSettings() {
            return this.scheduleTransferRunsSettings;
        }

        public UnaryCallSettings.Builder<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsSettings() {
            return this.startManualTransferRunsSettings;
        }

        public UnaryCallSettings.Builder<GetTransferRunRequest, TransferRun> getTransferRunSettings() {
            return this.getTransferRunSettings;
        }

        public UnaryCallSettings.Builder<DeleteTransferRunRequest, Empty> deleteTransferRunSettings() {
            return this.deleteTransferRunSettings;
        }

        public PagedCallSettings.Builder<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse> listTransferRunsSettings() {
            return this.listTransferRunsSettings;
        }

        public PagedCallSettings.Builder<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse> listTransferLogsSettings() {
            return this.listTransferLogsSettings;
        }

        public UnaryCallSettings.Builder<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsSettings() {
            return this.checkValidCredsSettings;
        }

        public DataTransferServiceStubSettings build() throws IOException {
            return new DataTransferServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

