/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigtableOptions;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatastoreBackupOptions;
import com.google.cloud.bigquery.GoogleSheetsOptions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public class FormatOptions
implements Serializable {
    static final String CSV = "CSV";
    static final String JSON = "NEWLINE_DELIMITED_JSON";
    static final String BIGTABLE = "BIGTABLE";
    static final String DATASTORE_BACKUP = "DATASTORE_BACKUP";
    static final String AVRO = "AVRO";
    static final String GOOGLE_SHEETS = "GOOGLE_SHEETS";
    static final String PARQUET = "PARQUET";
    static final String ORC = "ORC";
    private static final long serialVersionUID = -443376052020423691L;
    private final String type;

    FormatOptions(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("format", (Object)this.type).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(FormatOptions.class) && Objects.equals(this.type, ((FormatOptions)obj).getType());
    }

    public static CsvOptions csv() {
        return CsvOptions.newBuilder().build();
    }

    public static FormatOptions json() {
        return new FormatOptions(JSON);
    }

    public static FormatOptions datastoreBackup() {
        return DatastoreBackupOptions.newBuilder().build();
    }

    public static FormatOptions avro() {
        return new FormatOptions(AVRO);
    }

    public static FormatOptions bigtable() {
        return BigtableOptions.newBuilder().build();
    }

    public static FormatOptions googleSheets() {
        return GoogleSheetsOptions.newBuilder().build();
    }

    public static FormatOptions parquet() {
        return new FormatOptions(PARQUET);
    }

    public static FormatOptions orc() {
        return new FormatOptions(ORC);
    }

    public static FormatOptions of(String format) {
        if (((String)Preconditions.checkNotNull((Object)format)).equals(CSV)) {
            return FormatOptions.csv();
        }
        if (format.equals(DATASTORE_BACKUP)) {
            return FormatOptions.datastoreBackup();
        }
        if (format.equals(GOOGLE_SHEETS)) {
            return FormatOptions.googleSheets();
        }
        if (format.equals(BIGTABLE)) {
            return FormatOptions.bigtable();
        }
        return new FormatOptions(format);
    }
}

