/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.InternalApi;
import com.google.api.gax.paging.Page;
import com.google.cloud.FieldSelector;
import com.google.cloud.RetryOption;
import com.google.cloud.Service;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobException;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.Option;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public interface BigQuery
extends Service<BigQueryOptions> {
    public Dataset create(DatasetInfo var1, DatasetOption ... var2);

    public Table create(TableInfo var1, TableOption ... var2);

    public Job create(JobInfo var1, JobOption ... var2);

    public Dataset getDataset(String var1, DatasetOption ... var2);

    public Dataset getDataset(DatasetId var1, DatasetOption ... var2);

    public Page<Dataset> listDatasets(DatasetListOption ... var1);

    public Page<Dataset> listDatasets(String var1, DatasetListOption ... var2);

    public boolean delete(String var1, DatasetDeleteOption ... var2);

    public boolean delete(DatasetId var1, DatasetDeleteOption ... var2);

    public boolean delete(String var1, String var2);

    public boolean delete(TableId var1);

    public Dataset update(DatasetInfo var1, DatasetOption ... var2);

    public Table update(TableInfo var1, TableOption ... var2);

    public Table getTable(String var1, String var2, TableOption ... var3);

    public Table getTable(TableId var1, TableOption ... var2);

    public Page<Table> listTables(String var1, TableListOption ... var2);

    public Page<Table> listTables(DatasetId var1, TableListOption ... var2);

    public InsertAllResponse insertAll(InsertAllRequest var1);

    public TableResult listTableData(String var1, String var2, TableDataListOption ... var3);

    public TableResult listTableData(TableId var1, TableDataListOption ... var2);

    public TableResult listTableData(String var1, String var2, Schema var3, TableDataListOption ... var4);

    public TableResult listTableData(TableId var1, Schema var2, TableDataListOption ... var3);

    public Job getJob(String var1, JobOption ... var2);

    public Job getJob(JobId var1, JobOption ... var2);

    public Page<Job> listJobs(JobListOption ... var1);

    public boolean cancel(String var1);

    public boolean cancel(JobId var1);

    public TableResult query(QueryJobConfiguration var1, JobOption ... var2) throws InterruptedException, JobException;

    public TableResult query(QueryJobConfiguration var1, JobId var2, JobOption ... var3) throws InterruptedException, JobException;

    @InternalApi
    public QueryResponse getQueryResults(JobId var1, QueryResultsOption ... var2);

    public TableDataWriteChannel writer(WriteChannelConfiguration var1);

    public TableDataWriteChannel writer(JobId var1, WriteChannelConfiguration var2);

    public static class QueryOption
    implements Serializable {
        private static final long serialVersionUID = 6206193419355824689L;
        private final Object option;

        private QueryOption(Object option) {
            this.option = option;
        }

        public QueryResultsOption getQueryResultsOption() {
            return this.option instanceof QueryResultsOption ? (QueryResultsOption)this.option : null;
        }

        public RetryOption getRetryOption() {
            return this.option instanceof RetryOption ? (RetryOption)this.option : null;
        }

        static QueryResultsOption[] filterQueryResultsOptions(QueryOption ... options) {
            ArrayList<QueryResultsOption> queryResultOptions = new ArrayList<QueryResultsOption>(options.length);
            for (QueryOption opt : options) {
                if (opt.getQueryResultsOption() == null) continue;
                queryResultOptions.add(opt.getQueryResultsOption());
            }
            return queryResultOptions.toArray(new QueryResultsOption[queryResultOptions.size()]);
        }

        static RetryOption[] filterRetryOptions(QueryOption ... options) {
            ArrayList<RetryOption> retryOptions = new ArrayList<RetryOption>(options.length);
            for (QueryOption opt : options) {
                if (opt.getRetryOption() == null) continue;
                retryOptions.add(opt.getRetryOption());
            }
            return retryOptions.toArray(new RetryOption[retryOptions.size()]);
        }

        public static QueryOption of(QueryResultsOption resultsOption) {
            return new QueryOption(resultsOption);
        }

        public static QueryOption of(RetryOption waitOption) {
            return new QueryOption(waitOption);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryOption that = (QueryOption)o;
            return this.option != null ? this.option.equals(that.option) : that.option == null;
        }

        public int hashCode() {
            return this.option != null ? this.option.hashCode() : 0;
        }
    }

    public static class QueryResultsOption
    extends Option {
        private static final long serialVersionUID = 3788898503226985525L;

        private QueryResultsOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static QueryResultsOption pageSize(long pageSize) {
            Preconditions.checkArgument((pageSize >= 0L ? 1 : 0) != 0);
            return new QueryResultsOption(BigQueryRpc.Option.MAX_RESULTS, pageSize);
        }

        public static QueryResultsOption pageToken(String pageToken) {
            return new QueryResultsOption(BigQueryRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static QueryResultsOption startIndex(long startIndex) {
            Preconditions.checkArgument((startIndex >= 0L ? 1 : 0) != 0);
            return new QueryResultsOption(BigQueryRpc.Option.START_INDEX, startIndex);
        }

        public static QueryResultsOption maxWaitTime(long maxWaitTime) {
            Preconditions.checkArgument((maxWaitTime >= 0L ? 1 : 0) != 0);
            return new QueryResultsOption(BigQueryRpc.Option.TIMEOUT, maxWaitTime);
        }
    }

    public static class JobOption
    extends Option {
        private static final long serialVersionUID = -3111736712316353665L;

        private JobOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static JobOption fields(JobField ... fields) {
            return new JobOption(BigQueryRpc.Option.FIELDS, FieldSelector.Helper.selector(JobField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class JobListOption
    extends Option {
        private static final long serialVersionUID = -8207122131226481423L;

        private JobListOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static JobListOption allUsers() {
            return new JobListOption(BigQueryRpc.Option.ALL_USERS, true);
        }

        public static JobListOption stateFilter(JobStatus.State ... stateFilters) {
            List stringFilters = Lists.transform((List)ImmutableList.copyOf((Object[])stateFilters), (Function)new Function<JobStatus.State, String>(){

                public String apply(JobStatus.State state) {
                    return state.name().toLowerCase();
                }
            });
            return new JobListOption(BigQueryRpc.Option.STATE_FILTER, stringFilters);
        }

        public static JobListOption pageSize(long pageSize) {
            Preconditions.checkArgument((pageSize >= 0L ? 1 : 0) != 0);
            return new JobListOption(BigQueryRpc.Option.MAX_RESULTS, pageSize);
        }

        public static JobListOption pageToken(String pageToken) {
            return new JobListOption(BigQueryRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static JobListOption fields(JobField ... fields) {
            return new JobListOption(BigQueryRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"jobs", JobField.REQUIRED_FIELDS, (FieldSelector[])fields, (String[])new String[]{"state", "errorResult"}));
        }
    }

    public static class TableDataListOption
    extends Option {
        private static final long serialVersionUID = 8488823381738864434L;

        private TableDataListOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static TableDataListOption pageSize(long pageSize) {
            Preconditions.checkArgument((pageSize >= 0L ? 1 : 0) != 0);
            return new TableDataListOption(BigQueryRpc.Option.MAX_RESULTS, pageSize);
        }

        public static TableDataListOption pageToken(String pageToken) {
            return new TableDataListOption(BigQueryRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static TableDataListOption startIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0);
            return new TableDataListOption(BigQueryRpc.Option.START_INDEX, index);
        }
    }

    public static class TableOption
    extends Option {
        private static final long serialVersionUID = -1723870134095936772L;

        private TableOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static TableOption fields(TableField ... fields) {
            return new TableOption(BigQueryRpc.Option.FIELDS, FieldSelector.Helper.selector(TableField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class TableListOption
    extends Option {
        private static final long serialVersionUID = 8660294969063340498L;

        private TableListOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static TableListOption pageSize(long pageSize) {
            Preconditions.checkArgument((pageSize >= 0L ? 1 : 0) != 0);
            return new TableListOption(BigQueryRpc.Option.MAX_RESULTS, pageSize);
        }

        public static TableListOption pageToken(String pageToken) {
            return new TableListOption(BigQueryRpc.Option.PAGE_TOKEN, pageToken);
        }
    }

    public static class DatasetDeleteOption
    extends Option {
        private static final long serialVersionUID = -7166083569900951337L;

        private DatasetDeleteOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static DatasetDeleteOption deleteContents() {
            return new DatasetDeleteOption(BigQueryRpc.Option.DELETE_CONTENTS, true);
        }
    }

    public static class DatasetOption
    extends Option {
        private static final long serialVersionUID = 1674133909259913250L;

        private DatasetOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static DatasetOption fields(DatasetField ... fields) {
            return new DatasetOption(BigQueryRpc.Option.FIELDS, FieldSelector.Helper.selector(DatasetField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class DatasetListOption
    extends Option {
        private static final long serialVersionUID = 8660294969063340498L;

        private DatasetListOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static DatasetListOption pageSize(long pageSize) {
            return new DatasetListOption(BigQueryRpc.Option.MAX_RESULTS, pageSize);
        }

        public static DatasetListOption pageToken(String pageToken) {
            return new DatasetListOption(BigQueryRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static DatasetListOption all() {
            return new DatasetListOption(BigQueryRpc.Option.ALL_DATASETS, true);
        }
    }

    public static enum JobField implements FieldSelector
    {
        CONFIGURATION("configuration"),
        ETAG("etag"),
        ID("id"),
        JOB_REFERENCE("jobReference"),
        SELF_LINK("selfLink"),
        STATISTICS("statistics"),
        STATUS("status"),
        USER_EMAIL("user_email");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private JobField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)JOB_REFERENCE), (Object)((Object)CONFIGURATION));
        }
    }

    public static enum TableField implements FieldSelector
    {
        CREATION_TIME("creationTime"),
        DESCRIPTION("description"),
        ETAG("etag"),
        EXPIRATION_TIME("expirationTime"),
        EXTERNAL_DATA_CONFIGURATION("externalDataConfiguration"),
        FRIENDLY_NAME("friendlyName"),
        ID("id"),
        LABELS("labels"),
        LAST_MODIFIED_TIME("lastModifiedTime"),
        LOCATION("location"),
        NUM_BYTES("numBytes"),
        NUM_ROWS("numRows"),
        SCHEMA("schema"),
        SELF_LINK("selfLink"),
        STREAMING_BUFFER("streamingBuffer"),
        TABLE_REFERENCE("tableReference"),
        TIME_PARTITIONING("timePartitioning"),
        TYPE("type"),
        VIEW("view");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private TableField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)TABLE_REFERENCE), (Object)((Object)TYPE));
        }
    }

    public static enum DatasetField implements FieldSelector
    {
        ACCESS("access"),
        CREATION_TIME("creationTime"),
        DATASET_REFERENCE("datasetReference"),
        DEFAULT_TABLE_EXPIRATION_MS("defaultTableExpirationMsS"),
        DESCRIPTION("description"),
        ETAG("etag"),
        FRIENDLY_NAME("friendlyName"),
        ID("id"),
        LABELS("labels"),
        LAST_MODIFIED_TIME("lastModifiedTime"),
        LOCATION("location"),
        SELF_LINK("selfLink");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private DatasetField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)DATASET_REFERENCE));
        }
    }
}

