/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.client.util.Strings;
import com.google.api.core.BetaApi;
import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.Labels;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;

public class TableInfo
implements Serializable {
    static final Function<Table, TableInfo> FROM_PB_FUNCTION = new Function<Table, TableInfo>(){

        public TableInfo apply(Table pb) {
            return TableInfo.fromPb(pb);
        }
    };
    static final Function<TableInfo, Table> TO_PB_FUNCTION = new Function<TableInfo, Table>(){

        public Table apply(TableInfo tableInfo) {
            return tableInfo.toPb();
        }
    };
    private static final long serialVersionUID = 609769795097719407L;
    private final String etag;
    private final String generatedId;
    private final String selfLink;
    private final TableId tableId;
    private final String friendlyName;
    private final String description;
    private final Long creationTime;
    private final Long expirationTime;
    private final Long lastModifiedTime;
    private final Long numBytes;
    private final BigInteger numRows;
    private final TableDefinition definition;
    private final EncryptionConfiguration encryptionConfiguration;
    private final Labels labels;

    TableInfo(BuilderImpl builder) {
        this.tableId = (TableId)Preconditions.checkNotNull((Object)builder.tableId);
        this.etag = builder.etag;
        this.generatedId = builder.generatedId;
        this.selfLink = builder.selfLink;
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.numBytes = builder.numBytes;
        this.numRows = builder.numRows;
        this.definition = builder.definition;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.labels = builder.labels;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public String getFriendlyName() {
        return Data.isNull((Object)this.friendlyName) ? null : this.friendlyName;
    }

    public String getDescription() {
        return Data.isNull((Object)this.description) ? null : this.description;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public Long getExpirationTime() {
        return Data.isNull((Object)this.expirationTime) ? null : this.expirationTime;
    }

    public Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public <T extends TableDefinition> T getDefinition() {
        return (T)this.definition;
    }

    public Long getNumBytes() {
        return this.numBytes;
    }

    public BigInteger getNumRows() {
        return this.numRows;
    }

    @BetaApi
    public Map<String, String> getLabels() {
        return this.labels.userMap();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", (Object)this.tableId).add("etag", (Object)this.etag).add("generatedId", (Object)this.generatedId).add("selfLink", (Object)this.selfLink).add("friendlyName", (Object)this.friendlyName).add("description", (Object)this.description).add("expirationTime", (Object)this.expirationTime).add("creationTime", (Object)this.creationTime).add("lastModifiedTime", (Object)this.lastModifiedTime).add("numBytes", (Object)this.numBytes).add("numRows", (Object)this.numRows).add("definition", (Object)this.definition).add("encryptionConfiguration", (Object)this.encryptionConfiguration).add("labels", (Object)this.labels).toString();
    }

    public int hashCode() {
        return Objects.hash(this.tableId);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(TableInfo.class) && Objects.equals(this.toPb(), ((TableInfo)obj).toPb());
    }

    public static Builder newBuilder(TableId tableId, TableDefinition definition) {
        return new BuilderImpl().setTableId(tableId).setDefinition(definition);
    }

    public static TableInfo of(TableId tableId, TableDefinition definition) {
        return TableInfo.newBuilder(tableId, definition).build();
    }

    TableInfo setProjectId(String projectId) {
        if (Strings.isNullOrEmpty((String)this.getTableId().getProject())) {
            return this.toBuilder().setTableId(this.getTableId().setProjectId(projectId)).build();
        }
        return this;
    }

    Table toPb() {
        Table tablePb = this.definition.toPb();
        tablePb.setTableReference(this.tableId.toPb());
        if (this.lastModifiedTime != null) {
            tablePb.setLastModifiedTime(BigInteger.valueOf(this.lastModifiedTime));
        }
        tablePb.setCreationTime(this.creationTime);
        tablePb.setDescription(this.description);
        tablePb.setEtag(this.etag);
        tablePb.setExpirationTime(this.expirationTime);
        tablePb.setFriendlyName(this.friendlyName);
        tablePb.setId(this.generatedId);
        tablePb.setSelfLink(this.selfLink);
        if (this.encryptionConfiguration != null) {
            tablePb.setEncryptionConfiguration(this.encryptionConfiguration.toPb());
        }
        tablePb.setLabels(this.labels.toPb());
        return tablePb;
    }

    static TableInfo fromPb(Table tablePb) {
        return new BuilderImpl(tablePb).build();
    }

    static class BuilderImpl
    extends Builder {
        private String etag;
        private String generatedId;
        private String selfLink;
        private TableId tableId;
        private String friendlyName;
        private String description;
        private Long creationTime;
        private Long expirationTime;
        private Long lastModifiedTime;
        private Long numBytes;
        private BigInteger numRows;
        private TableDefinition definition;
        private EncryptionConfiguration encryptionConfiguration;
        private Labels labels = Labels.ZERO;

        BuilderImpl() {
        }

        BuilderImpl(TableInfo tableInfo) {
            this.etag = tableInfo.etag;
            this.generatedId = tableInfo.generatedId;
            this.selfLink = tableInfo.selfLink;
            this.tableId = tableInfo.tableId;
            this.friendlyName = tableInfo.friendlyName;
            this.description = tableInfo.description;
            this.creationTime = tableInfo.creationTime;
            this.expirationTime = tableInfo.expirationTime;
            this.lastModifiedTime = tableInfo.lastModifiedTime;
            this.numBytes = tableInfo.numBytes;
            this.numRows = tableInfo.numRows;
            this.definition = tableInfo.definition;
            this.encryptionConfiguration = tableInfo.encryptionConfiguration;
            this.labels = tableInfo.labels;
        }

        BuilderImpl(Table tablePb) {
            this.tableId = TableId.fromPb(tablePb.getTableReference());
            if (tablePb.getLastModifiedTime() != null) {
                this.setLastModifiedTime(tablePb.getLastModifiedTime().longValue());
            }
            this.description = tablePb.getDescription();
            this.expirationTime = tablePb.getExpirationTime();
            this.friendlyName = tablePb.getFriendlyName();
            this.creationTime = tablePb.getCreationTime();
            this.etag = tablePb.getEtag();
            this.generatedId = tablePb.getId();
            this.selfLink = tablePb.getSelfLink();
            this.numBytes = tablePb.getNumBytes();
            this.numRows = tablePb.getNumRows();
            this.definition = TableDefinition.fromPb(tablePb);
            if (tablePb.getEncryptionConfiguration() != null) {
                this.encryptionConfiguration = new EncryptionConfiguration.Builder(tablePb.getEncryptionConfiguration()).build();
            }
            this.labels = Labels.fromPb(tablePb.getLabels());
        }

        @Override
        Builder setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = (String)MoreObjects.firstNonNull((Object)description, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        public Builder setExpirationTime(Long expirationTime) {
            this.expirationTime = (Long)MoreObjects.firstNonNull((Object)expirationTime, (Object)Data.nullOf(Long.class));
            return this;
        }

        @Override
        public Builder setFriendlyName(String friendlyName) {
            this.friendlyName = (String)MoreObjects.firstNonNull((Object)friendlyName, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        Builder setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        Builder setNumBytes(Long numBytes) {
            this.numBytes = numBytes;
            return this;
        }

        @Override
        Builder setNumRows(BigInteger numRows) {
            this.numRows = numRows;
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setTableId(TableId tableId) {
            this.tableId = (TableId)Preconditions.checkNotNull((Object)tableId);
            return this;
        }

        @Override
        public Builder setDefinition(TableDefinition definition) {
            this.definition = (TableDefinition)Preconditions.checkNotNull((Object)definition);
            return this;
        }

        @Override
        public Builder setEncryptionConfiguration(EncryptionConfiguration configuration) {
            this.encryptionConfiguration = configuration;
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            this.labels = Labels.fromUser(labels);
            return this;
        }

        @Override
        public TableInfo build() {
            return new TableInfo(this);
        }
    }

    public static abstract class Builder {
        abstract Builder setCreationTime(Long var1);

        public abstract Builder setDescription(String var1);

        abstract Builder setEtag(String var1);

        public abstract Builder setExpirationTime(Long var1);

        public abstract Builder setFriendlyName(String var1);

        abstract Builder setGeneratedId(String var1);

        abstract Builder setLastModifiedTime(Long var1);

        abstract Builder setNumBytes(Long var1);

        abstract Builder setNumRows(BigInteger var1);

        abstract Builder setSelfLink(String var1);

        public abstract Builder setTableId(TableId var1);

        public abstract Builder setDefinition(TableDefinition var1);

        @BetaApi
        public abstract Builder setLabels(Map<String, String> var1);

        public abstract TableInfo build();

        public abstract Builder setEncryptionConfiguration(EncryptionConfiguration var1);
    }
}

