/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class Schema
implements Serializable {
    static final Function<TableSchema, Schema> FROM_PB_FUNCTION = new Function<TableSchema, Schema>(){

        public Schema apply(TableSchema pb) {
            return Schema.fromPb(pb);
        }
    };
    static final Function<Schema, TableSchema> TO_PB_FUNCTION = new Function<Schema, TableSchema>(){

        public TableSchema apply(Schema schema) {
            return schema.toPb();
        }
    };
    private static final long serialVersionUID = 5522743613515073017L;
    private final FieldList fields;

    private Schema(FieldList fields) {
        this.fields = (FieldList)Preconditions.checkNotNull((Object)fields);
    }

    public FieldList getFields() {
        return this.fields;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fields", (Object)this.fields).toString();
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Schema && Objects.equals(this.toPb(), ((Schema)obj).toPb());
    }

    public static Schema of(Iterable<Field> fields) {
        return new Schema(FieldList.of(fields));
    }

    public static Schema of(Field ... fields) {
        return new Schema(FieldList.of(fields));
    }

    TableSchema toPb() {
        TableSchema tableSchemaPb = new TableSchema();
        if (this.fields != null) {
            tableSchemaPb.setFields(this.fields.toPb());
        }
        return tableSchemaPb;
    }

    static Schema fromPb(TableSchema tableSchemaPb) {
        return Schema.of(FieldList.fromPb(tableSchemaPb.getFields()));
    }
}

